/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.validate.external.html5;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.transform.URIResolver;
import nu.validator.messages.MessageEmitterAdapter;
import nu.validator.servlet.imagereview.ImageCollector;
import nu.validator.source.SourceCode;
import nu.validator.validation.SimpleDocumentValidator;
import nu.validator.xml.SystemErrErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ro.sync.basic.xml.encoding.EncodingDetectorImpl;
import ro.sync.exml.validate.external.api.ExternalValidator;
import ro.sync.exml.validate.external.api.ValidationException;
import ro.sync.exml.validate.external.api.ValidationSeverity;
import ro.sync.exml.validate.external.html5.OxygenErrorEmitter;

public class HTML5Validator
implements ExternalValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HTML5Validator.class.getName());
    private static final String XHTML_MAIN_SCHEMA_URL = "http://s.validator.nu/xhtml5-rdfalite.rnc";
    private SimpleDocumentValidator validator = new SimpleDocumentValidator();
    private OxygenErrorEmitter oxygenErrorEmitter;
    private boolean errorsOnly;
    private boolean forceValidationAsXHTML;
    private ValidationException schemaException;

    public HTML5Validator() {
        this(false, false);
    }

    public HTML5Validator(boolean errorsOnly, boolean forceValidationAsXHTML) {
        this.errorsOnly = errorsOnly;
        this.forceValidationAsXHTML = forceValidationAsXHTML;
        try {
            this.setUp();
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The preparation for validation failed - no validation engine created: ", (Throwable)e);
            }
            this.schemaException = new ValidationException("Failed to create the validation engine: " + e.getMessage(), null, ValidationSeverity.FATAL, (Throwable)e);
        }
    }

    public List<ValidationException> validate(Reader reader, String systemID, URIResolver uriResolver, Map<String, String> additionalProperties) {
        List<ValidationException> exList;
        if (this.schemaException == null) {
            ValidationException parseException = null;
            try {
                BufferedReader bufferedReader = new BufferedReader(reader);
                InputSource inputSource = new InputSource(bufferedReader);
                inputSource.setSystemId(systemID);
                if (this.forceValidationAsXHTML) {
                    this.validator.checkXmlInputSource(inputSource);
                } else {
                    inputSource.setEncoding(new EncodingDetectorImpl().getHeaderIANAEncoding((Reader)bufferedReader, true));
                    bufferedReader.reset();
                    this.validator.checkHtmlInputSource(inputSource);
                }
            }
            catch (IOException | SAXException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Error while trying to validate: ", (Throwable)e);
                }
                parseException = new ValidationException("Error while trying to validate: " + e.getMessage(), systemID, ValidationSeverity.FATAL, (Throwable)e);
            }
            exList = this.oxygenErrorEmitter.getValidationExceptionList();
            this.oxygenErrorEmitter.clearValidationExceptionList();
            Collections.sort(exList, (p1, p2) -> {
                int diff = p1.getLineNumber() - p2.getLineNumber();
                return diff != 0 ? diff : p1.getColumnNumber() - p2.getColumnNumber();
            });
            if (parseException != null) {
                exList.add(0, parseException);
            }
        } else {
            exList = new ArrayList<ValidationException>(1);
            exList.add(this.schemaException);
        }
        return exList;
    }

    private void setUp() throws Exception {
        SourceCode sourceCode = this.validator.getSourceCode();
        this.oxygenErrorEmitter = new OxygenErrorEmitter();
        MessageEmitterAdapter errorHandler = new MessageEmitterAdapter(null, sourceCode, false, new ImageCollector(sourceCode), 0, true, this.oxygenErrorEmitter);
        errorHandler.setErrorsOnly(this.errorsOnly);
        errorHandler.setHtml(true);
        this.validator.setUpMainSchema(this.forceValidationAsXHTML ? XHTML_MAIN_SCHEMA_URL : "http://s.validator.nu/html5-rdfalite.rnc", new SystemErrErrorHandler());
        this.validator.setUpValidatorAndParsers(errorHandler, false, this.forceValidationAsXHTML);
    }
}

