/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.editor.editors;

import com.oxygenxml.editor.EditorPlugin;
import com.oxygenxml.editor.document.c;
import com.oxygenxml.editor.editors.OxygenBaseEditor;
import com.oxygenxml.editor.editors.ValidationBaseEditor;
import com.oxygenxml.editor.editors.v;
import com.oxygenxml.editor.editors.xml.d.g;
import com.oxygenxml.editor.h;
import com.oxygenxml.editor.swtutil.b;
import com.oxygenxml.editor.swtutil.qc;
import com.oxygenxml.editor.swtutil.qd;
import com.oxygenxml.editor.w;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.xml.encoding.EncodingChooser;
import ro.sync.ecss.extensions.api.ExtensionsBundle;
import ro.sync.ecss.persistance.CSSDescriptorPO;
import ro.sync.exml.editor.dg;
import ro.sync.exml.editor.persistance.DocumentTypePO;
import ro.sync.exml.editor.scenario.BaseScenario;
import ro.sync.exml.editor.scenario.l;
import ro.sync.exml.editor.ud;
import ro.sync.exml.editor.xmleditor.gc;
import ro.sync.exml.editor.xmleditor.k;
import ro.sync.exml.editor.xmleditor.o;
import ro.sync.exml.editor.xmleditor.transform.Scenario;
import ro.sync.exml.editor.xmleditor.transform.fb;
import ro.sync.exml.editor.xmleditor.transform.q;
import ro.sync.exml.editor.xmleditor.wb;
import ro.sync.exml.editor.ye;
import ro.sync.exml.options.Options;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.PROTECTED, fields=SkipLevel.PROTECTED, methods=SkipLevel.PROTECTED)
public abstract class TransformationEditor
extends ValidationBaseEditor
implements ro.sync.exml.editor.xmleditor.b {
    private static Logger mer = LoggerFactory.getLogger(TransformationEditor.class);
    protected static final String BREAKPOINT_GROUP_ID = "Breakpoint_Group_ID";
    private gc per;
    private v ner;
    private boolean ler = false;
    private final l ker = new l(){

        public void scenarioUpdated(BaseScenario baseScenario, byte by) {
            TransformationEditor.this.transformationScenarioUpdated(baseScenario, by);
        }

        public URL getMonitoredURL() {
            return TransformationEditor.this.getEditorLocation();
        }
    };
    private c oer = new c(){

        @Override
        public void fjm(DocumentEvent documentEvent) {
            if (TransformationEditor.this.getEditedIFile() != null) {
                try {
                    IMarker[] iMarkerArray = TransformationEditor.this.getEditedIFile().findMarkers(com.oxygenxml.editor.util.v.o(), false, 0);
                    if (iMarkerArray != null) {
                        TransformationEditor.this.updateBreakpointsLineAttr(iMarkerArray);
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    };

    protected void transformationScenarioUpdated(BaseScenario baseScenario, byte by) {
        if (ro.sync.exml.editor.validate.v.d((BaseScenario)baseScenario, (ro.sync.exml.editor.xmleditor.b)this)) {
            this.scheduleValidationTask(false);
        }
    }

    public gc getTransformationAssistant() {
        if (this.per == null) {
            try {
                this.per = new gc((ro.sync.exml.editor.xmleditor.b)this, this.getFileSaver(), (EncodingChooser)qc.taw(), 2000);
                this.per.rsd((o)new wb(){

                    public void ugm(List<Scenario> list, k k2) {
                        if (mer.isDebugEnabled()) {
                            mer.debug("transformationStarted()");
                        }
                        TransformationEditor.this.ler = true;
                        if (TransformationEditor.this.ner != null) {
                            TransformationEditor.this.ner.updateTransformState(TransformationEditor.this.ler, null);
                        }
                        TransformationEditor.this.setStatus(new dg(2.wgm(list) + " " + OxygenBaseEditor.messages.getString("Transformation") + " " + OxygenBaseEditor.messages.getString("In_progress"), false, 0, k2));
                    }

                    public void vgm(Scenario scenario, k k2) {
                        this.ugm(Arrays.asList(scenario), k2);
                    }

                    public void lgm(float f2, Scenario scenario, k k2) {
                        if (mer.isDebugEnabled()) {
                            mer.debug("transformationEnded()");
                        }
                        TransformationEditor.this.ler = false;
                        TransformationEditor.this.setStatus(new dg("[" + scenario.getName() + "] " + OxygenBaseEditor.messages.getString("Transformation") + " ( " + OxygenBaseEditor.messages.getString("Successfull") + "  " + f2 + "s )", true, 0, k2));
                        if (TransformationEditor.this.ner != null) {
                            TransformationEditor.this.ner.updateTransformState(TransformationEditor.this.ler, TransformationEditor.this.bhm());
                        }
                        super.lgm(f2, scenario, k2);
                    }

                    public void pgm() {
                        if (mer.isDebugEnabled()) {
                            mer.debug("transformationStopped()");
                        }
                        TransformationEditor.this.setStatus(new dg(OxygenBaseEditor.messages.getString("Transformation") + " " + OxygenBaseEditor.messages.getString("ended_by_user"), true, 2));
                        TransformationEditor.this.ler = false;
                        if (TransformationEditor.this.ner != null) {
                            TransformationEditor.this.ner.updateTransformState(TransformationEditor.this.ler, TransformationEditor.this.bhm());
                        }
                    }

                    public void qgm(Scenario scenario, k k2) {
                        if (mer.isDebugEnabled()) {
                            mer.debug("transformationFailed()");
                        }
                        TransformationEditor.this.ler = false;
                        TransformationEditor.this.setStatus(new dg("[" + scenario.getName() + "] " + OxygenBaseEditor.messages.getString("Transformation") + " " + OxygenBaseEditor.messages.getString("Failed"), true, 2, k2));
                        if (TransformationEditor.this.ner != null) {
                            TransformationEditor.this.ner.updateTransformState(TransformationEditor.this.ler, TransformationEditor.this.bhm());
                        }
                        super.qgm(scenario, k2);
                    }

                    public void jgm() {
                        if (TransformationEditor.this.ner != null) {
                            TransformationEditor.this.ner.updateTransformState(TransformationEditor.this.ler, TransformationEditor.this.bhm());
                        }
                    }

                    public void kgm() {
                        TransformationEditor.this.ler = true;
                    }

                    public void ngm() {
                        TransformationEditor.this.ler = false;
                    }

                    public void mgm() {
                        TransformationEditor.this.ler = false;
                        super.mgm();
                    }
                });
                q.lc().wb((l)this.per);
                q.lc().wb(this.ker);
            }
            catch (Throwable throwable) {
                mer.error((Object)throwable, throwable);
            }
        }
        return this.per;
    }

    public Thread performTransformation() {
        try {
            this.setSkipErrorCheck(true);
            Thread thread = this.getTransformationAssistant().zsd((fb)new g(this.getSite().getShell(), messages.getString("Transform_with"), null, false));
            return thread;
        }
        finally {
            this.setSkipErrorCheck(false);
        }
    }

    public void requestFocusInEditor() {
    }

    public void stopTransformation() {
        this.getTransformationAssistant().gsd();
    }

    public void configureTransformation() {
        try {
            this.setSkipErrorCheck(true);
            this.getTransformationAssistant().jsd((fb)new g(this.getSite().getShell()));
        }
        finally {
            this.setSkipErrorCheck(false);
        }
    }

    public File promptForOutputFile() {
        b b2 = new b(this.getSite().getShell(), null, 1, 8192, true);
        if (b2.open() == 0) {
            return b2.wkb()[0].getLocation().toFile();
        }
        return null;
    }

    public void setActionBarContributor(v v2) {
        this.ner = v2;
        if (this.ner != null) {
            this.ner.updateTransformState(this.ler, this.bhm());
        }
    }

    private String bhm() {
        String string = messages.getString("Apply_style_sheet_tooltip");
        List list = this.getTransformationAssistant().btd();
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(string).append(" [");
            for (BaseScenario baseScenario : list) {
                if (list.size() > 1) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(baseScenario.getName());
            }
            stringBuilder.append("]");
        }
        return string;
    }

    public boolean availableBreakpointSupport() {
        return this.getEditorInput() instanceof IFileEditorInput;
    }

    protected void addBreakpointStuff(IMenuManager iMenuManager) {
        block6: {
            if (this.isEditable()) {
                this.addGroup(iMenuManager, "additions", BREAKPOINT_GROUP_ID);
                try {
                    int n2 = this.getLineForLastMouseOrCaretActivity();
                    IMarker iMarker = com.oxygenxml.dxsl.breakpoints.b.szl().uzl(this.getSystemId(), n2);
                    if (iMarker == null) {
                        this.getAction("com.oxygenxml.editor.addBreakpoint").setEnabled(this.getDocument().getNumberOfLines() >= n2);
                        this.addAction(iMenuManager, BREAKPOINT_GROUP_ID, "com.oxygenxml.editor.addBreakpoint");
                    } else {
                        boolean bl = iMarker.getAttribute("toggleState", true);
                        this.addAction(iMenuManager, BREAKPOINT_GROUP_ID, "com.oxygenxml.editor.toggleBreakpoint");
                        this.addAction(iMenuManager, BREAKPOINT_GROUP_ID, "com.oxygenxml.editor.removeBreakpoint");
                        IAction iAction = this.getAction("com.oxygenxml.editor.toggleBreakpoint");
                        if (iAction != null) {
                            ((h)iAction).xyd(bl ? "Disable_breakpoint" : "Enable_breakpoint", true);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!mer.isDebugEnabled()) break block6;
                    mer.debug((Object)throwable, throwable);
                }
            }
        }
    }

    protected boolean useBreakpointSupport() {
        return true;
    }

    @Override
    protected void rulerContextMenuIsAboutToShow(IMenuManager iMenuManager) {
        super.rulerContextMenuIsAboutToShow(iMenuManager);
        if (this.availableBreakpointSupport() && this.useBreakpointSupport()) {
            this.addBreakpointStuff(iMenuManager);
        }
    }

    @Override
    protected void createActions() {
        super.createActions();
        if (this.useBreakpointSupport() && this.availableBreakpointSupport()) {
            IActionBars iActionBars = this.getActionBars();
            h h2 = new h("Add_breakpoint", "Breakpoints"){

                @Override
                public void jyd() {
                    try {
                        int n2 = TransformationEditor.this.getLineForLastMouseOrCaretActivity();
                        if (n2 >= 0 && n2 < TransformationEditor.this.getDocument().getNumberOfLines()) {
                            com.oxygenxml.dxsl.breakpoints.b.szl().rzl(TransformationEditor.this.getEditedIFile(), n2, null);
                        }
                    }
                    catch (Throwable throwable) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                qd.bb(EditorPlugin.getActiveWorkbenchWindow().getShell(), ggf.getString("Invalid_breakpoint"), throwable.getMessage());
                            }
                        });
                    }
                    finally {
                        TransformationEditor.this.rulerOperation = false;
                    }
                }
            };
            h2.setActionDefinitionId("com.oxygenxml.editor.addBreakpoint");
            h2.tyd(this.getTextOnlyPageDetector());
            this.allActions.add(h2);
            this.setAction("com.oxygenxml.editor.addBreakpoint", (IAction)h2);
            iActionBars.setGlobalActionHandler("com.oxygenxml.editor.addBreakpoint", (IAction)h2);
            h2 = new h("Enable_breakpoint", "Breakpoints"){

                @Override
                public void jyd() {
                    try {
                        com.oxygenxml.dxsl.breakpoints.b.szl().xzl(TransformationEditor.this.getEditedIFile(), TransformationEditor.this.getLineForLastMouseOrCaretActivity());
                    }
                    catch (Throwable throwable) {
                        mer.warn((Object)throwable, throwable);
                    }
                    finally {
                        TransformationEditor.this.rulerOperation = false;
                    }
                }
            };
            h2.setActionDefinitionId("com.oxygenxml.editor.toggleBreakpoint");
            h2.tyd(this.getTextOnlyPageDetector());
            this.allActions.add(h2);
            this.setAction("com.oxygenxml.editor.toggleBreakpoint", (IAction)h2);
            iActionBars.setGlobalActionHandler("com.oxygenxml.editor.toggleBreakpoint", (IAction)h2);
            h2 = new h("Remove_breakpoint", "Breakpoints"){

                @Override
                public void jyd() {
                    try {
                        com.oxygenxml.dxsl.breakpoints.b.szl().yzl(TransformationEditor.this.getEditedIFile(), TransformationEditor.this.getLineForLastMouseOrCaretActivity());
                    }
                    catch (Throwable throwable) {
                        mer.warn((Object)throwable, throwable);
                    }
                    finally {
                        TransformationEditor.this.rulerOperation = false;
                    }
                }
            };
            h2.setActionDefinitionId("com.oxygenxml.editor.removeBreakpoint");
            h2.tyd(this.getTextOnlyPageDetector());
            this.allActions.add(h2);
            this.setAction("com.oxygenxml.editor.removeBreakpoint", (IAction)h2);
            iActionBars.setGlobalActionHandler("com.oxygenxml.editor.removeBreakpoint", (IAction)h2);
            h2 = new h("RulerDoubleClick", "Breakpoints"){

                @Override
                public void jyd() {
                    try {
                        TransformationEditor.this.rulerOperation = true;
                        int n2 = TransformationEditor.this.getLineForLastMouseOrCaretActivity();
                        if (n2 >= 0 && n2 < TransformationEditor.this.getDocument().getNumberOfLines()) {
                            if (com.oxygenxml.dxsl.breakpoints.b.szl().uzl(TransformationEditor.this.getSystemId(), n2) == null) {
                                com.oxygenxml.dxsl.breakpoints.b.szl().rzl(TransformationEditor.this.getEditedIFile(), n2, null);
                            } else {
                                com.oxygenxml.dxsl.breakpoints.b.szl().yzl(TransformationEditor.this.getEditedIFile(), n2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (mer.isDebugEnabled()) {
                            mer.debug((Object)throwable, throwable);
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                qd.bb(EditorPlugin.getActiveWorkbenchWindow().getShell(), ggf.getString("Invalid_breakpoint"), throwable.getMessage());
                            }
                        });
                    }
                    finally {
                        TransformationEditor.this.rulerOperation = false;
                    }
                }
            };
            this.setAction("RulerDoubleClick", (IAction)h2);
            h2.tyd(this.getTextOnlyPageDetector());
        }
    }

    @Override
    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        IEditorInput iEditorInput2 = this.getEditorInput();
        boolean bl = iEditorInput2 != null && iEditorInput2 instanceof IFileEditorInput;
        List list = null;
        if (bl) {
            list = q.lc().xc((ro.sync.exml.editor.xmleditor.b)this, false);
        }
        super.doSetInput(iEditorInput);
        if (bl && list != null) {
            q.lc().qc((ro.sync.exml.editor.xmleditor.b)this, list);
        }
        if (this.availableBreakpointSupport()) {
            this.addInhibitableDocumentChangeListener(this.oer);
        }
    }

    @Override
    public void dispose() {
        if (this.availableBreakpointSupport()) {
            this.removeInhibitableDocumentChangeListener(this.oer);
        }
        if (this.per != null) {
            q.lc().z((l)this.per);
        }
        q.lc().z(this.ker);
        super.dispose();
    }

    protected void updateBreakpointsLineAttr(IMarker[] iMarkerArray) {
        IAnnotationModel iAnnotationModel = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (iAnnotationModel instanceof AbstractMarkerAnnotationModel) {
            AbstractMarkerAnnotationModel abstractMarkerAnnotationModel = (AbstractMarkerAnnotationModel)iAnnotationModel;
            for (int i2 = 0; i2 < iMarkerArray.length; ++i2) {
                IMarker iMarker = iMarkerArray[i2];
                Position position = abstractMarkerAnnotationModel.getMarkerPosition(iMarker);
                if (position == null || position.isDeleted()) continue;
                try {
                    int n2 = this.getDocument().getLineOfOffset(position.getOffset());
                    int n3 = iMarker.getAttribute("lineNumber", -1);
                    if (n3 == n2 + 1) continue;
                    iMarker.setAttribute("lineNumber", n2 + 1);
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    continue;
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }

    public StreamSource createXMLSource(URL uRL) throws IOException {
        return com.oxygenxml.editor.util.b.b(uRL);
    }

    public StreamSource createInstructionSource(URL uRL) throws IOException {
        return com.oxygenxml.editor.util.b.b(uRL);
    }

    public DocumentTypePO getDocumentType() {
        return ye.b((ud)this);
    }

    public CSSDescriptorPO[] getCSSDescriptors() {
        return ye.d((ud)this);
    }

    public ExtensionsBundle getExtensionsBundle() {
        return ye.e((ud)this);
    }

    public void handleSaveBeforeTransform(boolean bl) {
        if (bl) {
            if (this.isModified() && ro.sync.exml.v.getInstance().showConfirmDialog(messages.getString("Save"), messages.getString("This_operation_ignores_unsaved_changes") + ".\n " + messages.getString("Do_you_want_to_save")) == 0) {
                this.save();
            }
        } else {
            boolean bl2 = Options.getInstance().getBooleanProperty("save.all.before.transformation.or.validation");
            w.fxe(null, com.oxygenxml.editor.f.c.g.lcm(), !bl2);
        }
    }

    public void close(boolean bl) {
        if (this.per != null) {
            q.lc().z((l)this.per);
        }
        q.lc().z(this.ker);
        super.close(bl);
    }
}

