/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.utils;

import com.oxygenxml.batch.converter.core.utils.ConverterReaderUtils;
import com.oxygenxml.batch.converter.core.utils.ResourceTypes;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConverterFileUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)ConverterFileUtils.class.getName());

    private ConverterFileUtils() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String readFile(File file) throws IOException {
        Reader reader = ConverterReaderUtils.createReader(file);
        return ConverterReaderUtils.getString(reader);
    }

    public static List<File> getAllFiles(File file, List<String> extensionsFiles) {
        ArrayList<File> toReturn = new ArrayList<File>();
        if (file.isDirectory()) {
            File[] listOfFiles = file.listFiles();
            if (listOfFiles != null) {
                int size = listOfFiles.length;
                for (int i = 0; i < size; ++i) {
                    toReturn.addAll(ConverterFileUtils.getAllFiles(listOfFiles[i], extensionsFiles));
                }
            }
        } else if (file.isFile()) {
            String fileName = file.getName();
            String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
            if (extensionsFiles.contains(extension)) {
                toReturn.add(file);
            }
        } else {
            logger.warn("Unknown file type for: {}", (Object)file);
        }
        return toReturn;
    }

    public static File getUniqueOutputFile(File originalFile, String extension, File outputFolder) {
        File outputFile = ConverterFileUtils.getOutputFile(originalFile, extension, outputFolder);
        return ConverterFileUtils.getUniqueFileWithCounter(outputFile);
    }

    public static File getOutputFile(File originalFile, String extension, File outputFolder) {
        String fileName = originalFile.getName();
        fileName = fileName.substring(0, fileName.lastIndexOf(46));
        return new File(outputFolder.getAbsolutePath() + File.separator + fileName + "." + extension);
    }

    public static String copyResource(File resourceToCopy, ResourceTypes resourceType, File conversionOutputDir, List<String> problemsCollector) {
        File targetLocationDir = new File(conversionOutputDir, resourceType.getDirectoryName());
        if (!targetLocationDir.exists()) {
            targetLocationDir.mkdirs();
        }
        String fileName = resourceToCopy.getName();
        int dotIndex = fileName.lastIndexOf(46);
        int searchIndex = Math.max(0, dotIndex);
        int queryIndex = fileName.indexOf(63, searchIndex);
        int anchorIndex = fileName.indexOf(35, searchIndex);
        String queryAndAnchor = "";
        if (queryIndex != -1 || anchorIndex != -1) {
            int firstValidIndex = queryIndex != -1 && anchorIndex != -1 ? Math.min(queryIndex, anchorIndex) : Math.max(queryIndex, anchorIndex);
            queryAndAnchor = fileName.substring(firstValidIndex);
            fileName = fileName.substring(0, firstValidIndex);
            resourceToCopy = new File(resourceToCopy.getParentFile(), fileName);
        }
        File targetFile = new File(targetLocationDir, fileName);
        File existentCopy = ConverterFileUtils.checkDirectoryContainsACopy(targetLocationDir, resourceToCopy);
        if (existentCopy != null) {
            targetFile = existentCopy;
        } else {
            targetFile = ConverterFileUtils.getUniqueFileWithCounter(targetFile);
            try {
                Files.copy(resourceToCopy.toPath(), targetFile.toPath(), new CopyOption[0]);
            }
            catch (NoSuchFileException e) {
                problemsCollector.add("The '" + fileName + "' resource cannot be copied to output directory: The '" + resourceToCopy.getAbsolutePath() + "' doesn't exist.");
            }
            catch (IOException e) {
                problemsCollector.add("The '" + fileName + "' resource cannot be copied to output directory: " + e.getMessage());
            }
        }
        return resourceType.getDirectoryName() + "/" + targetFile.getName() + queryAndAnchor;
    }

    private static File checkDirectoryContainsACopy(File directory, File resource) {
        File toRet = null;
        if (resource.exists()) {
            String fileName;
            String name = fileName = resource.getName();
            String extension = "";
            byte[] resourceHash = null;
            int indexOfDot = fileName.lastIndexOf(46);
            if (indexOfDot != -1) {
                name = fileName.substring(0, indexOfDot);
                extension = fileName.substring(indexOfDot + 1);
            }
            File posibleCopy = new File(directory, fileName);
            int counter = 1;
            while (posibleCopy.exists()) {
                try {
                    if (Files.size(posibleCopy.toPath()) == Files.size(resource.toPath())) {
                        byte[] possibleFileHash;
                        if (resourceHash == null) {
                            resourceHash = ConverterFileUtils.generateMD5(resource);
                        }
                        if (Arrays.equals(resourceHash, possibleFileHash = ConverterFileUtils.generateMD5(posibleCopy))) {
                            toRet = posibleCopy;
                            break;
                        }
                    }
                }
                catch (IOException | NoSuchAlgorithmException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                posibleCopy = new File(directory, ConverterFileUtils.computeNewFileName(name, counter, extension, false));
                ++counter;
            }
        }
        return toRet;
    }

    private static byte[] generateMD5(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);
             BufferedInputStream bis = new BufferedInputStream(stream);){
            int eightKB = 8192;
            byte[] dataBytes = new byte[8192];
            int nread = 0;
            while ((nread = bis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
        }
        return md.digest();
    }

    public static String getFileExtension(File file) {
        String extension = "";
        String fileName = file.getName();
        int indexOfDot = fileName.lastIndexOf(46);
        if (indexOfDot != -1) {
            extension = fileName.substring(indexOfDot);
            if (extension.contains("#")) {
                extension = extension.substring(0, extension.indexOf(35));
            }
            if (extension.contains("?")) {
                extension = extension.substring(0, extension.indexOf(63));
            }
        }
        return extension;
    }

    public static File getUniqueFileWithCounter(File file) {
        return ConverterFileUtils.getUniqueFileWithCounter(file, 1, false);
    }

    public static File getUniqueFileWithCounter(File file, boolean shouldUseHyphen) {
        return ConverterFileUtils.getUniqueFileWithCounter(file, 1, shouldUseHyphen);
    }

    public static File getUniqueFileWithCounter(File file, int startCounter, boolean shouldUseHyphen) {
        String fileName;
        String name = fileName = file.getName();
        String extension = "";
        int indexOfDot = fileName.lastIndexOf(46);
        if (indexOfDot != -1) {
            name = fileName.substring(0, indexOfDot);
            extension = fileName.substring(indexOfDot + 1);
        }
        File parentDir = file.getParentFile();
        while (file.exists()) {
            fileName = ConverterFileUtils.computeNewFileName(name, startCounter, extension, shouldUseHyphen);
            file = new File(parentDir, fileName);
            ++startCounter;
        }
        return file;
    }

    private static String computeNewFileName(String name, int counter, String extension, boolean shouldUseHyphen) {
        StringBuilder fileName = new StringBuilder(name);
        if (shouldUseHyphen) {
            fileName.append('-').append(counter);
        } else {
            fileName.append('(').append(counter).append(')');
        }
        if (!extension.isEmpty()) {
            fileName.append(".").append(extension);
        }
        return fileName.toString();
    }
}

