/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.printers;

import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.doctype.DoctypeGetter;
import javax.xml.transform.Transformer;

public final class ContentPrinterUtils {
    private ContentPrinterUtils() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static Transformer configureDoctypeInTransformer(Transformer transformer, ConversionResult conversionResult, String converterType) {
        String publicDocType;
        String systemDocType = DoctypeGetter.getSystemDoctype(conversionResult, converterType);
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        if (!systemDocType.isEmpty()) {
            transformer.setOutputProperty("doctype-system", systemDocType);
        }
        if (!(publicDocType = DoctypeGetter.getPublicDoctype(conversionResult, converterType)).isEmpty()) {
            transformer.setOutputProperty("doctype-public", publicDocType);
        }
        return transformer;
    }

    public static boolean shouldAddDoctype(ConversionResult conversionResult, String converterType) {
        return !DoctypeGetter.getPublicDoctype(conversionResult, converterType).isEmpty() || !DoctypeGetter.getSystemDoctype(conversionResult, converterType).isEmpty() || !DoctypeGetter.getDoctype(conversionResult, converterType).isEmpty();
    }
}

