/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.yaml;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.converters.ConverterUtils;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import com.oxygenxml.batch.converter.core.utils.ConverterFileUtils;
import com.oxygenxml.batch.converter.core.utils.ConverterReaderUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import javax.xml.transform.TransformerException;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

public class JsonToXmlConverter
implements Converter {
    @Override
    public ConversionResult convert(File originalFileLocation, Reader contentReader, TransformerFactoryCreator transformerCreator, ConversionInputsProvider userInputsProvider) throws TransformerException {
        StringBuilder convertedContent = new StringBuilder();
        String jsonContent = "";
        try {
            jsonContent = contentReader == null ? ConverterFileUtils.readFile(originalFileLocation) : ConverterReaderUtils.getString(contentReader);
            JSONObject jsonObject = new JSONObject(jsonContent);
            String xmlContent = XML.toString((Object)jsonObject);
            if (jsonObject.length() != 1) {
                convertedContent.append("<JSON>");
                convertedContent.append(xmlContent);
                convertedContent.append("</JSON>");
            } else {
                convertedContent.append(xmlContent);
            }
        }
        catch (IOException | JSONException e) {
            throw ConverterUtils.getTransformerException(e);
        }
        return new ConversionResult(convertedContent.toString());
    }
}

