/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.word;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.converters.ConverterUtils;
import com.oxygenxml.batch.converter.core.converters.word.FileImageManager;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import com.oxygenxml.batch.converter.core.word.styles.WordStyleMapLoader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.AbstractWordUtils;
import org.apache.poi.hwpf.converter.PicturesManager;
import org.apache.poi.hwpf.converter.WordToHtmlConverter;
import org.dita.dost.util.CatalogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.zwobble.mammoth.DocumentConverter;
import org.zwobble.mammoth.Result;
import org.zwobble.mammoth.images.ImageConverter;
import org.zwobble.mammoth.internal.conversion.UnknownStylesReporter;

public class WordToXHTMLConverter
implements Converter {
    private static final Logger logger = LoggerFactory.getLogger(WordToXHTMLConverter.class);
    private static final String DOCX_EXTENSION = "docx";
    boolean shouldConvertNotesIntoAList = true;

    public WordToXHTMLConverter() {
    }

    public WordToXHTMLConverter(boolean shouldConvertNotesIntoAList) {
        this.shouldConvertNotesIntoAList = shouldConvertNotesIntoAList;
    }

    @Override
    public ConversionResult convert(File originalFile, Reader contentReader, TransformerFactoryCreator transformerCreator, ConversionInputsProvider userInputsProvider) throws TransformerException {
        String convertedContent = "";
        try {
            Boolean shouldForbidCreatingExternalContent = userInputsProvider.getAdditionalOptionValue("forbid.creating.external.content");
            boolean shouldSaveImages = shouldForbidCreatingExternalContent == null || shouldForbidCreatingExternalContent == false;
            FileImageManager imageManager = new FileImageManager(userInputsProvider.getOutputFolder(), originalFile, shouldSaveImages);
            convertedContent = originalFile.getAbsolutePath().toLowerCase().endsWith(DOCX_EXTENSION) ? this.convertDocxFile(originalFile, imageManager, transformerCreator) : this.convertDocFile(originalFile, imageManager);
        }
        catch (Exception e) {
            throw ConverterUtils.getTransformerException(e);
        }
        return new ConversionResult(convertedContent);
    }

    public String convertDocxFile(File file, ImageConverter.ImgElement imagesManager, TransformerFactoryCreator transformerFactory) throws IOException {
        String htmlContent;
        UnknownStylesReporter unknownStylesReporter;
        String styleMap;
        try {
            styleMap = WordStyleMapLoader.loadStyleMap(this.getClass().getClassLoader());
        }
        catch (JAXBException e) {
            StringBuilder message = new StringBuilder();
            message.append("Invalid Word style map configuration file: ");
            if (e.getLinkedException() != null) {
                message.append(e.getLinkedException().getMessage());
            } else {
                message.append(e.getMessage());
            }
            throw new IOException(message.toString());
        }
        DocumentConverter converter = new DocumentConverter();
        if (styleMap != null) {
            converter = converter.addStyleMap(styleMap);
        }
        if ((unknownStylesReporter = WordStyleMapLoader.getUnknownStylesReporter()) != null) {
            converter = converter.setUnknownStylesReporter(unknownStylesReporter);
        }
        converter = converter.imageConverter(imagesManager).setConverterNotesToList(this.shouldConvertNotesIntoAList);
        Result result = converter.convertToHtml(file);
        if (logger.isDebugEnabled()) {
            logger.debug("Warnings from the conversion process: {}", (Object)result.getWarnings());
        }
        if ((htmlContent = WordToXHTMLConverter.wrapHtmlBodyContent((String)result.getValue())).contains("<!--<m:oMath")) {
            htmlContent = WordToXHTMLConverter.resolveMaths(htmlContent, transformerFactory);
        }
        return htmlContent;
    }

    public String convertDocFile(File file, PicturesManager picturesManager) throws IOException, ParserConfigurationException, TransformerException {
        HWPFDocumentCore wordDocument = AbstractWordUtils.loadDoc((File)file);
        WordToHtmlConverter wordToHtmlConverter = new WordToHtmlConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
        wordToHtmlConverter.setPicturesManager(picturesManager);
        wordToHtmlConverter.processDocument(wordDocument);
        Document htmlDocument = wordToHtmlConverter.getDocument();
        String result = "";
        try (StringWriter stringWriter = new StringWriter();){
            DOMSource domSource = new DOMSource(htmlDocument);
            StreamResult streamResult = new StreamResult(stringWriter);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("method", "xhtml");
            serializer.transform(domSource, streamResult);
            result = stringWriter.toString();
        }
        String html = URLEncoder.encode(result, StandardCharsets.UTF_8.name());
        return URLDecoder.decode(html, StandardCharsets.UTF_8.name());
    }

    private static String wrapHtmlBodyContent(String bodyContent) {
        return "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n" + "<head><title/></head>\n<body>" + bodyContent + "\n</body>\n</html>";
    }

    private static String resolveMaths(String htmlContent, TransformerFactoryCreator transformerCreator) {
        try {
            Source resolved;
            boolean wasXslResolved = false;
            Transformer transformer = transformerCreator.createTransformer(null);
            URIResolver uriResolver = transformer.getURIResolver();
            String teiXslPath = "http://www.tei-c.org/release/xml/tei/stylesheet/docx/from/omml2mml.xsl";
            if (uriResolver != null) {
                resolved = uriResolver.resolve(teiXslPath, "");
                boolean bl = wasXslResolved = resolved != null && !teiXslPath.equals(resolved.getSystemId());
            }
            if (!wasXslResolved) {
                teiXslPath = "plugin:org.dita4publishers.word2dita:xsl/omml2mml.xsl";
                uriResolver = CatalogUtils.getCatalogResolver();
                resolved = uriResolver.resolve(teiXslPath, "");
                boolean bl = wasXslResolved = resolved != null && !teiXslPath.equals(resolved.getSystemId());
            }
            if (wasXslResolved) {
                StringBuilder xslt = new StringBuilder(50).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n    xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\"\n    exclude-result-prefixes=\"xs\"\n    version=\"3.0\">\n    <xsl:include href=\"").append(teiXslPath).append("\"/>\n    \n    <xsl:template match=\"node() | @*\">\n        <xsl:copy>\n            <xsl:apply-templates select=\"node() | @*\"/>\n        </xsl:copy>\n    </xsl:template>\n    <xsl:template match=\"m:oMath\" >\n        <math xmlns='http://www.w3.org/1998/Math/MathML'>\n            <xsl:apply-templates/>\n        </math>    \n    </xsl:template>\n    <xsl:template match=\"comment()[starts-with(., '&lt;m:oMath')]\">\n            <xsl:apply-templates select=\"parse-xml(.)\"/>\n    </xsl:template>\n    <xsl:template match=\"m:ctrlPr\">\n            <!-- EXM-50556 Ignore this element -->\n    </xsl:template>\n</xsl:stylesheet>");
                StreamSource src = new StreamSource(new StringReader(xslt.toString()));
                transformer = transformerCreator.createTransformer(src);
                transformer.setURIResolver(uriResolver);
                StringWriter sw = new StringWriter();
                transformer.transform(new StreamSource(new StringReader(htmlContent)), new StreamResult(sw));
                htmlContent = sw.toString();
            }
        }
        catch (TransformerException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        return htmlContent;
    }
}

