/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.word;

import com.oxygenxml.batch.converter.core.utils.ConverterFileUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.poi.hwpf.converter.PicturesManager;
import org.apache.poi.hwpf.usermodel.PictureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zwobble.mammoth.images.Image;
import org.zwobble.mammoth.images.ImageConverter;
import ro.sync.basic.io.FilePathToURI;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.basic.util.URLUtil;

public class FileImageManager
implements PicturesManager,
ImageConverter.ImgElement {
    private static final Logger logger = LoggerFactory.getLogger(FileImageManager.class);
    private static final String IMAGES_FILE_NAME = "image";
    private static final String MEDIA_DIR_DEFAULT_NAME = "media";
    private File mediaDir;
    private static File imposedMediaDir;
    private final Map<String, Integer> lastImageFileNameCounterMap = new HashMap<String, Integer>();
    private static final Map<String, String> MIME_EXTENSION;
    private final File baseDir;
    private boolean allowSavingImages;

    public FileImageManager(File baseDir, File inputFile, boolean allowSavingImages) {
        this.baseDir = baseDir;
        this.allowSavingImages = allowSavingImages;
        if (imposedMediaDir == null) {
            this.generateAnUniqueMediaDir(baseDir, inputFile);
        } else {
            this.mediaDir = imposedMediaDir;
        }
    }

    private void generateAnUniqueMediaDir(File parentDir, File inputFile) {
        this.mediaDir = new File(parentDir, MEDIA_DIR_DEFAULT_NAME);
        if (this.mediaDir.exists()) {
            String fileName = URLUtil.extractFileName((String)inputFile.getAbsolutePath());
            fileName = URLUtil.removeExtension((String)fileName);
            this.mediaDir = new File(parentDir, "media-" + fileName);
            this.mediaDir = ConverterFileUtils.getUniqueFileWithCounter(this.mediaDir, true);
        }
    }

    public String savePicture(byte[] content, PictureType pictureType, String suggestedName, float widthInches, float heightInches) {
        String extension = "png";
        if (pictureType != null) {
            extension = pictureType.getExtension();
        }
        String imgRelativePath = "";
        if (this.allowSavingImages) {
            try {
                imgRelativePath = this.saveImageInternal(new ByteArrayInputStream(content), null, extension);
            }
            catch (IOException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        } else {
            imgRelativePath = suggestedName;
        }
        return imgRelativePath;
    }

    public Map<String, String> convert(Image image) throws IOException {
        Optional altText;
        HashMap<String, String> attributes = new HashMap<String, String>();
        String imagePath = image.getPath();
        imagePath = imagePath.replace('\\', '/');
        attributes.put("src", FilePathToURI.filepath2URI((String)imagePath));
        if (this.allowSavingImages) {
            boolean isLinkedImage = false;
            try {
                isLinkedImage = new URI(imagePath).isAbsolute();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (!isLinkedImage) {
                String extension = null;
                String contentType = image.getContentType();
                if (contentType != null) {
                    extension = MIME_EXTENSION.get(contentType);
                }
                if (extension == null) {
                    extension = URLUtil.getExtension((String)imagePath);
                }
                if (extension != null && !extension.isEmpty()) {
                    String providedFileName = null;
                    if (!imagePath.isEmpty()) {
                        File file = new File(this.mediaDir, imagePath);
                        providedFileName = file.getName();
                    }
                    String relativePath = this.saveImageInternal(image.getInputStream(), providedFileName, extension);
                    attributes.put("src", relativePath);
                } else {
                    logger.debug("Cannot compute extension for image: '%s' with content: '%s'", (Object)imagePath, (Object)contentType);
                }
            }
        }
        if ((altText = image.getAltText()).isPresent()) {
            attributes.put("alt", (String)altText.get());
        }
        return attributes;
    }

    String saveImageInternal(InputStream imageIs, String proposedName, String extension) throws IOException {
        File uniqueImageFile;
        File imageFile;
        if (proposedName != null && !proposedName.isEmpty()) {
            imageFile = new File(this.mediaDir, proposedName);
            uniqueImageFile = ConverterFileUtils.getUniqueFileWithCounter(imageFile, false);
        } else {
            imageFile = new File(this.mediaDir, "image." + extension);
            Integer lastImageCounter = this.lastImageFileNameCounterMap.get(extension);
            if (lastImageCounter == null) {
                lastImageCounter = 0;
            }
            uniqueImageFile = ConverterFileUtils.getUniqueFileWithCounter(imageFile, lastImageCounter + 1, true);
            String name = uniqueImageFile.getName();
            int openBracket = name.lastIndexOf(45);
            int counterValue = 0;
            if (openBracket != -1) {
                String strValue = name.substring(openBracket + 1);
                try {
                    counterValue = NumberParserUtil.valueOfInteger((String)strValue);
                }
                catch (NumberFormatException e) {
                    logger.debug("Cannot parse number: {}", (Object)strValue, (Object)e);
                }
            }
            this.lastImageFileNameCounterMap.put(extension, counterValue);
        }
        uniqueImageFile.getParentFile().mkdirs();
        Files.copy(imageIs, uniqueImageFile.toPath(), new CopyOption[0]);
        int rootLength = this.baseDir.getAbsolutePath().length();
        String absFileName = uniqueImageFile.getAbsolutePath();
        String relativePath = absFileName.substring(rootLength + 1).replace('\\', '/');
        return FilePathToURI.filepath2URI((String)relativePath);
    }

    public static final void imposeMediaDirectoryInOutput(File imposedMediaDirectory) {
        imposedMediaDir = imposedMediaDirectory;
    }

    static {
        HashMap<String, String> mimeExtension = new HashMap<String, String>(19);
        mimeExtension.put("image/bmp", "bmp");
        mimeExtension.put("image/cis-cod", "cod");
        mimeExtension.put("image/gif", "gif");
        mimeExtension.put("image/png", "png");
        mimeExtension.put("image/jpeg", "jpg");
        mimeExtension.put("image/pipeg", "jfif");
        mimeExtension.put("image/svg+xml", "svg");
        mimeExtension.put("image/wmf", "wmf");
        mimeExtension.put("image/tiff", "tif");
        mimeExtension.put("image/x-cmx", "cmx");
        mimeExtension.put("image/x-icon", "ico");
        mimeExtension.put("image/x-portable-anymap", "pnm");
        mimeExtension.put("image/x-portable-bitmap", "pbm");
        mimeExtension.put("image/x-portable-graymap", "pgm");
        mimeExtension.put("image/x-portable-pixmap", "ppm");
        mimeExtension.put("image/x-rgb", "rgb");
        mimeExtension.put("image/x-xbitmap", "xbm");
        mimeExtension.put("image/x-xpixmap", "xpm");
        mimeExtension.put("image/x-xwindowdump", "xwd");
        MIME_EXTENSION = Collections.unmodifiableMap(mimeExtension);
    }
}

