/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.markdown;

import com.elovirta.dita.markdown.ExternalOptionProvider;
import com.elovirta.dita.markdown.MarkdownReader;
import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.converters.ConverterUtils;
import com.oxygenxml.batch.converter.core.converters.markdown.MarkdownToDitaFilter;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import com.oxygenxml.batch.converter.core.utils.ConverterReaderUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class MarkdownToDitaInternalConverter
implements Converter {
    private static final String KEY_TRANSFORMER_FACTORY = "javax.xml.transform.TransformerFactory";
    private static final String VALUE_TRANSFORMER_FACTORY = "net.sf.saxon.TransformerFactoryImpl";

    @Override
    public ConversionResult convert(File originalFileLocation, Reader contentReader, TransformerFactoryCreator transformerCreator, final ConversionInputsProvider userInputsProvider) throws TransformerException {
        Transformer transformer = transformerCreator.createTransformer(null);
        String property = System.getProperty(KEY_TRANSFORMER_FACTORY);
        System.setProperty(KEY_TRANSFORMER_FACTORY, VALUE_TRANSFORMER_FACTORY);
        String convertedContent = "";
        try (StringWriter sw = new StringWriter();){
            MarkdownReader r = new MarkdownReader(new ExternalOptionProvider(){

                public boolean shouldCreateShortdescParagraph() {
                    Boolean shouldCreateShortdesc = userInputsProvider.getAdditionalOptionValue("create.short.description");
                    return shouldCreateShortdesc != null && shouldCreateShortdesc != false;
                }

                public boolean shouldHandleKeyrefs() {
                    return true;
                }

                public boolean isBatchConverterContext() {
                    return true;
                }
            });
            if (contentReader == null) {
                contentReader = ConverterReaderUtils.createReader(originalFileLocation);
            }
            transformer.transform(new SAXSource(new MarkdownToDitaFilter((XMLReader)r), new InputSource(contentReader)), new StreamResult(sw));
            convertedContent = sw.toString();
        }
        catch (TransformerException e) {
            throw ConverterUtils.getTransformerException(e.getException());
        }
        catch (IOException e) {
            throw ConverterUtils.getTransformerException(e);
        }
        finally {
            MarkdownToDitaInternalConverter.updateSystemProperty(KEY_TRANSFORMER_FACTORY, property);
            if (contentReader != null) {
                try {
                    contentReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        String compositePrefix = "<?xml version=\"1.0\" encoding=\"utf-8\"?><dita";
        String convertedStartSection = "";
        if (convertedContent.length() > compositePrefix.length()) {
            convertedStartSection = convertedContent.substring(0, compositePrefix.length());
        }
        ConversionResult conversionResult = convertedStartSection.equalsIgnoreCase(compositePrefix) ? new ConversionResult(convertedContent, "<!DOCTYPE dita PUBLIC \"-//OASIS//DTD DITA Composite//EN\" \"ditabase.dtd\">", "-//OASIS//DTD DITA Composite//EN", "ditabase.dtd") : new ConversionResult(convertedContent);
        return conversionResult;
    }

    private static String updateSystemProperty(String propertyKey, String value) {
        return value == null ? System.clearProperty(propertyKey) : System.setProperty(propertyKey, value);
    }
}

