/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.map;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.StylesheetConverter;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import com.oxygenxml.batch.converter.core.utils.ConverterFileUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;
import ro.sync.basic.prettyprint.SimplePrettyPrinter;
import ro.sync.basic.prettyprint.SimplePrettyPrinterException;

public class MapWithTopicsConverter
extends StylesheetConverter {
    private static final Logger logger = LoggerFactory.getLogger(MapWithTopicsConverter.class);
    private final boolean shouldPrettyPrintBeforeConvert;

    public MapWithTopicsConverter() {
        this.shouldPrettyPrintBeforeConvert = true;
    }

    public MapWithTopicsConverter(boolean shouldPrettyPrintBeforeConvert) {
        this.shouldPrettyPrintBeforeConvert = shouldPrettyPrintBeforeConvert;
    }

    @Override
    public ConversionResult convert(File originalFile, Reader contentReader, TransformerFactoryCreator transformerCreator, ConversionInputsProvider userInputsProvider) throws TransformerException {
        if (this.shouldPrettyPrintBeforeConvert) {
            try {
                String prettyPrintedContent = SimplePrettyPrinter.prettyPrint((String)IOUtil.read((Reader)contentReader).toString(), (boolean)true);
                contentReader = new StringReader(prettyPrintedContent);
            }
            catch (IOException | SimplePrettyPrinterException e) {
                logger.debug(e.getMessage(), e);
                throw new TransformerException(e.getMessage(), e);
            }
        }
        return super.convert(originalFile, contentReader, transformerCreator, userInputsProvider);
    }

    @Override
    public String getStylesheetPath() {
        URL resource = this.getClass().getClassLoader().getResource("stylesheets/convert-topics-to-map-with-topics.xsl");
        return resource.toExternalForm();
    }

    @Override
    public void setTransformationParam(Transformer transformer, ConversionInputsProvider inputsProvider) {
        transformer.setParameter("add.file.name.as.prefix", Boolean.FALSE);
    }

    @Override
    public Source createTransformationSource(File originalFile, Reader contentReader, ConversionInputsProvider userInputsProvider) {
        return new StreamSource(contentReader, ConverterFileUtils.getUniqueOutputFile(originalFile, "dita", userInputsProvider.getOutputFolder()).getAbsolutePath());
    }

    @Override
    public ConversionResult processConversionResult(String conversionResult) {
        ConversionResult result;
        if (conversionResult.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?><map")) {
            result = new ConversionResult(conversionResult, "<!DOCTYPE topic PUBLIC \"-//OASIS//DTD DITA Map//EN\" \"map.dtd\">", "-//OASIS//DTD DITA Map//EN", "map.dtd", "ditamap");
        } else {
            result = super.processConversionResult(conversionResult);
            result.setSkipConversionResult();
        }
        return result;
    }
}

