/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.html;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.StylesheetConverter;
import java.net.URL;
import javax.xml.transform.Transformer;

public class XHTMLToDocbook4Converter
extends StylesheetConverter {
    @Override
    public String getStylesheetPath() {
        URL xsltURL = this.getClass().getClassLoader().getResource("stylesheets/docbook/xhtml2db4Driver.xsl");
        return xsltURL.toExternalForm();
    }

    @Override
    public void setTransformationParam(Transformer transformer, ConversionInputsProvider inputsProvider) {
        transformer.setParameter("context.path.names", "article");
        transformer.setParameter("context.path.uris", "http://docbook.org/ns/docbook");
        transformer.setParameter("replace.entire.root.contents", Boolean.TRUE);
        transformer.setParameter("wrapMultipleSectionsInARoot", Boolean.TRUE);
    }

    @Override
    public ConversionResult processConversionResult(String dbContent) {
        ConversionResult conversionResult = dbContent.contains("mml:math") ? new ConversionResult(dbContent, "<!DOCTYPE article PUBLIC \"-//OASIS//DTD DocBook EBNF Module V1.1CR1//EN\"\n                         \"http://www.oasis-open.org/docbook/xml/mathml/1.1CR1/dbmathml.dtd\">", "-//OASIS//DTD DocBook EBNF Module V1.1CR1//EN", "http://www.oasis-open.org/docbook/xml/mathml/1.1CR1/dbmathml.dtd") : new ConversionResult(dbContent);
        return conversionResult;
    }
}

