/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters;

import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.converters.confluence.ConfluenceToDitaConverter;
import com.oxygenxml.batch.converter.core.converters.docbook.DocbookToDitaConverter;
import com.oxygenxml.batch.converter.core.converters.excel.ExcelToDITAConverter;
import com.oxygenxml.batch.converter.core.converters.html.HtmlToDitaConverter;
import com.oxygenxml.batch.converter.core.converters.html.HtmlToDocbook4Converter;
import com.oxygenxml.batch.converter.core.converters.html.HtmlToDocbook5Converter;
import com.oxygenxml.batch.converter.core.converters.html.HtmlToXhtmlConverter;
import com.oxygenxml.batch.converter.core.converters.json.XmlToJsonConverter;
import com.oxygenxml.batch.converter.core.converters.json.XsdToJsonSchemaConverter;
import com.oxygenxml.batch.converter.core.converters.json.YamlToJsonConverter;
import com.oxygenxml.batch.converter.core.converters.markdown.MarkdownToDitaConverter;
import com.oxygenxml.batch.converter.core.converters.markdown.MarkdownToDocbook4Converter;
import com.oxygenxml.batch.converter.core.converters.markdown.MarkdownToDocbook5Converter;
import com.oxygenxml.batch.converter.core.converters.markdown.MarkdownToXhmlConverter;
import com.oxygenxml.batch.converter.core.converters.openapi.OpenApiToDITAConverter;
import com.oxygenxml.batch.converter.core.converters.word.WordToDITAConverter;
import com.oxygenxml.batch.converter.core.converters.word.WordToDocbook4Conversion;
import com.oxygenxml.batch.converter.core.converters.word.WordToDocbook5Conversion;
import com.oxygenxml.batch.converter.core.converters.word.WordToXHTMLConverter;
import com.oxygenxml.batch.converter.core.converters.yaml.JsonToXmlConverter;
import com.oxygenxml.batch.converter.core.converters.yaml.JsonToYamlConverter;
import com.oxygenxml.batch.converter.core.converters.yaml.XmlToYamlConverter;
import com.oxygenxml.batch.converter.core.converters.yaml.YamlToXmlConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConverterCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ConverterCreator.class.getName());

    private ConverterCreator() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static Converter create(String converterType) {
        Converter converter = null;
        if ("_md.to.xhtml".equals(converterType)) {
            converter = new MarkdownToXhmlConverter();
        } else if ("_html.to.xhtml".equals(converterType)) {
            converter = new HtmlToXhtmlConverter();
        } else if ("_html.to.dita".equals(converterType)) {
            converter = new HtmlToDitaConverter(true);
        } else if ("_md.to.dita".equals(converterType)) {
            converter = new MarkdownToDitaConverter();
        } else if ("_xml.to.json".equals(converterType)) {
            converter = new XmlToJsonConverter();
        } else if ("_json.to.xml".equals(converterType)) {
            converter = new JsonToXmlConverter();
        } else if ("_yaml.to.json".equals(converterType)) {
            converter = new YamlToJsonConverter();
        } else if ("_json.to.yaml".equals(converterType)) {
            converter = new JsonToYamlConverter();
        } else if ("_xsd.to.json".equals(converterType)) {
            converter = new XsdToJsonSchemaConverter();
        } else if ("_yaml.to.xml".equals(converterType)) {
            converter = new YamlToXmlConverter();
        } else if ("_xml.to.yaml".equals(converterType)) {
            converter = new XmlToYamlConverter();
        } else if ("_md.to.db5".equals(converterType)) {
            converter = new MarkdownToDocbook5Converter();
        } else if ("_md.to.db4".equals(converterType)) {
            converter = new MarkdownToDocbook4Converter();
        } else if ("_html.to.db5".equals(converterType)) {
            converter = new HtmlToDocbook5Converter(true);
        } else if ("_html.to.db4".equals(converterType)) {
            converter = new HtmlToDocbook4Converter(true);
        } else if ("_excel.to.dita".equals(converterType)) {
            converter = new ExcelToDITAConverter();
        } else if ("_word.to.xhtml".equals(converterType)) {
            converter = new WordToXHTMLConverter();
        } else if ("_word.to.dita".equals(converterType)) {
            converter = new WordToDITAConverter();
        } else if ("_word.to.db4".equals(converterType)) {
            converter = new WordToDocbook4Conversion();
        } else if ("_word.to.db5".equals(converterType)) {
            converter = new WordToDocbook5Conversion();
        } else if ("_confluence.to.ditamap".equals(converterType)) {
            converter = new ConfluenceToDitaConverter();
        } else if ("_docbook.to.dita".equals(converterType)) {
            converter = new DocbookToDitaConverter();
        } else if ("_openapi.to.dita".equals(converterType)) {
            converter = new OpenApiToDITAConverter();
        } else {
            LOGGER.warn("Unknown converter type: {}", (Object)converterType);
        }
        return converter;
    }
}

