/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNExternalsUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbDir;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbCopy;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbPristines;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemove;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnCopy;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnGetStatus;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnScheduleForAddition;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgWcToWcCopy
extends SvnNgOperationRunner<Void, SvnCopy> {
    @Override
    public boolean isApplicable(SvnCopy operation, SvnWcGeneration wcGeneration) throws SVNException {
        return this.areAllSourcesLocal(operation) && operation.getFirstTarget().isLocal();
    }

    private boolean areAllSourcesLocal(SvnCopy operation) {
        for (SvnCopySource source : operation.getSources()) {
            if (source.getSource().isFile() && (operation.isMove() || this.isLocalRevision(source.getRevision()) && this.isLocalRevision(source.getSource().getResolvedPegRevision()))) continue;
            return false;
        }
        return true;
    }

    private boolean isLocalRevision(SVNRevision revision) {
        return revision == SVNRevision.WORKING || revision == SVNRevision.UNDEFINED;
    }

    @Override
    protected Void run(SVNWCContext context) throws SVNException {
        boolean timestampSleep = false;
        Collection<SvnCopySource> sources = ((SvnCopy)this.getOperation()).getSources();
        try {
            timestampSleep = this.tryRun(context, sources, this.getFirstTarget());
            Void void_ = null;
            return void_;
        }
        catch (SVNException e) {
            SVNErrorCode code = e.getErrorMessage().getErrorCode();
            if (!(((SvnCopy)this.getOperation()).isFailWhenDstExists() || ((SvnCopy)this.getOperation()).getSources().size() != 1 || code != SVNErrorCode.ENTRY_EXISTS && code != SVNErrorCode.FS_ALREADY_EXISTS)) {
                SvnCopySource source = sources.iterator().next();
                timestampSleep = this.tryRun(context, sources, new File(this.getFirstTarget(), source.getSource().getFile().getName()));
                Void void_ = null;
                return void_;
            }
            throw e;
        }
        finally {
            if (timestampSleep) {
                this.sleepForTimestamp();
            }
        }
    }

    protected boolean tryRun(SVNWCContext context, Collection<SvnCopySource> sources, File target) throws SVNException {
        if (((SvnCopy)this.getOperation()).isDisjoint()) {
            return this.disjointCopy(context, target);
        }
        return this.copy(context, sources, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean disjointCopy(SVNWCContext context, File nestedWC) throws SVNException {
        nestedWC = new File(nestedWC.getAbsolutePath().replace(File.separatorChar, '/'));
        File nestedWCParent = nestedWC.getParentFile();
        this.checkForDisjointCopyPossibility(context, nestedWC, nestedWCParent);
        context.getDb().close();
        File wcRoot = context.getDb().getWCRoot(nestedWCParent);
        File tempDirectory = new File(this.getAdminDirectory(wcRoot), "tmp");
        SVNFileUtil.ensureDirectoryExists(tempDirectory);
        File fakeWorkingCopyDirectory = SVNFileUtil.createUniqueDir(tempDirectory, "disjoint-copy", "tmp", true);
        this.moveWcDb(nestedWC, fakeWorkingCopyDirectory);
        this.copyPristineFiles(nestedWC, wcRoot, true);
        SVNFileUtil.deleteAll(this.getAdminDirectory(nestedWC), true);
        context.getDb().forgetDirectoryTemp(nestedWC);
        File lockRoot = null;
        try {
            lockRoot = context.acquireWriteLock(wcRoot, true, true);
            this.copy(context, fakeWorkingCopyDirectory, nestedWC, true);
        }
        finally {
            if (lockRoot != null) {
                context.releaseWriteLock(lockRoot);
            }
        }
        return true;
    }

    private void checkForDisjointCopyPossibility(SVNWCContext context, File nestedWC, File nestedWCParent) throws SVNException {
        SVNErrorMessage err;
        SVNWCDb wcdb;
        SVNErrorMessage err2;
        SVNFileType nestedWCType = SVNFileType.getType(nestedWC);
        if (nestedWCType != SVNFileType.DIRECTORY) {
            err2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "This kind of copy can be run on a root of a disjoint wc directory only");
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        if (nestedWCParent == null) {
            err2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "{0} seems to be not a disjoint wc since it has no parent", (Object)nestedWC);
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        if (!(context.getDb() instanceof SVNWCDb)) {
            err2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Unsupported working copy format", (Object)nestedWC);
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        if (this.hasMetadataInParentWc(wcdb = (SVNWCDb)context.getDb(), nestedWC, nestedWCParent)) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Entry ''{0}'' already exists in parent directory", (Object)nestedWC.getName());
            SVNErrorManager.error(err3, SVNLogType.WC);
        }
        ISVNWCDb.WCDbBaseInfo baseInfo = context.getDb().getBaseInfo(nestedWC, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath);
        ISVNWCDb.WCDbBaseInfo parentBaseInfo = context.getDb().getBaseInfo(nestedWCParent, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath);
        if (baseInfo.reposRootUrl != null && parentBaseInfo.reposRootUrl != null && !baseInfo.reposRootUrl.equals(parentBaseInfo.reposRootUrl)) {
            SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is not from repository ''{1}''; it is from ''{2}''", nestedWCParent, baseInfo.reposRootUrl, baseInfo.reposRootUrl);
            SVNErrorManager.error(err4, SVNLogType.WC);
        }
        SVNWCContext.ScheduleInternalInfo parentSchedule = context.getNodeScheduleInternal(nestedWCParent, true, true);
        if (parentSchedule.schedule == SVNWCContext.SVNWCSchedule.delete) {
            SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is scheduled for deletion", (Object)nestedWCParent);
            SVNErrorManager.error(err5, SVNLogType.WC);
        }
        SVNWCContext.ScheduleInternalInfo schedule = context.getNodeScheduleInternal(nestedWC, true, true);
        if (schedule.schedule == SVNWCContext.SVNWCSchedule.delete) {
            SVNErrorMessage err6 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy ''{0}'', as it is scheduled for deletion", (Object)nestedWC);
            SVNErrorManager.error(err6, SVNLogType.WC);
        }
        File relativePath = baseInfo.reposRelPath;
        File parentRelativePath = parentBaseInfo.reposRelPath;
        if (relativePath == null || parentRelativePath == null) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy ''{0}'': cannot resolve its relative path, perhaps it is obstructed", (Object)nestedWC);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (SVNPathUtil.isAncestor(relativePath.getPath(), parentRelativePath.getPath())) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot copy path ''{0}'' into its own child ''{1}''", nestedWC, nestedWCParent);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (schedule.schedule == SVNWCContext.SVNWCSchedule.add && !schedule.copied || context.getNodeUrl(nestedWC) == null) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Cannot copy or move ''{0}'': it is not in repository yet; try committing first", (Object)nestedWC);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    private void moveWcDb(File sourceWc, File targetWc) throws SVNException {
        File sourceWcDbFile = this.getWCDbFile(sourceWc);
        File targetWcDbFile = this.getWCDbFile(targetWc);
        SVNFileUtil.ensureDirectoryExists(targetWcDbFile.getParentFile());
        SVNFileUtil.rename(sourceWcDbFile, targetWcDbFile);
    }

    private void copyPristineFiles(File sourceWc, File targetWc, boolean move) throws SVNException {
        File sourcePristineDirectory = this.getPristineDirectory(sourceWc);
        File targetPristineDirectory = this.getPristineDirectory(targetWc);
        File[] sourceDirectories = SVNFileListUtil.listFiles(sourcePristineDirectory);
        if (sourceDirectories != null) {
            for (File sourceDirectory : sourceDirectories) {
                File targetDirectory = new File(targetPristineDirectory, sourceDirectory.getName());
                SVNFileUtil.ensureDirectoryExists(targetDirectory);
                File[] sourcePristineFiles = SVNFileListUtil.listFiles(sourceDirectory);
                if (sourcePristineFiles == null) continue;
                for (File sourcePristineFile : sourcePristineFiles) {
                    File targetPristineFile = new File(targetDirectory, sourcePristineFile.getName());
                    if (targetPristineFile.exists()) continue;
                    if (move) {
                        SVNFileUtil.rename(sourcePristineFile, targetPristineFile);
                        continue;
                    }
                    SVNFileUtil.copyFile(sourcePristineFile, targetPristineFile, false);
                }
            }
        }
        SVNFileUtil.deleteAll(sourcePristineDirectory, true);
    }

    private File getPristineDirectory(File workingCopyDirectory) {
        return new File(this.getAdminDirectory(workingCopyDirectory), "pristine");
    }

    private File getWCDbFile(File nestedWC) {
        return new File(this.getAdminDirectory(nestedWC), "wc.db");
    }

    private File getAdminDirectory(File parentWC) {
        String adminDirectoryName = SVNFileUtil.getAdminDirectoryName();
        return new File(parentWC, adminDirectoryName);
    }

    private boolean hasMetadataInParentWc(SVNWCDb wcdb, File nestedWC, File nestedWCParent) throws SVNException {
        SVNWCDbRoot wcdbRoot;
        SVNWCDb.DirParsedInfo parsedInfo = wcdb.obtainWcRoot(nestedWCParent);
        SVNWCDbDir wcDbDir = parsedInfo == null ? null : parsedInfo.wcDbDir;
        SVNWCDbRoot sVNWCDbRoot = wcdbRoot = wcDbDir == null ? null : wcDbDir.getWCRoot();
        if (wcdbRoot == null) {
            return false;
        }
        try {
            wcdb.readInfo(wcdbRoot, new File(SVNPathUtil.getRelativePath(nestedWCParent.getPath(), nestedWC.getPath())), new ISVNWCDb.WCDbInfo.InfoField[0]);
            return true;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND || e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                return false;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copy(SVNWCContext context, Collection<SvnCopySource> sources, File target) throws SVNException {
        SVNErrorMessage err;
        File src;
        boolean sleepForTimeStamp = false;
        ArrayList<SvnCopyPair> copyPairs = new ArrayList<SvnCopyPair>();
        if (sources.size() > 1) {
            if (((SvnCopy)this.getOperation()).isFailWhenDstExists()) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_MULTIPLE_SOURCES_DISALLOWED);
                SVNErrorManager.error(err2, SVNLogType.DEFAULT);
            }
            for (SvnCopySource copySource : sources) {
                SvnCopyPair copyPair = new SvnCopyPair();
                copyPair.source = copySource.getSource().getFile();
                String baseName = copyPair.source.getName();
                copyPair.dst = new File(target, baseName);
                copyPairs.add(copyPair);
            }
        } else if (sources.size() == 1) {
            Iterator copyPair = new SvnCopyPair();
            SvnCopySource source = sources.iterator().next();
            ((SvnCopyPair)((Object)copyPair)).source = new File(SVNPathUtil.validateFilePath(source.getSource().getFile().getAbsolutePath()));
            ((SvnCopyPair)((Object)copyPair)).dst = target;
            copyPairs.add((SvnCopyPair)((Object)copyPair));
        }
        for (SvnCopyPair pair : copyPairs) {
            src = pair.source;
            File dst = pair.dst;
            if (((SvnCopy)this.getOperation()).isMove() && src.getAbsolutePath().equals(dst.getAbsolutePath())) {
                err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot move path ''{0}'' into itself", (Object)src);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (!SVNWCUtils.isChild(src, dst)) continue;
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot copy path ''{0}'' into its own child ''{1}''", src, dst);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (((SvnCopy)this.getOperation()).isMove()) {
            for (SvnCopyPair pair : copyPairs) {
                src = pair.source;
                try {
                    Structure<StructureFields.ExternalNodeInfo> externalInfo = SvnWcDbExternals.readExternal(context, src, src, StructureFields.ExternalNodeInfo.kind, StructureFields.ExternalNodeInfo.definingAbsPath);
                    if (!externalInfo.hasValue(StructureFields.ExternalNodeInfo.kind) || externalInfo.get(StructureFields.ExternalNodeInfo.kind) == SVNNodeKind.NONE) continue;
                    err = SVNErrorMessage.create(SVNErrorCode.WC_CANNOT_MOVE_FILE_EXTERNAL, "Cannot move the external at ''{0}''; please edit the svn:externals property on ''{1}''.", (Object)src, (int)((Integer)externalInfo.get(StructureFields.ExternalNodeInfo.definingAbsPath)));
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) continue;
                    throw e;
                }
            }
        }
        this.verifyPaths(copyPairs, ((SvnCopy)this.getOperation()).isMakeParents(), ((SvnCopy)this.getOperation()).isMove());
        if (((SvnCopy)this.getOperation()).isMove()) {
            sleepForTimeStamp = this.move(copyPairs);
        } else {
            File dstAncestor = null;
            if (copyPairs.size() >= 1) {
                dstAncestor = ((SvnCopyPair)copyPairs.iterator().next()).dst;
            }
            if (copyPairs.size() > 1 && dstAncestor != null) {
                dstAncestor = SVNFileUtil.getParentFile(dstAncestor);
            }
            dstAncestor = dstAncestor.getAbsoluteFile();
            dstAncestor = context.acquireWriteLock(dstAncestor, false, true);
            try {
                for (SvnCopyPair copyPair : copyPairs) {
                    Map<String, SVNPropertyValue> pinnedExternals = null;
                    this.checkCancelled();
                    if (((SvnCopy)this.getOperation()).isPinExternals()) {
                        Structure<StructureFields.NodeOriginInfo> nodeOrigin = this.getWcContext().getNodeOrigin(copyPair.source, false, StructureFields.NodeOriginInfo.reposRootUrl);
                        SVNURL reposRootUrl = (SVNURL)nodeOrigin.get(StructureFields.NodeOriginInfo.reposRootUrl);
                        pinnedExternals = this.resolvePinnedExternals(((SvnCopy)this.getOperation()).getExternalsToPin(), copyPair, null, reposRootUrl);
                    }
                    File dstPath = SVNFileUtil.createFilePath(copyPair.dstParent, copyPair.baseName);
                    boolean bl = sleepForTimeStamp || this.copy(context, copyPair.source, dstPath, ((SvnCopy)this.getOperation()).isMetadataOnly() || ((SvnCopy)this.getOperation()).isVirtual()) ? true : (sleepForTimeStamp = false);
                    if (pinnedExternals == null) continue;
                    for (Map.Entry entry : pinnedExternals.entrySet()) {
                        String dstRelPath = (String)entry.getKey();
                        SVNPropertyValue externalsPropval = (SVNPropertyValue)entry.getValue();
                        File localAbsPath = SVNFileUtil.createFilePath(copyPair.dst, dstRelPath);
                        SvnNgPropertiesManager.setProperty(this.getWcContext(), localAbsPath, "svn:externals", externalsPropval, SVNDepth.EMPTY, true, null, null);
                    }
                }
            }
            finally {
                context.releaseWriteLock(dstAncestor);
            }
        }
        return false;
    }

    private Map<String, SVNPropertyValue> resolvePinnedExternals(Map<SvnTarget, List<SVNExternal>> externalsToPin, SvnCopyPair copyPair, SVNRepository svnRepository, SVNURL reposRootUrl) throws SVNException {
        return SVNExternalsUtil.resolvePinnedExternals(this.getWcContext(), this.getRepositoryAccess(), externalsToPin, SvnTarget.fromFile(copyPair.source), SvnTarget.fromFile(copyPair.dst), -1L, svnRepository, reposRootUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean move(Collection<SvnCopyPair> pairs) throws SVNException {
        for (SvnCopyPair copyPair : pairs) {
            HashSet<File> lockPaths = new HashSet<File>();
            HashSet<File> lockedPaths = new HashSet<File>();
            this.checkCancelled();
            File sourceParent = new File(SVNPathUtil.validateFilePath(SVNFileUtil.getParentFile(copyPair.source).getAbsolutePath()));
            if (sourceParent.equals(copyPair.dstParent) || SVNWCUtils.isChild(sourceParent, copyPair.dstParent)) {
                lockPaths.add(sourceParent);
            } else if (SVNWCUtils.isChild(copyPair.dstParent, sourceParent)) {
                lockPaths.add(copyPair.dstParent);
            } else {
                lockPaths.add(sourceParent);
                lockPaths.add(copyPair.dstParent);
            }
            try {
                for (File file : lockPaths) {
                    lockedPaths.add(this.getWcContext().acquireWriteLock(file, false, true));
                }
                this.move(this.getWcContext(), copyPair.source, SVNFileUtil.createFilePath(copyPair.dstParent, copyPair.baseName), ((SvnCopy)this.getOperation()).isMetadataOnly() || ((SvnCopy)this.getOperation()).isVirtual());
            }
            finally {
                for (File file : lockedPaths) {
                    this.getWcContext().releaseWriteLock(file);
                }
            }
        }
        return false;
    }

    private void verifyPaths(Collection<SvnCopyPair> copyPairs, boolean makeParents, boolean move) throws SVNException {
        for (SvnCopyPair copyPair : copyPairs) {
            SVNErrorMessage err;
            SVNNodeKind dstKind = SvnWcDbCopy.readKind(this.getWcContext().getDb(), copyPair.dst, false, true);
            if (dstKind != SVNNodeKind.NONE) {
                SVNErrorMessage errorMessage;
                SVNWCContext.NodePresence nodePresence = this.getWcContext().getNodePresence(copyPair.dst, false);
                if (nodePresence.isExcluded || nodePresence.isServerExcluded) {
                    errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Path ''{0}'' exists, but is excluded", (Object)copyPair.dst);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                } else {
                    errorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Path ''{0}'' already exists", (Object)copyPair.dst);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
            }
            SVNFileType srcType = SVNFileType.getType(copyPair.source);
            SVNFileType dstType = SVNFileType.getType(copyPair.dst);
            if (!((SvnCopy)this.getOperation()).isMetadataOnly()) {
                if (((SvnCopy)this.getOperation()).isVirtual()) {
                    this.verifyPathsExistenceForVirtualCopy(copyPair.source, copyPair.dst, srcType, dstType, copyPair, move);
                } else {
                    boolean caseOnlyRename = this.verifyPaths(srcType, dstType, copyPair, copyPairs.size(), move);
                    if (caseOnlyRename) {
                        return;
                    }
                }
            }
            copyPair.dstParent = new File(SVNPathUtil.validateFilePath(SVNFileUtil.getParentFile(copyPair.dst).getAbsolutePath()));
            copyPair.baseName = SVNFileUtil.getFileName(copyPair.dst);
            SVNNodeKind dstParentKind = SvnWcDbCopy.readKind(this.getWcContext().getDb(), copyPair.dstParent, false, true);
            if (makeParents && (dstParentKind == SVNNodeKind.NONE || ((SvnCopy)this.getOperation()).isVirtual())) {
                SVNFileUtil.ensureDirectoryExists(copyPair.dstParent);
                SvnScheduleForAddition add = ((SvnCopy)this.getOperation()).getOperationFactory().createScheduleForAddition();
                add.setSingleTarget(SvnTarget.fromFile(copyPair.dstParent));
                add.setDepth(((SvnCopy)this.getOperation()).isVirtual() ? SVNDepth.EMPTY : SVNDepth.INFINITY);
                add.setIncludeIgnored(true);
                add.setForce(false);
                add.setAddParents(true);
                add.setSleepForTimestamp(false);
                try {
                    add.run();
                }
                catch (SVNException e) {
                    if (dstParentKind == SVNNodeKind.NONE) {
                        SVNFileUtil.deleteAll(copyPair.dstParent, true);
                    }
                    throw e;
                }
            } else if (dstParentKind != SVNNodeKind.DIR) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "Path ''{0}'' is not a directory", (Object)copyPair.dstParent);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if ((dstParentKind = SVNFileType.getNodeKind(SVNFileType.getType(copyPair.dstParent))) == SVNNodeKind.DIR) continue;
            err = SVNErrorMessage.create(SVNErrorCode.WC_MISSING, "Path ''{0}'' is not a directory", (Object)copyPair.dstParent);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    private boolean verifyPaths(SVNFileType srcType, SVNFileType dstType, SvnCopyPair copyPair, int copyPairsCount, boolean move) throws SVNException {
        SVNErrorMessage err;
        if (srcType == SVNFileType.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Path ''{0}'' does not exist", (Object)copyPair.source);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (dstType != SVNFileType.NONE) {
            File dstDir;
            File srcDir;
            if (move && copyPairsCount == 1 && (srcDir = SVNFileUtil.getFileDir(copyPair.source)).equals(dstDir = SVNFileUtil.getFileDir(copyPair.dst)) && copyPair.source.getName().equalsIgnoreCase(copyPair.dst.getName())) {
                copyPair.dstParent = new File(SVNPathUtil.validateFilePath(dstDir.getAbsolutePath()));
                copyPair.baseName = SVNFileUtil.getFileName(copyPair.dst);
                return true;
            }
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Path ''{0}'' already exists", (Object)copyPair.dst);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return false;
    }

    private void verifyPathsExistenceForVirtualCopy(File source, File dst, SVNFileType srcType, SVNFileType dstType, SvnCopyPair copyPair, boolean move) throws SVNException {
        SvnStatus sourceStatus;
        SvnStatus dstStatus;
        SVNErrorMessage err;
        String opName;
        String string = opName = move ? "move" : "copy";
        if (move && srcType != SVNFileType.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Cannot perform 'virtual' {0}: ''{1}'' still exists", opName, copyPair.source);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (dstType == SVNFileType.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Cannot perform 'virtual' {0}: ''{1}'' does not exist", opName, copyPair.dst);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (dstType == SVNFileType.DIRECTORY) {
            err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot perform 'virtual' {0}: ''{1}'' is a directory", opName, copyPair.dst);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!move && srcType == SVNFileType.DIRECTORY) {
            err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot perform 'virtual' {0}: ''{1}'' is a directory", opName, copyPair.source);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if ((dstStatus = this.getStatus(dst)) != null && dstStatus.getNodeStatus() != SVNStatusType.STATUS_UNVERSIONED && dstStatus.getNodeStatus() != SVNStatusType.STATUS_ADDED && dstStatus.getNodeStatus() != SVNStatusType.STATUS_REPLACED) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_ATTRIBUTE_INVALID, "Cannot perform 'virtual' {0}: ''{1}'' is scheduled neither for addition nor for replacement", opName, dst);
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        if ((sourceStatus = this.getStatus(source)) == null || sourceStatus.getNodeStatus() == SVNStatusType.STATUS_UNVERSIONED) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", (Object)source);
            SVNErrorManager.error(err3, SVNLogType.WC);
        }
    }

    private SvnStatus getStatus(File interestingFile) throws SVNException {
        final String interestingPath = SVNFileUtil.getFilePath(interestingFile);
        final SvnStatus[] status2 = new SvnStatus[1];
        SvnOperationFactory operationFactory = ((SvnCopy)this.getOperation()).getOperationFactory();
        SvnGetStatus status = operationFactory.createGetStatus();
        status.setDepth(SVNDepth.INFINITY);
        status.setRemote(false);
        status.setReportAll(true);
        status.setReportIgnored(true);
        status.setReportExternals(false);
        status.setApplicalbeChangelists(null);
        status.addTarget(SvnTarget.fromFile(interestingFile.getParentFile()));
        status.setReceiver(new ISvnObjectReceiver<SvnStatus>(){

            @Override
            public void receive(SvnTarget target, SvnStatus svnStatus) throws SVNException {
                if (svnStatus == null) {
                    return;
                }
                File path = svnStatus.getPath();
                if (path == null) {
                    return;
                }
                String statusPath = SVNFileUtil.getFilePath(path);
                if (statusPath.equals(interestingPath)) {
                    status2[0] = svnStatus;
                }
            }
        });
        status.run();
        return status2[0];
    }

    public void move(SVNWCContext context, File source, File dst, boolean metadataOnly) throws SVNException {
        Structure<StructureFields.NodeInfo> nodeInfo;
        boolean moveDegradedToCopy = this.copy(context, source, dst, true);
        if (!metadataOnly) {
            SVNFileUtil.rename(source, dst);
        }
        if ((nodeInfo = context.getDb().readInfo(source, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.conflicted)).get(StructureFields.NodeInfo.kind) == ISVNWCDb.SVNWCDbKind.Dir) {
            this.removeAllConflictMarkers(context.getDb(), source, dst);
        }
        if (nodeInfo.is(StructureFields.NodeInfo.conflicted)) {
            this.removeAllConflictMarkers(context.getDb(), source, dst);
        }
        SvnNgRemove.delete(this.getWcContext(), source, moveDegradedToCopy ? null : dst, true, false, this);
    }

    private void removeAllConflictMarkers(ISVNWCDb db, File srcDirAbsPath, File wcDirAbsPath) throws SVNException {
        HashMap<String, ISVNWCDb.SVNWCDbInfo> children = new HashMap<String, ISVNWCDb.SVNWCDbInfo>();
        HashSet<String> conflicts = new HashSet<String>();
        db.readChildren(srcDirAbsPath, children, conflicts);
        for (Map.Entry entry : children.entrySet()) {
            String name = (String)entry.getKey();
            ISVNWCDb.SVNWCDbInfo info = (ISVNWCDb.SVNWCDbInfo)entry.getValue();
            if (info.conflicted) {
                this.removeNodeConflictMarkers(db, SVNFileUtil.createFilePath(srcDirAbsPath, name), SVNFileUtil.createFilePath(wcDirAbsPath, name));
            }
            if (info.kind != ISVNWCDb.SVNWCDbKind.Dir) continue;
            this.removeAllConflictMarkers(db, SVNFileUtil.createFilePath(srcDirAbsPath, name), SVNFileUtil.createFilePath(wcDirAbsPath, name));
        }
    }

    private void removeNodeConflictMarkers(ISVNWCDb db, File srcAbsPath, File nodeAbsPath) throws SVNException {
        SVNSkel conflict = db.readConflict(srcAbsPath);
        if (conflict != null) {
            File srcDir = SVNFileUtil.getParentFile(srcAbsPath);
            File dstDir = SVNFileUtil.getParentFile(nodeAbsPath);
            List<File> markers = SvnWcDbConflicts.readConflictMarkers((SVNWCDb)db, srcAbsPath, conflict);
            if (markers != null) {
                for (File marker : markers) {
                    File childRelPath = SVNFileUtil.skipAncestor(srcDir, marker);
                    if (childRelPath == null) continue;
                    File childAbsPath = SVNFileUtil.createFilePath(dstDir, childRelPath);
                    SVNFileUtil.deleteFile(childAbsPath);
                }
            }
        }
    }

    protected boolean copy(SVNWCContext context, File source, File dst, boolean metadataOnly) throws SVNException {
        SVNFileType dstType;
        File dstWcRootAbsPath;
        ISVNWCDb.SVNWCDbStatus srcStatus;
        File srcWcRootAbsPath;
        Structure<StructureFields.NodeInfo> srcInfo;
        File dstDirectory;
        boolean allowMixedRevisions;
        boolean isMove;
        block40: {
            SVNErrorMessage err;
            ISVNWCDb.WCDbRepositoryInfo reposInfo;
            Structure<StructureFields.AdditionInfo> additionInfo;
            Structure<StructureFields.NodeInfo> dstDirInfo;
            block39: {
                SvnCopy operation = (SvnCopy)this.getOperation();
                isMove = operation != null && operation.isMove();
                allowMixedRevisions = operation == null || operation.isAllowMixedRevisions();
                dstDirectory = SVNFileUtil.getParentFile(dst);
                srcInfo = null;
                try {
                    srcInfo = context.getDb().readInfo(source, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.reposRootUrl, StructureFields.NodeInfo.reposUuid, StructureFields.NodeInfo.checksum, StructureFields.NodeInfo.conflicted);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                        SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", (Object)source);
                        SVNErrorManager.error(err2, SVNLogType.WC);
                    }
                    throw e;
                }
                srcWcRootAbsPath = context.getDb().getWCRoot(source);
                srcStatus = (ISVNWCDb.SVNWCDbStatus)((Object)srcInfo.get(StructureFields.NodeInfo.status));
                switch (srcStatus) {
                    case Deleted: {
                        if (metadataOnly) break;
                        SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Deleted node ''{0}'' can''t be copied.", (Object)source);
                        SVNErrorManager.error(err1, SVNLogType.WC);
                        break;
                    }
                    case Excluded: 
                    case ServerExcluded: 
                    case NotPresent: {
                        SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)source);
                        SVNErrorManager.error(err2, SVNLogType.WC);
                    }
                }
                if (isMove && source.equals(srcWcRootAbsPath)) {
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "''{0}'' is the root of a working copy and cannot be moved", (Object)source);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
                File srcReposRelPath = (File)srcInfo.get(StructureFields.NodeInfo.reposRelPath);
                if (isMove && srcReposRelPath != null && "".equals(SVNFileUtil.getFilePath(srcReposRelPath))) {
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "''{0}'' represents the repository root and cannot be moved", (Object)source);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
                dstDirInfo = null;
                try {
                    dstDirInfo = context.getDb().readInfo(dstDirectory, StructureFields.NodeInfo.status, StructureFields.NodeInfo.reposRootUrl, StructureFields.NodeInfo.reposUuid);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) break block39;
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", (Object)dstDirectory);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
            }
            SVNURL dstReposRootUrl = (SVNURL)dstDirInfo.get(StructureFields.NodeInfo.reposRootUrl);
            String dstReposUuid = (String)dstDirInfo.get(StructureFields.NodeInfo.reposUuid);
            ISVNWCDb.SVNWCDbStatus dstDirStatus = (ISVNWCDb.SVNWCDbStatus)((Object)dstDirInfo.get(StructureFields.NodeInfo.status));
            dstDirInfo.release();
            SVNURL srcReposRootUrl = (SVNURL)srcInfo.get(StructureFields.NodeInfo.reposRootUrl);
            String srcReposUuid = (String)srcInfo.get(StructureFields.NodeInfo.reposUuid);
            dstWcRootAbsPath = context.getDb().getWCRoot(dstDirectory);
            if (srcReposRootUrl == null) {
                if (srcStatus == ISVNWCDb.SVNWCDbStatus.Added) {
                    additionInfo = SvnWcDbShared.scanAddition((SVNWCDb)context.getDb(), source);
                    srcReposRootUrl = (SVNURL)additionInfo.get(StructureFields.AdditionInfo.reposRootUrl);
                    srcReposUuid = (String)additionInfo.get(StructureFields.AdditionInfo.reposUuid);
                    additionInfo.release();
                } else {
                    reposInfo = context.getDb().scanBaseRepository(source, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.rootUrl, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.uuid);
                    srcReposRootUrl = reposInfo.rootUrl;
                    srcReposUuid = reposInfo.uuid;
                }
            }
            if (dstReposRootUrl == null) {
                if (dstDirStatus == ISVNWCDb.SVNWCDbStatus.Added) {
                    additionInfo = SvnWcDbShared.scanAddition((SVNWCDb)context.getDb(), dstDirectory);
                    dstReposRootUrl = (SVNURL)additionInfo.get(StructureFields.AdditionInfo.reposRootUrl);
                    dstReposUuid = (String)additionInfo.get(StructureFields.AdditionInfo.reposUuid);
                    additionInfo.release();
                } else {
                    reposInfo = context.getDb().scanBaseRepository(dstDirectory, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.rootUrl, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.uuid);
                    dstReposRootUrl = reposInfo.rootUrl;
                    dstReposUuid = reposInfo.uuid;
                }
            }
            if (srcReposRootUrl != null && dstReposRootUrl != null && !srcReposRootUrl.equals(dstReposRootUrl) || srcReposUuid != null && dstReposUuid != null && !srcReposUuid.equals(dstReposUuid)) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is not from repository ''{1}''; it is from ''{2}''", dst, srcReposRootUrl, dstReposRootUrl);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (dstDirStatus == ISVNWCDb.SVNWCDbStatus.Deleted) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is scheduled for deletion", (Object)dst);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            try {
                Structure<StructureFields.NodeInfo> dstInfo = context.getDb().readInfo(dst, StructureFields.NodeInfo.status);
                ISVNWCDb.SVNWCDbStatus dstStatus = (ISVNWCDb.SVNWCDbStatus)((Object)dstInfo.get(StructureFields.NodeInfo.status));
                switch (dstStatus) {
                    case Excluded: {
                        SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' is already under version control but is excluded.", (Object)dst);
                        SVNErrorManager.error(err1, SVNLogType.WC);
                        break;
                    }
                    case ServerExcluded: {
                        SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' is already under version control", (Object)dst);
                        SVNErrorManager.error(err2, SVNLogType.WC);
                        break;
                    }
                    case Deleted: 
                    case NotPresent: {
                        break;
                    }
                    default: {
                        if (metadataOnly) break;
                        SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "There is already a versioned item ''{0}''", (Object)dst);
                        SVNErrorManager.error(err3, SVNLogType.WC);
                        break;
                    }
                }
                dstInfo.release();
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block40;
                throw e;
            }
        }
        if (!metadataOnly && (dstType = SVNFileType.getType(dst)) != SVNFileType.NONE) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' already exists and is in the way", (Object)dst);
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        File tmpDir = context.getDb().getWCRootTempDir(dstDirectory);
        boolean withinOneWc = srcWcRootAbsPath.equals(dstWcRootAbsPath);
        boolean moveDegradedToCopy = false;
        if (isMove && !withinOneWc) {
            moveDegradedToCopy = true;
            isMove = false;
        }
        if (!withinOneWc) {
            SvnWcDbPristines.transferPristine((SVNWCDb)context.getDb(), source, dstWcRootAbsPath);
        }
        if (srcInfo.get(StructureFields.NodeInfo.kind) == ISVNWCDb.SVNWCDbKind.File || srcInfo.get(StructureFields.NodeInfo.kind) == ISVNWCDb.SVNWCDbKind.Symlink) {
            boolean shouldCopyBaseData = this.shouldCopyBaseData(context, source, metadataOnly, srcStatus);
            if (shouldCopyBaseData && ((SvnCopy)this.getOperation()).isVirtual()) {
                this.copyBaseDataOfFile(context, source, dst);
            } else {
                this.copyVersionedFile(context, source, dst, dst, tmpDir, metadataOnly, srcInfo.is(StructureFields.NodeInfo.conflicted), isMove, true);
            }
        } else {
            if (isMove && srcStatus == ISVNWCDb.SVNWCDbStatus.Normal) {
                long[] minMaxRevisions = context.getDb().minMaxRevisions(source, false);
                long minRevision = minMaxRevisions[0];
                long maxRevision = minMaxRevisions[1];
                if (SVNRevision.isValidRevisionNumber(minRevision) && SVNRevision.isValidRevisionNumber(maxRevision) && minRevision != maxRevision) {
                    if (!allowMixedRevisions) {
                        SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_MIXED_REVISIONS, "Cannot move mixed-revision subtree ''{0}'' [{1}:{2}]; try updating it first", source, minRevision, maxRevision);
                        SVNErrorManager.error(errorMessage, SVNLogType.WC);
                    }
                    isMove = false;
                    moveDegradedToCopy = true;
                }
            }
            if (srcStatus == ISVNWCDb.SVNWCDbStatus.Deleted && metadataOnly) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot perform 'virtual' {0}: ''{1}'' is a directory", isMove ? "move" : "copy", source);
                SVNErrorManager.error(err, SVNLogType.WC);
            } else {
                this.copyVersionedDirectory(context, source, dst, dst, tmpDir, metadataOnly, isMove, true);
            }
        }
        if (isMove) {
            context.getDb().opHandleMoveBack(dst, source, null);
        }
        context.wqRun(dst);
        return moveDegradedToCopy;
    }

    private boolean shouldCopyBaseData(SVNWCContext context, File source, boolean metadataOnly, ISVNWCDb.SVNWCDbStatus srcStatus) throws SVNException {
        if (!metadataOnly) {
            return false;
        }
        if (srcStatus == ISVNWCDb.SVNWCDbStatus.Deleted) {
            return true;
        }
        SvnStatus svnStatus = SVNStatusEditor17.internalStatus(context, source, true);
        return svnStatus != null && svnStatus.getNodeStatus() == SVNStatusType.STATUS_REPLACED;
    }

    private void copyBaseDataOfFile(SVNWCContext context, File source, File dst) throws SVNException {
        SVNProperties pristineProps = context.getPristineProps(source);
        ISVNWCDb.WCDbBaseInfo baseInfo = context.getDb().getBaseInfo(source, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedAuthor, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedDate, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedRev, ISVNWCDb.WCDbBaseInfo.BaseInfoField.checksum, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposUuid);
        String changedAuthor = baseInfo.changedAuthor;
        SVNDate changedDate = baseInfo.changedDate;
        long changedRev = baseInfo.changedRev;
        SvnChecksum checksum = baseInfo.checksum;
        long revision = baseInfo.revision;
        SVNURL reposRootUrl = baseInfo.reposRootUrl;
        String reposUuid = baseInfo.reposUuid;
        context.getDb().opCopyFile(dst, pristineProps, changedRev, changedDate, changedAuthor, context.getNodeReposRelPath(source.getAbsoluteFile()), reposRootUrl, reposUuid, revision, checksum, false, null, null, null);
        SVNEvent event = SVNEventFactory.createSVNEvent(dst, SVNNodeKind.FILE, null, -1L, SVNEventAction.COPY, null, null, null);
        this.handleEvent(event);
    }

    private void copyVersionedDirectory(SVNWCContext wcContext, File srcAbsPath, File dstAbsPath, File dstOpRootAbsPath, File tmpDirAbsPath, boolean metadataOnly, boolean isMove, boolean notify) throws SVNException {
        SVNSkel workItems = null;
        File dirAbsPath = SVNFileUtil.getParentFile(dstAbsPath);
        SVNNodeKind diskKind = SVNNodeKind.UNKNOWN;
        if (!metadataOnly) {
            CopyToTmpDir copyToTmpDir = this.copyToTmpDir(srcAbsPath, dstAbsPath, tmpDirAbsPath, false, false);
            workItems = copyToTmpDir.workItem;
            diskKind = copyToTmpDir.kind;
        }
        wcContext.getDb().opCopy(srcAbsPath, dstAbsPath, dstOpRootAbsPath, isMove, workItems);
        if (notify && wcContext.getEventHandler() != null) {
            SVNEvent event = SVNEventFactory.createSVNEvent(dstAbsPath, SVNNodeKind.DIR, null, -1L, SVNEventAction.ADD, SVNEventAction.ADD, null, null);
            if (workItems != null) {
                wcContext.wqRun(dirAbsPath);
            }
            wcContext.getEventHandler().handleEvent(event, -1.0);
        }
        HashSet<String> diskChildren = null;
        if (!metadataOnly && diskKind == SVNNodeKind.DIR) {
            File[] files = SVNFileListUtil.listFiles(srcAbsPath);
            if (files != null) {
                diskChildren = new HashSet<String>();
                for (File file : files) {
                    diskChildren.add(SVNFileUtil.getFileName(file));
                }
            } else {
                diskChildren = null;
            }
        } else {
            diskChildren = null;
        }
        HashMap<String, ISVNWCDb.SVNWCDbInfo> versionedChildren = new HashMap<String, ISVNWCDb.SVNWCDbInfo>();
        HashSet<String> conflictedChildren = new HashSet<String>();
        wcContext.getDb().readChildren(srcAbsPath, versionedChildren, conflictedChildren);
        for (Map.Entry entry : versionedChildren.entrySet()) {
            SVNErrorMessage errorMessage;
            if (wcContext.getEventHandler() != null) {
                wcContext.getEventHandler().checkCancelled();
            }
            String childName = (String)entry.getKey();
            ISVNWCDb.SVNWCDbInfo info = (ISVNWCDb.SVNWCDbInfo)entry.getValue();
            File childSrcAbsPath = SVNFileUtil.createFilePath(srcAbsPath, childName);
            File childDstAbsPath = SVNFileUtil.createFilePath(dstAbsPath, childName);
            if (info.opRoot) {
                wcContext.getDb().opCopyShadowedLayer(childSrcAbsPath, childDstAbsPath, isMove);
            }
            if (info.status == ISVNWCDb.SVNWCDbStatus.Normal || info.status == ISVNWCDb.SVNWCDbStatus.Added) {
                if (info.kind == ISVNWCDb.SVNWCDbKind.File) {
                    if (!info.fileExternal) {
                        this.copyVersionedFile(wcContext, childSrcAbsPath, childDstAbsPath, dstOpRootAbsPath, tmpDirAbsPath, metadataOnly, info.conflicted, isMove, false);
                    }
                } else if (info.kind == ISVNWCDb.SVNWCDbKind.Dir) {
                    this.copyVersionedDirectory(wcContext, childSrcAbsPath, childDstAbsPath, dstOpRootAbsPath, tmpDirAbsPath, metadataOnly, isMove, false);
                } else {
                    errorMessage = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "cannot handle node kind for ''{0}''", (Object)childSrcAbsPath);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
            } else if (info.status == ISVNWCDb.SVNWCDbStatus.Deleted || info.status == ISVNWCDb.SVNWCDbStatus.NotPresent || info.status == ISVNWCDb.SVNWCDbStatus.Excluded) {
                wcContext.getDb().opCopy(childSrcAbsPath, childDstAbsPath, dstOpRootAbsPath, isMove, null);
            } else if (info.status == ISVNWCDb.SVNWCDbStatus.Incomplete) {
                errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot handle status of ''{0}''", (Object)childSrcAbsPath);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            } else {
                assert (info.status == ISVNWCDb.SVNWCDbStatus.ServerExcluded);
                errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot copy ''{0}'' excluded by server", (Object)childSrcAbsPath);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            if (diskChildren == null || info.status != ISVNWCDb.SVNWCDbStatus.Normal && info.status != ISVNWCDb.SVNWCDbStatus.Added) continue;
            diskChildren.remove(childName);
        }
        if (diskChildren != null && diskChildren.size() > 0) {
            List<File> markerFiles = wcContext.getDb().getConflictMarkerFiles(srcAbsPath);
            workItems = null;
            for (String name : diskChildren) {
                if ((name = SVNPathUtil.tail(name)).equals(SVNFileUtil.getAdminDirectoryName())) continue;
                if (wcContext.getEventHandler() != null) {
                    wcContext.getEventHandler().checkCancelled();
                }
                File unverSrcAbsPath = SVNFileUtil.createFilePath(srcAbsPath, name);
                File unverDstAbsPath = SVNFileUtil.createFilePath(dstAbsPath, name);
                if (markerFiles != null && markerFiles.contains(unverSrcAbsPath)) continue;
                CopyToTmpDir copyToTmpDir = this.copyToTmpDir(unverSrcAbsPath, unverDstAbsPath, tmpDirAbsPath, true, true);
                SVNSkel workItem = copyToTmpDir.workItem;
                if (workItem == null) continue;
                workItems = SVNWCContext.wqMerge(workItems, workItem);
            }
            wcContext.getDb().addWorkQueue(dstAbsPath, workItems);
        }
    }

    private void copyVersionedFile(SVNWCContext wcContext, File srcAbsPath, File dstAbsPath, File dstOpRootAbsPath, File tmpDirAbsPath, boolean metadataOnly, boolean conflicted, boolean isMove, boolean notify) throws SVNException {
        SVNSkel workItems = null;
        if (!metadataOnly) {
            File mySrcAbsPath = srcAbsPath;
            boolean handleAsUnversioned = false;
            if (conflicted) {
                File conflictWorking;
                SVNSkel conflict = wcContext.getDb().readConflict(srcAbsPath);
                try {
                    Structure<SvnWcDbConflicts.TextConflictInfo> conflictInfoStructure = SvnWcDbConflicts.readTextConflict(wcContext.getDb(), srcAbsPath, conflict);
                    conflictWorking = (File)conflictInfoStructure.get(SvnWcDbConflicts.TextConflictInfo.mineAbsPath);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_MISSING) {
                        throw e;
                    }
                    conflictWorking = null;
                }
                if (conflictWorking != null && SVNFileType.getType(conflictWorking) == SVNFileType.FILE) {
                    handleAsUnversioned = true;
                    mySrcAbsPath = conflictWorking;
                }
            }
            CopyToTmpDir copyToTmpDir = this.copyToTmpDir(mySrcAbsPath, dstAbsPath, tmpDirAbsPath, true, handleAsUnversioned);
            workItems = copyToTmpDir.workItem;
        }
        wcContext.getDb().opCopy(srcAbsPath, dstAbsPath, dstOpRootAbsPath, isMove, workItems);
        wcContext.wqRun(SVNFileUtil.getParentFile(dstAbsPath));
        if (notify) {
            if (workItems != null) {
                this.getWcContext().wqRun(dstAbsPath);
            }
            SVNEvent event = SVNEventFactory.createSVNEvent(dstAbsPath, SVNNodeKind.FILE, null, -1L, SVNEventAction.ADD, SVNEventAction.ADD, null, null, 1L, 1L);
            this.handleEvent(event, -1.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CopyToTmpDir copyToTmpDir(File srcAbsPath, File dstAbsPath, File tmpDirAbsPath, boolean fileCopy, boolean unversioned) throws SVNException {
        CopyToTmpDir copyToTmpDir;
        block16: {
            File dstTmpAbsPath;
            boolean isSpecial;
            CopyToTmpDir copyToTmpDir2;
            boolean deleteOnClose;
            block14: {
                CopyToTmpDir copyToTmpDir3;
                block15: {
                    deleteOnClose = false;
                    copyToTmpDir2 = new CopyToTmpDir();
                    copyToTmpDir2.workItem = null;
                    SVNFileType type = SVNFileType.getType(srcAbsPath);
                    copyToTmpDir2.kind = SVNFileType.getNodeKind(type);
                    boolean bl = isSpecial = type == SVNFileType.SYMLINK;
                    if (copyToTmpDir2.kind == SVNNodeKind.NONE) {
                        return copyToTmpDir2;
                    }
                    if (copyToTmpDir2.kind == SVNNodeKind.UNKNOWN) {
                        SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "Source ''{0}'' is unexpected kind", (Object)srcAbsPath);
                        SVNErrorManager.error(errorMessage, SVNLogType.WC);
                    } else {
                        deleteOnClose = copyToTmpDir2.kind == SVNNodeKind.DIR;
                    }
                    dstTmpAbsPath = null;
                    try {
                        boolean modified;
                        if (!fileCopy || unversioned) break block14;
                        boolean bl2 = modified = this.getWcContext().isTextModified(srcAbsPath, false) || this.getWcContext().isPropsModified(srcAbsPath);
                        if (modified) break block14;
                        copyToTmpDir2.workItem = this.getWcContext().wqBuildFileInstall(dstAbsPath, null, false, true);
                        copyToTmpDir3 = copyToTmpDir2;
                        if (dstTmpAbsPath == null || !deleteOnClose || copyToTmpDir2.kind != SVNNodeKind.FILE) break block15;
                    }
                    catch (Throwable throwable) {
                        if (dstTmpAbsPath != null && deleteOnClose && copyToTmpDir2.kind == SVNNodeKind.FILE) {
                            SVNFileUtil.deleteFile(dstTmpAbsPath);
                        }
                        throw throwable;
                    }
                    SVNFileUtil.deleteFile(dstTmpAbsPath);
                }
                return copyToTmpDir3;
            }
            File file = dstTmpAbsPath = copyToTmpDir2.kind == SVNNodeKind.DIR ? SVNFileUtil.createUniqueDir(tmpDirAbsPath, SVNFileUtil.getFileName(srcAbsPath), ".tmp", false) : SVNFileUtil.createUniqueFile(tmpDirAbsPath, SVNFileUtil.getFileName(srcAbsPath), ".tmp", false);
            if (copyToTmpDir2.kind == SVNNodeKind.DIR) {
                if (fileCopy) {
                    SVNFileUtil.copyDirectory(srcAbsPath, dstTmpAbsPath, false, ((SvnCopy)this.getOperation()).getEventHandler());
                } else {
                    SVNFileUtil.ensureDirectoryExists(dstTmpAbsPath);
                }
            } else if (!isSpecial) {
                SVNFileUtil.copyFile(srcAbsPath, dstTmpAbsPath, false, true);
            } else {
                SVNFileUtil.deleteFile(dstTmpAbsPath);
                SVNFileUtil.copySymlink(srcAbsPath, dstTmpAbsPath);
            }
            if (fileCopy) {
                SVNFileUtil.setReadonly(dstTmpAbsPath, false);
            }
            copyToTmpDir2.workItem = this.getWcContext().wqBuildFileMove(dstAbsPath, dstTmpAbsPath, dstAbsPath);
            copyToTmpDir = copyToTmpDir2;
            if (dstTmpAbsPath == null || !deleteOnClose || copyToTmpDir2.kind != SVNNodeKind.FILE) break block16;
            SVNFileUtil.deleteFile(dstTmpAbsPath);
        }
        return copyToTmpDir;
    }

    private static class SvnCopyPair {
        File source;
        File dst;
        File dstParent;
        String baseName;

        private SvnCopyPair() {
        }
    }

    private static class CopyToTmpDir {
        SVNSkel workItem;
        SVNNodeKind kind;

        private CopyToTmpDir() {
        }
    }
}

