/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNExportEditor
implements ISVNEditor {
    private File myRoot;
    private boolean myIsForce;
    private String myEOLStyle;
    private File myCurrentDirectory;
    private File myCurrentFile;
    private File myCurrentTmpFile;
    private String myCurrentPath;
    private Map<String, String> myExternals;
    private SVNProperties myFileProperties;
    private ISVNEventHandler myEventDispatcher;
    private String myURL;
    private String myRepositoryRootUrl;
    private ISVNOptions myOptions;
    private SVNDeltaProcessor myDeltaProcessor;
    private boolean myIsExpandKeywords;
    private String myChecksum;

    public SVNExportEditor(ISVNEventHandler eventDispatcher, String url, File dstPath, boolean force, String eolStyle, boolean expandKeywords, String repositoryRootUrl, ISVNOptions options) {
        this.myRoot = dstPath;
        this.myIsForce = force;
        this.myEOLStyle = eolStyle;
        this.myExternals = new SVNHashMap();
        this.myEventDispatcher = eventDispatcher;
        this.myURL = url;
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.myOptions = options;
        this.myIsExpandKeywords = expandKeywords;
        this.myRepositoryRootUrl = repositoryRootUrl;
    }

    public Map<String, String> getCollectedExternals() {
        return this.myExternals;
    }

    @Override
    public void openRoot(long revision) throws SVNException {
        this.addDir("", null, -1L);
    }

    @Override
    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentDirectory = new File(this.myRoot, path);
        this.myCurrentPath = path;
        SVNFileType dirType = SVNFileType.getType(this.myCurrentDirectory);
        if (dirType == SVNFileType.FILE || dirType == SVNFileType.SYMLINK) {
            if (!this.myIsForce) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' exists and is not a directory", (Object)this.myCurrentDirectory);
                SVNErrorManager.error(err, SVNLogType.WC);
            } else {
                SVNFileUtil.deleteAll(this.myCurrentDirectory, this.myEventDispatcher);
            }
        } else if (dirType == SVNFileType.DIRECTORY && !this.myIsForce) {
            File[] children;
            if (!"".equals(path)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "''{0}'' already exists", (Object)this.myCurrentDirectory);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if ((children = SVNFileListUtil.listFiles(this.myCurrentDirectory)) != null && children.length > 0) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "''{0}'' already exists", (Object)this.myCurrentDirectory);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        } else if (dirType == SVNFileType.NONE && !this.myCurrentDirectory.mkdirs()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "Cannot create directory ''{0}''", (Object)this.myCurrentDirectory);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        this.myEventDispatcher.handleEvent(SVNEventFactory.createSVNEvent(this.myCurrentDirectory, SVNNodeKind.DIR, null, -1L, SVNEventAction.UPDATE_ADD, null, null, null), -1.0);
    }

    @Override
    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if ("svn:externals".equals(name) && value != null) {
            this.myExternals.put(this.myCurrentPath, value.getString());
        }
    }

    @Override
    public void closeDir() throws SVNException {
        this.myCurrentDirectory = this.myCurrentDirectory.getParentFile();
        this.myCurrentPath = SVNPathUtil.removeTail(this.myCurrentPath);
    }

    @Override
    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        File file = new File(this.myRoot, path);
        if (!this.myIsForce && file.exists()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "File ''{0}'' already exists", (Object)file);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        this.myCurrentFile = file;
        this.myFileProperties = new SVNProperties();
        this.myChecksum = null;
    }

    @Override
    public void changeFileProperty(String commitPath, String name, SVNPropertyValue value) throws SVNException {
        this.myFileProperties.put(name, value);
    }

    @Override
    public void applyTextDelta(String commitPath, String baseChecksum) throws SVNException {
        String name = SVNPathUtil.tail(commitPath);
        this.myCurrentTmpFile = SVNFileUtil.createUniqueFile(this.myCurrentDirectory, name, ".tmp", false);
        this.myDeltaProcessor.applyTextDelta((File)null, this.myCurrentTmpFile, true);
    }

    @Override
    public OutputStream textDeltaChunk(String commitPath, SVNDiffWindow diffWindow) throws SVNException {
        return this.myDeltaProcessor.textDeltaChunk(diffWindow);
    }

    @Override
    public void textDeltaEnd(String commitPath) throws SVNException {
        this.myChecksum = this.myDeltaProcessor.textDeltaEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFile(String commitPath, String textChecksum) throws SVNException {
        if (textChecksum == null) {
            textChecksum = this.myFileProperties.getStringValue("svn:entry:checksum");
        }
        if (this.myIsForce) {
            this.myCurrentFile.delete();
        }
        String realChecksum = this.myChecksum != null ? this.myChecksum : SVNFileUtil.computeChecksum(this.myCurrentTmpFile);
        this.myChecksum = null;
        if (textChecksum != null && !textChecksum.equals(realChecksum)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''; expected: ''{1}'', actual: ''{2}''", this.myCurrentFile, textChecksum, realChecksum);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        try {
            boolean executable;
            String date = this.myFileProperties.getStringValue("svn:entry:committed-date");
            boolean special = this.myFileProperties.getStringValue("svn:special") != null;
            String mimeType = this.myFileProperties.getStringValue("svn:mime-type");
            boolean binary = SVNProperty.isBinaryMimeType(mimeType);
            String keywords = this.myIsExpandKeywords ? this.myFileProperties.getStringValue("svn:keywords") : null;
            Map<String, byte[]> keywordsMap = null;
            if (keywords != null) {
                String url = SVNPathUtil.append(this.myURL, SVNEncodingUtil.uriEncode(this.myCurrentPath));
                url = SVNPathUtil.append(url, SVNEncodingUtil.uriEncode(this.myCurrentFile.getName()));
                String author = this.myFileProperties.getStringValue("svn:entry:last-author");
                String revStr = this.myFileProperties.getStringValue("svn:entry:committed-rev");
                keywordsMap = SVNTranslator.computeKeywords(keywords, url, this.myRepositoryRootUrl, author, date, revStr, this.myOptions);
            }
            String charset = SVNTranslator.getCharset(this.myFileProperties.getStringValue("svnkit:charset"), mimeType, this.myCurrentFile.getPath(), this.myOptions);
            byte[] eolBytes = null;
            if ("native".equals(this.myFileProperties.getStringValue("svn:eol-style"))) {
                eolBytes = SVNTranslator.getEOL(this.myEOLStyle != null ? this.myEOLStyle : this.myFileProperties.getStringValue("svn:eol-style"), this.myOptions);
            } else if (this.myFileProperties.containsName("svn:eol-style")) {
                eolBytes = SVNTranslator.getEOL(this.myFileProperties.getStringValue("svn:eol-style"), this.myOptions);
            }
            if (binary) {
                charset = null;
                eolBytes = null;
                keywordsMap = null;
            }
            if (charset != null || eolBytes != null || keywordsMap != null && !keywordsMap.isEmpty() || special) {
                SVNTranslator.translate(this.myCurrentTmpFile, this.myCurrentFile, charset, eolBytes, keywordsMap, special, true);
            } else {
                SVNFileUtil.rename(this.myCurrentTmpFile, this.myCurrentFile);
            }
            boolean bl = executable = this.myFileProperties.getStringValue("svn:executable") != null;
            if (executable) {
                SVNFileUtil.setExecutable(this.myCurrentFile, true);
            }
            if (!special && date != null) {
                SVNFileUtil.setLastModified(this.myCurrentFile, SVNDate.parseDate(date).getTime());
            }
            this.myEventDispatcher.handleEvent(SVNEventFactory.createSVNEvent(this.myCurrentFile, SVNNodeKind.FILE, null, -1L, SVNEventAction.UPDATE_ADD, null, null, null), -1.0);
        }
        finally {
            this.myCurrentTmpFile.delete();
        }
    }

    @Override
    public SVNCommitInfo closeEdit() throws SVNException {
        return null;
    }

    @Override
    public void targetRevision(long revision) throws SVNException {
    }

    @Override
    public void deleteEntry(String path, long revision) throws SVNException {
    }

    @Override
    public void absentDir(String path) throws SVNException {
    }

    @Override
    public void absentFile(String path) throws SVNException {
    }

    @Override
    public void openDir(String path, long revision) throws SVNException {
    }

    @Override
    public void openFile(String path, long revision) throws SVNException {
    }

    @Override
    public void abortEdit() throws SVNException {
    }
}

