/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util.zip;

import de.schlichtherle.io.util.LEDataOutputStream;
import de.schlichtherle.util.zip.BasicZipOutputStreamTrueZip;
import de.schlichtherle.util.zip.ZipEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class BasicZipOutputStream
extends BasicZipOutputStreamTrueZip {
    public BasicZipOutputStream(OutputStream out) throws NullPointerException {
        super(out);
    }

    public BasicZipOutputStream(OutputStream out, String charset) throws NullPointerException, UnsupportedEncodingException {
        super(out, charset);
    }

    @Override
    protected void writeCentralFileHeader(ZipEntry ze) throws IOException {
        assert (ze != null);
        LEDataOutputStream dos = (LEDataOutputStream)this.out;
        dos.writeInt(33639248);
        dos.writeShort(ze.getPlatform() << 8 | 0x3F);
        dos.writeShort(ze.getGeneralBit(3) ? 20 : 10);
        dos.writeShort(ze.getGeneral());
        dos.writeShort(ze.getMethod());
        dos.writeInt((int)ze.getDosTime());
        dos.writeInt((int)ze.getCrc());
        dos.writeInt((int)ze.getCompressedSize());
        dos.writeInt((int)ze.getSize());
        byte[] name = ze.getName().getBytes(this.charset);
        dos.writeShort(name.length);
        byte[] extra = ze.getExtra();
        if (extra == null) {
            extra = new byte[]{};
        }
        dos.writeShort(extra.length);
        String comment = ze.getComment();
        if (comment == null) {
            comment = "";
        }
        byte[] data = comment.getBytes(this.charset);
        dos.writeShort(data.length);
        dos.writeShort(0);
        dos.writeShort(0);
        if (ze.isDirectory()) {
            dos.writeInt(16);
        } else {
            dos.writeInt(0);
        }
        dos.writeInt((int)ze.offset);
        dos.write(name);
        dos.write(extra);
        dos.write(data);
    }
}

