/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.JOptionPane;

final class WindowUtils {
    private static final String PROPERTY_FOCUSED_WINDOW = "focusedWindow";
    private static Reference lastFocusManager = new WeakReference<Object>(null);
    private static Reference lastFocusedWindow = lastFocusManager;
    private static Reference parent;
    private static PropertyChangeListener focusListener;

    private WindowUtils() {
    }

    public static synchronized Window getParentWindow() {
        Window window;
        Window window2 = window = parent != null ? (Window)parent.get() : null;
        if (window == null && (window = WindowUtils.getLastFocusedWindow()) == null) {
            window = WindowUtils.getAnyShowingWindow();
        }
        for (Container container = window; container != null; container = container.getParent()) {
            if (!(container instanceof Window) || !((Component)container).isShowing()) continue;
            return container;
        }
        return JOptionPane.getRootFrame();
    }

    public static synchronized void setParentWindow(Window window) {
        parent = window != null ? new WeakReference<Window>(window) : null;
    }

    public static Window getLastFocusedWindow() {
        WindowUtils.observeFocusedWindow();
        return (Window)lastFocusedWindow.get();
    }

    private static synchronized void observeFocusedWindow() {
        KeyboardFocusManager keyboardFocusManager = (KeyboardFocusManager)lastFocusManager.get();
        KeyboardFocusManager keyboardFocusManager2 = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (keyboardFocusManager2 == keyboardFocusManager) {
            return;
        }
        if (keyboardFocusManager != null) {
            keyboardFocusManager.removePropertyChangeListener(PROPERTY_FOCUSED_WINDOW, focusListener);
        }
        keyboardFocusManager2.addPropertyChangeListener(PROPERTY_FOCUSED_WINDOW, focusListener);
        lastFocusManager = new WeakReference<KeyboardFocusManager>(keyboardFocusManager2);
        lastFocusedWindow = new WeakReference<Window>(keyboardFocusManager2.getFocusedWindow());
    }

    private static final Window getAnyShowingWindow() {
        return WindowUtils.getAnyShowingWindow(Frame.getFrames());
    }

    private static Window getAnyShowingWindow(Window[] windowArray) {
        int n = windowArray.length;
        for (int i = 0; i < n; ++i) {
            Window window = windowArray[i];
            if (window.isShowing()) {
                return window;
            }
            if ((window = WindowUtils.getAnyShowingWindow(window.getOwnedWindows())) == null) continue;
            return window;
        }
        return null;
    }

    static {
        focusListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Window window = (Window)propertyChangeEvent.getNewValue();
                if (window != null) {
                    lastFocusedWindow = new WeakReference<Window>(window);
                }
            }
        };
    }
}

