/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.swing;

import de.schlichtherle.awt.EventDispatchTimeoutException;
import de.schlichtherle.awt.EventQueue;
import de.schlichtherle.key.KeyPromptingInterruptedException;
import de.schlichtherle.key.KeyPromptingTimeoutException;
import de.schlichtherle.key.PromptingKeyProvider;
import de.schlichtherle.key.passwd.swing.CreateKeyPanel;
import de.schlichtherle.key.passwd.swing.Feedback;
import de.schlichtherle.key.passwd.swing.OpenKeyPanel;
import de.schlichtherle.key.passwd.swing.PromptingKeyManager;
import java.awt.Container;
import java.awt.Window;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class PromptingKeyProviderUI
implements de.schlichtherle.key.PromptingKeyProviderUI {
    private static final String PACKAGE_NAME;
    private static final String CLASS_NAME;
    private static final ResourceBundle resources;
    private static final Logger logger;
    private static final long START_PROMPTING_TIMEOUT = 1000L;
    public static final int KEY_FILE_LEN = 512;
    private static final Map openKeyPanels;
    static String lastResourceID;
    private CreateKeyPanel createKeyPanel;
    private OpenKeyPanel openKeyPanel;
    private Feedback unknownCreateKeyFeedback;
    private Feedback invalidCreateKeyFeedback;
    private Feedback unknownOpenKeyFeedback;
    private Feedback invalidOpenKeyFeedback;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readKeyFile(String string) throws IOException {
        byte[] byArray = new byte[512];
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        try {
            randomAccessFile.readFully(byArray);
        }
        finally {
            randomAccessFile.close();
        }
        return byArray;
    }

    protected CreateKeyPanel getCreateKeyPanel() {
        if (this.createKeyPanel == null) {
            this.createKeyPanel = this.createCreateKeyPanel();
        }
        return this.createKeyPanel;
    }

    protected CreateKeyPanel createCreateKeyPanel() {
        return new CreateKeyPanel();
    }

    protected OpenKeyPanel getOpenKeyPanel() {
        if (this.openKeyPanel == null) {
            this.openKeyPanel = this.createOpenKeyPanel();
        }
        return this.openKeyPanel;
    }

    protected OpenKeyPanel createOpenKeyPanel() {
        return new OpenKeyPanel();
    }

    protected Feedback getUnknownCreateKeyFeedback() {
        if (this.unknownCreateKeyFeedback == null) {
            this.unknownCreateKeyFeedback = PromptingKeyProviderUI.createFeedback("UnknownCreateKeyFeedback");
        }
        return this.unknownCreateKeyFeedback;
    }

    protected void setUnkownCreateKeyFeedback(Feedback feedback) {
        this.unknownCreateKeyFeedback = feedback;
    }

    protected Feedback getInvalidCreateKeyFeedback() {
        if (this.invalidCreateKeyFeedback == null) {
            this.invalidCreateKeyFeedback = PromptingKeyProviderUI.createFeedback("InvalidCreateKeyFeedback");
        }
        return this.invalidCreateKeyFeedback;
    }

    protected void setInvalidCreateKeyFeedback(Feedback feedback) {
        this.invalidCreateKeyFeedback = feedback;
    }

    protected Feedback getUnknownOpenKeyFeedback() {
        if (this.unknownOpenKeyFeedback == null) {
            this.unknownOpenKeyFeedback = PromptingKeyProviderUI.createFeedback("UnknownOpenKeyFeedback");
        }
        return this.unknownOpenKeyFeedback;
    }

    protected void setUnknownOpenKeyFeedback(Feedback feedback) {
        this.unknownOpenKeyFeedback = feedback;
    }

    protected Feedback getInvalidOpenKeyFeedback() {
        if (this.invalidOpenKeyFeedback == null) {
            this.invalidOpenKeyFeedback = PromptingKeyProviderUI.createFeedback("InvalidOpenKeyFeedback");
        }
        return this.invalidOpenKeyFeedback;
    }

    protected void setInvalidOpenKeyFeedback(Feedback feedback) {
        this.invalidOpenKeyFeedback = feedback;
    }

    private static Feedback createFeedback(String string) {
        try {
            String string2 = System.getProperty(PACKAGE_NAME + "." + string, PACKAGE_NAME + ".Basic" + string);
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            Class<?> clazz = classLoader.loadClass(string2);
            Feedback feedback = (Feedback)clazz.newInstance();
            return feedback;
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.WARNING, "", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(Level.WARNING, "", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            logger.log(Level.WARNING, "", instantiationException);
        }
        return null;
    }

    public final void promptCreateKey(final PromptingKeyProvider promptingKeyProvider) {
        Runnable runnable = new Runnable(){

            public void run() {
                PromptingKeyProviderUI.this.promptCreateKey(promptingKeyProvider, null);
            }
        };
        PromptingKeyProviderUI.multiplexOnEDT(runnable);
    }

    public final boolean promptUnknownOpenKey(final PromptingKeyProvider promptingKeyProvider) {
        BooleanRunnable booleanRunnable = new BooleanRunnable(){

            public void run() {
                this.result = PromptingKeyProviderUI.this.promptOpenKey(promptingKeyProvider, false, null);
            }
        };
        PromptingKeyProviderUI.multiplexOnEDT(booleanRunnable);
        return booleanRunnable.result;
    }

    public final boolean promptInvalidOpenKey(final PromptingKeyProvider promptingKeyProvider) {
        BooleanRunnable booleanRunnable = new BooleanRunnable(){

            public void run() {
                this.result = PromptingKeyProviderUI.this.promptOpenKey(promptingKeyProvider, true, null);
            }
        };
        PromptingKeyProviderUI.multiplexOnEDT(booleanRunnable);
        return booleanRunnable.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void promptCreateKey(PromptingKeyProvider promptingKeyProvider, JComponent jComponent) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        CreateKeyPanel createKeyPanel = this.createCreateKeyPanel();
        createKeyPanel.setExtraDataUI(jComponent);
        Window window = PromptingKeyManager.getParentWindow();
        try {
            while (!Thread.interrupted()) {
                int n;
                createKeyPanel.setResourceID(promptingKeyProvider.getResourceID());
                createKeyPanel.setFeedback(createKeyPanel.getError() != null ? this.getInvalidCreateKeyFeedback() : this.getUnknownCreateKeyFeedback());
                try {
                    n = JOptionPane.showConfirmDialog(window, createKeyPanel, resources.getString("newPasswdDialog.title"), 2, 3);
                }
                catch (StackOverflowError stackOverflowError) {
                    boolean bl = Thread.interrupted();
                    if (!$assertionsDisabled && !bl) {
                        throw new AssertionError();
                    }
                    break;
                }
                if (Thread.interrupted()) {
                    break;
                }
                if (n != 0) {
                    break;
                }
                Object object = createKeyPanel.getCreateKey();
                if (object != null) {
                    promptingKeyProvider.setKey(object);
                    break;
                }
                if (!$assertionsDisabled && createKeyPanel.getError() == null) {
                    throw new AssertionError();
                }
            }
        }
        finally {
            PromptingKeyProviderUI.eventuallyDispose(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean promptOpenKey(PromptingKeyProvider promptingKeyProvider, boolean bl, JComponent jComponent) {
        OpenKeyPanel openKeyPanel;
        Container container;
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (bl) {
            container = (OpenKeyPanel)openKeyPanels.get(promptingKeyProvider);
            openKeyPanel = container != null ? container : this.createOpenKeyPanel();
            openKeyPanel.setError(resources.getString("invalidKey"));
        } else {
            openKeyPanel = this.createOpenKeyPanel();
            openKeyPanel.setExtraDataUI(jComponent);
        }
        openKeyPanels.put(promptingKeyProvider, openKeyPanel);
        container = PromptingKeyManager.getParentWindow();
        try {
            while (!Thread.interrupted()) {
                int n;
                openKeyPanel.setResourceID(promptingKeyProvider.getResourceID());
                openKeyPanel.setFeedback(openKeyPanel.getError() != null ? this.getInvalidOpenKeyFeedback() : this.getUnknownOpenKeyFeedback());
                try {
                    n = JOptionPane.showConfirmDialog(container, openKeyPanel, resources.getString("passwdDialog.title"), 2, 3);
                }
                catch (StackOverflowError stackOverflowError) {
                    boolean bl2 = Thread.interrupted();
                    if (!$assertionsDisabled && !bl2) {
                        throw new AssertionError();
                    }
                    break;
                }
                if (Thread.interrupted()) {
                    break;
                }
                if (n != 0) {
                    promptingKeyProvider.setKey(null);
                    break;
                }
                Object object = openKeyPanel.getOpenKey();
                if (object != null) {
                    promptingKeyProvider.setKey(object);
                    break;
                }
                if (!$assertionsDisabled && openKeyPanel.getError() == null) {
                    throw new AssertionError();
                }
            }
        }
        finally {
            PromptingKeyProviderUI.eventuallyDispose((Window)container);
        }
        return openKeyPanel.isKeyChangeRequested();
    }

    private static void eventuallyDispose(Window window) {
        if (!window.isShowing()) {
            window.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void multiplexOnEDT(Runnable runnable) {
        if (Thread.interrupted()) {
            throw new UndeclaredThrowableException(new KeyPromptingInterruptedException());
        }
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            Class clazz = PromptingKeyProviderUI.class;
            synchronized (clazz) {
                try {
                    EventQueue.invokeAndWaitUninterruptibly(runnable, 1000L);
                }
                catch (EventDispatchTimeoutException eventDispatchTimeoutException) {
                    throw new UndeclaredThrowableException(new KeyPromptingTimeoutException(eventDispatchTimeoutException));
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new UndeclaredThrowableException(invocationTargetException);
                }
                finally {
                    Thread.interrupted();
                }
            }
        }
    }

    static {
        $assertionsDisabled = !PromptingKeyProviderUI.class.desiredAssertionStatus();
        PACKAGE_NAME = "de/schlichtherle/key/passwd/swing".replace('/', '.');
        CLASS_NAME = PACKAGE_NAME + "/PromptingKeyProviderUI".replace('/', '.');
        resources = ResourceBundle.getBundle(CLASS_NAME);
        logger = Logger.getLogger(CLASS_NAME);
        openKeyPanels = new WeakHashMap();
        lastResourceID = "";
    }

    private static abstract class BooleanRunnable
    implements Runnable {
        public boolean result;

        private BooleanRunnable() {
        }
    }
}

