/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.spi;

import de.schlichtherle.io.ChainableIOException;
import de.schlichtherle.io.File;
import de.schlichtherle.io.InputIOException;
import de.schlichtherle.io.OutputArchiveMetaData;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.spi.RfsEntry;
import de.schlichtherle.io.archive.tar.TarEntry;
import de.schlichtherle.io.archive.zip.Zip32Entry;
import de.schlichtherle.io.util.Temps;
import de.schlichtherle.util.JointEnumeration;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class MultiplexedOutputArchive
implements OutputArchive {
    static final String TEMP_FILE_PREFIX = "tzp-mux";
    private final OutputArchive target;
    private final Map temps = new LinkedHashMap();
    private boolean targetBusy;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MultiplexedOutputArchive(OutputArchive outputArchive) {
        if (outputArchive == null) {
            throw new NullPointerException();
        }
        this.target = outputArchive;
    }

    public int getNumArchiveEntries() {
        return this.target.getNumArchiveEntries() + this.temps.size();
    }

    public Enumeration getArchiveEntries() {
        return new JointEnumeration(this.target.getArchiveEntries(), new TempEntriesEnumeration());
    }

    public ArchiveEntry getArchiveEntry(String string) {
        ArchiveEntry archiveEntry = this.target.getArchiveEntry(string);
        if (archiveEntry != null) {
            return archiveEntry;
        }
        TempEntryOutputStream tempEntryOutputStream = (TempEntryOutputStream)this.temps.get(string);
        return tempEntryOutputStream != null ? tempEntryOutputStream.entry : null;
    }

    public OutputStream getOutputStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) throws IOException {
        if (archiveEntry2 != null) {
            this.setSize(archiveEntry, archiveEntry2.getSize());
        }
        if (this.isTargetBusy()) {
            java.io.File file = Temps.createTempFile(TEMP_FILE_PREFIX);
            return new TempEntryOutputStream(archiveEntry, archiveEntry2, file);
        }
        return new EntryOutputStream(archiveEntry, archiveEntry2);
    }

    public boolean isTargetBusy() {
        return this.targetBusy;
    }

    private void setSize(ArchiveEntry archiveEntry, long l) {
        if (archiveEntry instanceof Zip32Entry) {
            ((Zip32Entry)archiveEntry).setSize(l);
        } else if (archiveEntry instanceof TarEntry) {
            ((TarEntry)archiveEntry).setSize(l);
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Unknown archive entry type: File.length() may return 0 while the temp file hasn't yet been saved to the output archive.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTempEntries() throws IOException {
        if (this.isTargetBusy()) {
            return;
        }
        ChainableIOException chainableIOException = null;
        Iterator iterator = this.temps.values().iterator();
        while (iterator.hasNext()) {
            TempEntryOutputStream tempEntryOutputStream = (TempEntryOutputStream)iterator.next();
            if (!tempEntryOutputStream.closed) continue;
            try {
                ArchiveEntry archiveEntry = tempEntryOutputStream.entry;
                ArchiveEntry archiveEntry2 = tempEntryOutputStream.srcEntry;
                java.io.File file = tempEntryOutputStream.temp;
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        OutputStream outputStream = this.target.getOutputStream(archiveEntry, archiveEntry2);
                        try {
                            File.cat(fileInputStream, outputStream);
                        }
                        finally {
                            outputStream.close();
                        }
                    }
                    finally {
                        ((InputStream)fileInputStream).close();
                    }
                }
                finally {
                    if (file.delete()) continue;
                    file.deleteOnExit();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                chainableIOException = new ChainableIOException(chainableIOException, fileNotFoundException);
            }
            catch (InputIOException inputIOException) {
                chainableIOException = new ChainableIOException(chainableIOException, inputIOException);
            }
            catch (IOException iOException) {
                throw new ChainableIOException(chainableIOException, iOException);
            }
            finally {
                iterator.remove();
            }
        }
        if (chainableIOException != null) {
            throw chainableIOException.sortPriority();
        }
    }

    public final void storeDirectory(ArchiveEntry archiveEntry) throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Since TrueZIP 6.5, this is not used anymore!");
        }
        if (!archiveEntry.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.getOutputStream(archiveEntry, null).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!$assertionsDisabled && this.isTargetBusy()) {
            throw new AssertionError();
        }
        try {
            this.storeTempEntries();
            if (!$assertionsDisabled && !this.temps.isEmpty()) {
                throw new AssertionError();
            }
        }
        finally {
            this.target.close();
        }
    }

    public OutputArchiveMetaData getMetaData() {
        return this.target.getMetaData();
    }

    public void setMetaData(OutputArchiveMetaData outputArchiveMetaData) {
        this.target.setMetaData(outputArchiveMetaData);
    }

    static {
        $assertionsDisabled = !MultiplexedOutputArchive.class.desiredAssertionStatus();
    }

    private class TempEntryOutputStream
    extends FileOutputStream {
        private final ArchiveEntry entry;
        private final ArchiveEntry srcEntry;
        private final java.io.File temp;
        private boolean closed;

        private TempEntryOutputStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2, java.io.File file) throws IOException {
            super(file);
            this.entry = archiveEntry;
            this.srcEntry = archiveEntry2 != null ? archiveEntry2 : new RfsEntry(file);
            this.temp = file;
            MultiplexedOutputArchive.this.temps.put(archiveEntry.getName(), this);
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            super.close();
            if (this.entry.getSize() == -1L) {
                MultiplexedOutputArchive.this.setSize(this.entry, this.temp.length());
            }
            if (this.entry.getTime() == -1L) {
                this.entry.setTime(this.temp.lastModified());
            }
            MultiplexedOutputArchive.this.storeTempEntries();
        }
    }

    private class EntryOutputStream
    extends FilterOutputStream {
        private boolean closed;

        private EntryOutputStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) throws IOException {
            super(MultiplexedOutputArchive.this.target.getOutputStream(archiveEntry, archiveEntry2));
            MultiplexedOutputArchive.this.targetBusy = true;
        }

        public void write(byte[] byArray) throws IOException {
            this.out.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            MultiplexedOutputArchive.this.targetBusy = false;
            super.close();
            MultiplexedOutputArchive.this.storeTempEntries();
        }
    }

    private class TempEntriesEnumeration
    implements Enumeration {
        private final Iterator i;

        private TempEntriesEnumeration() {
            this.i = MultiplexedOutputArchive.this.temps.values().iterator();
        }

        public boolean hasMoreElements() {
            return this.i.hasNext();
        }

        public Object nextElement() {
            return ((TempEntryOutputStream)this.i.next()).entry;
        }
    }
}

