/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.Executor;
import de.schlichtherle.io.InputIOException;
import de.schlichtherle.io.LegacyExecutor;
import de.schlichtherle.io.Task;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

final class Streams {
    private static final Executor readerExecutor = Streams.getExecutor("TrueZIP InputStream Reader");

    protected Streams() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cat(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream == null || outputStream == null) {
            throw new NullPointerException();
        }
        Buffer[] bufferArray = Streams.allocateBuffers();
        try {
            class Reader
            implements Runnable {
                int off;
                int len;
                volatile InputIOException exception;
                private final /* synthetic */ InputStream val$in;
                private final /* synthetic */ Buffer[] val$buffers;

                Reader(InputStream inputStream, Buffer[] bufferArray) {
                    this.val$in = inputStream;
                    this.val$buffers = bufferArray;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int n;
                    InputStream inputStream = this.val$in;
                    Buffer[] bufferArray = this.val$buffers;
                    int n2 = this.val$buffers.length;
                    do {
                        Buffer buffer;
                        Object object = this;
                        synchronized (object) {
                            while (this.len >= n2) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    return;
                                }
                            }
                            buffer = bufferArray[(this.off + this.len) % n2];
                        }
                        object = buffer.buf;
                        try {
                            n = inputStream.read((byte[])object, 0, ((Object)object).length);
                        }
                        catch (IOException iOException) {
                            n = -1;
                            this.exception = new InputIOException(iOException);
                        }
                        if (Thread.interrupted()) {
                            n = -1;
                        }
                        buffer.read = n;
                        Reader reader = this;
                        synchronized (reader) {
                            ++this.len;
                            this.notify();
                        }
                    } while (n != -1);
                }
            }
            Reader reader = new Reader(inputStream, bufferArray);
            Task task = readerExecutor.submit(reader);
            int n = bufferArray.length;
            while (true) {
                Buffer buffer;
                int n2;
                Object object = reader;
                synchronized (object) {
                    while (reader.len <= 0) {
                        try {
                            reader.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    n2 = reader.off;
                    buffer = bufferArray[n2];
                }
                int n3 = buffer.read;
                if (n3 == -1) break;
                object = buffer.buf;
                try {
                    outputStream.write((byte[])object, 0, n3);
                }
                catch (IOException iOException) {
                    task.cancel();
                    throw iOException;
                }
                Reader reader2 = reader;
                synchronized (reader2) {
                    reader.off = (n2 + 1) % n;
                    --reader.len;
                    reader.notify();
                }
            }
            if (reader.exception != null) {
                throw reader.exception;
            }
        }
        finally {
            Streams.releaseBuffers(bufferArray);
        }
    }

    private static Executor getExecutor(String string) {
        try {
            Class<?> clazz = Class.forName("de.schlichtherle.io.JSE5Executor");
            Constructor<?> constructor = clazz.getConstructor(String.class);
            return (Executor)constructor.newInstance(string);
        }
        catch (Throwable throwable) {
            return new LegacyExecutor(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Buffer[] allocateBuffers() {
        Buffer[] bufferArray = Buffer.list;
        synchronized (Buffer.list) {
            Iterator iterator = Buffer.list.iterator();
            while (iterator.hasNext()) {
                Buffer[] bufferArray2 = (Buffer[])((Reference)iterator.next()).get();
                iterator.remove();
                if (bufferArray2 == null) continue;
                // ** MonitorExit[var0] (shouldn't be in output)
                return bufferArray2;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            bufferArray = new Buffer[4];
            int n = bufferArray.length;
            while (--n >= 0) {
                bufferArray[n] = new Buffer();
            }
            return bufferArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void releaseBuffers(Buffer[] bufferArray) {
        List list = Buffer.list;
        synchronized (list) {
            Buffer.list.add(new SoftReference<Buffer[]>(bufferArray));
        }
    }

    private static class Buffer {
        static final List list = new LinkedList();
        byte[] buf = new byte[65536];
        int read;

        private Buffer() {
        }
    }
}

