/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.rof.FilterReadOnlyFile;
import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.IOException;

final class CountingReadOnlyFile
extends FilterReadOnlyFile {
    private static volatile long total;
    private static volatile boolean reset;

    CountingReadOnlyFile(ReadOnlyFile readOnlyFile) {
        super(readOnlyFile);
        CountingReadOnlyFile.init();
    }

    static long getTotal() {
        return total;
    }

    static void init() {
        if (reset) {
            reset = false;
            total = 0L;
        }
    }

    static void resetOnInit() {
        reset = true;
    }

    public int read() throws IOException {
        int n = this.rof.read();
        if (n != -1) {
            ++total;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.rof.read(byArray);
        if (n != -1) {
            total += (long)n;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.rof.read(byArray, n, n2);
        if (n3 != -1) {
            total += (long)n3;
        }
        return n3;
    }

    public int skipBytes(int n) throws IOException {
        int n2 = this.rof.skipBytes(n);
        total += (long)n2;
        return n2;
    }
}

