/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath.regex;

import java.util.Random;
import org.apache.xerces.impl.xpath.regex.ParseException;
import org.apache.xerces.impl.xpath.regex.RangeToken;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.apache.xerces.impl.xpath.regex.Token;
import org.apache.xerces.util.XMLChar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexpInputGeneratorInternal {
    private static Logger logger = LoggerFactory.getLogger((String)RegexpInputGeneratorInternal.class.getName());
    private Random random = new Random();

    public RegexpInputGeneratorInternal(long seed) {
        this.random.setSeed(seed);
    }

    public String generateMatchingInput(String regularExpression, boolean generateRandom) {
        String result = null;
        try {
            RegularExpression expr = new RegularExpression(regularExpression, "X");
            Token tokentree = expr.tokentree;
            if (tokentree != null) {
                StringBuilder collector = new StringBuilder();
                this.dumpToken(collector, tokentree, generateRandom, 0);
                result = collector.toString();
            }
        }
        catch (ParseException e) {
            logger.debug("Invalid expression '{}'", (Object)regularExpression);
        }
        catch (RuntimeException e) {
            logger.warn("Runtime Exception when generating input for the expression '{}'", (Object)regularExpression);
        }
        return result;
    }

    private void dumpToken(StringBuilder collector, Token token, boolean generateRamdom, int level) {
        block27: {
            block26: {
                boolean mustGenerate;
                if (logger.isDebugEnabled()) {
                    StringBuilder indent = new StringBuilder(level);
                    for (int i = 0; i < level; ++i) {
                        indent.append("  ");
                    }
                    StringBuilder message = new StringBuilder().append((CharSequence)indent).append("------------\n");
                    message.append((CharSequence)indent).append("Token\t").append(token).append(" class: ");
                    message.append(token.getClass()).append("\n").append((CharSequence)indent).append("Type\t");
                    message.append(token.type).append(" Char\t|").append((char)token.getChar()).append("-");
                    message.append(token.getChar()).append("| String\t|").append(token.getString());
                    message.append("|\n").append((CharSequence)indent).append("Min-max\t").append(token.getMin());
                    message.append(" -> ").append(token.getMax()).append("\n").append((CharSequence)indent).append("Length\t");
                    message.append(token.getMinLength()).append(" -> ").append(token.getMaxLength()).append("\n");
                    logger.debug(message.toString());
                }
                boolean bl = mustGenerate = token.getMinLength() > 0;
                if (!mustGenerate) {
                    boolean bl2 = generateRamdom ? this.chooseRand(0, 1) == 1 : (mustGenerate = false);
                    if (mustGenerate && logger.isDebugEnabled()) {
                        logger.debug("Optional, but dice said to generate");
                    }
                }
                if (!mustGenerate) break block26;
                switch (token.type) {
                    case 0: {
                        collector.append((char)token.getChar());
                        break;
                    }
                    case 11: {
                        char c = generateRamdom ? (char)this.chooseRand(97, 122) : (char)'a';
                        collector.append(c);
                        break;
                    }
                    case 1: {
                        int size = token.size();
                        for (int i = 0; i < size; ++i) {
                            this.dumpToken(collector, token.getChild(i), generateRamdom, level + 1);
                        }
                        break block27;
                    }
                    case 2: {
                        int choices = token.size();
                        int branch = generateRamdom ? this.chooseRand(0, choices - 1) : 0;
                        this.dumpToken(collector, token.getChild(branch), generateRamdom, level + 1);
                        break;
                    }
                    case 3: 
                    case 9: {
                        int count;
                        Token.ClosureToken ct = (Token.ClosureToken)token;
                        int min = ct.getMin();
                        int max = ct.getMax();
                        if (min == -1) {
                            min = 0;
                        }
                        if (max == -1) {
                            max = 3;
                        }
                        if (max < min) {
                            max = min;
                        }
                        int n = count = generateRamdom ? this.chooseRand(min, max) : min;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Closure: {} -> {} choosen: {}", new Object[]{min, max, count});
                        }
                        for (int i = 0; i < count; ++i) {
                            this.dumpToken(collector, ct.child, generateRamdom, level + 1);
                        }
                        break block27;
                    }
                    case 4: {
                        RangeToken rt = (RangeToken)token;
                        char ch = this.generateCharFromRangeToken(rt, generateRamdom, true);
                        collector.append(ch);
                        break;
                    }
                    case 5: {
                        RangeToken rt = (RangeToken)token;
                        char ch = this.generateCharFromRangeToken((RangeToken)RangeToken.complementRanges(rt), generateRamdom, true);
                        collector.append(ch);
                        break;
                    }
                    case 6: {
                        this.dumpToken(collector, token.getChild(0), generateRamdom, level + 1);
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 8: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("The anchors are not supported");
                            break;
                        }
                        break block27;
                    }
                    case 10: {
                        collector.append(token.getString());
                        break;
                    }
                    default: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Unhandled token: {}", (Object)token);
                            break;
                        }
                        break block27;
                    }
                }
                break block27;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("The content is optional. Skipped.");
            }
        }
    }

    private int chooseRand(int start, int end) {
        int bounds = end - start + 1;
        if (bounds > 0) {
            return start + this.random.nextInt(end - start + 1);
        }
        return start;
    }

    private char generateCharFromRangeToken(RangeToken rt, boolean generateRandom, boolean positiveRange) {
        char selectedValue;
        int rangeEnd;
        int rangeStart;
        int nrRanges = rt.ranges.length / 2;
        int rangeUpperLimit = -1;
        int rangeLowerLimit = -1;
        rt.sortRanges();
        for (int i = 0; i < nrRanges; ++i) {
            rangeStart = rt.ranges[i * 2];
            rangeEnd = rt.ranges[i * 2 + 1];
            if (rangeEnd < 32) continue;
            if (rangeStart < 32) {
                rt.ranges[i * 2] = 32;
            }
            if (rangeLowerLimit == -1) {
                rangeLowerLimit = i;
            }
            if (rangeEnd > 255) {
                if (rangeStart > 255) break;
                rt.ranges[i * 2 + 1] = 255;
                rangeUpperLimit = i;
                break;
            }
            rangeUpperLimit = i;
        }
        if (rangeLowerLimit == -1 || rangeUpperLimit == -1) {
            if (logger.isDebugEnabled()) {
                logger.debug("No range with valid ASCII chars");
            }
            if (nrRanges > 0) {
                rangeLowerLimit = 0;
                rangeUpperLimit = 0;
            } else {
                return 'A';
            }
        }
        int selectedRange = generateRandom ? this.chooseRand(rangeLowerLimit, rangeUpperLimit) : rangeLowerLimit;
        rangeStart = rt.ranges[selectedRange * 2];
        rangeEnd = rt.ranges[selectedRange * 2 + 1];
        if (logger.isDebugEnabled()) {
            logger.debug("Range Start {} Range End {}", (Object)Character.valueOf((char)rangeStart), (Object)Character.valueOf((char)rangeEnd));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Range Start {} Range End {}", (Object)rangeStart, (Object)rangeEnd);
        }
        char c = selectedValue = generateRandom ? (char)this.chooseRand(rangeStart, rangeEnd) : (char)rangeStart;
        if (!XMLChar.isValid(selectedValue)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Character generated {} was not a valid XML char", (Object)Character.valueOf(selectedValue));
            }
            return ' ';
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Value from range {}", (Object)Character.valueOf(selectedValue));
        }
        return selectedValue;
    }
}

