/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.locator;

import org.apache.xerces.impl.locator.AttributeOrElementLocator;
import org.apache.xerces.impl.locator.ElementLocator;
import org.apache.xerces.impl.locator.XMLItemLocator;

public class AttributeLocator
implements AttributeOrElementLocator {
    private String prefix;
    private String uri;
    private String localName;
    private String value;
    private XMLItemLocator nameLocator;
    private XMLItemLocator valueLocator;
    private String publicID;
    private String systemID;
    private ElementLocator parentElementLocator;

    public AttributeLocator(String prefix, String uri, String localName, String value, int nameStartLine, int nameStartColumn, int nameEndLine, int nameEndColumn, int valueStartLine, int valueStartColumn, int valueEndLine, int valueEndColumn, String publicID, String systemID) {
        this.prefix = prefix;
        this.uri = uri;
        this.localName = localName;
        this.value = value;
        this.publicID = publicID;
        this.systemID = systemID;
        this.nameLocator = new XMLItemLocator(nameStartLine, nameStartColumn, nameEndLine, nameEndColumn, publicID, systemID);
        this.valueLocator = new XMLItemLocator(valueStartLine, valueStartColumn, valueEndLine, valueEndColumn, publicID, systemID);
    }

    public AttributeLocator(String prefix, String uri, String localName, int nameStartLine, int nameStartColumn, int nameEndLine, int nameEndColumn, String publicID, String systemID) {
        this(prefix, uri, localName, null, nameStartLine, nameStartColumn, nameEndLine, nameEndColumn, -1, -1, -1, -1, publicID, systemID);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getValue() {
        return this.value;
    }

    public int getNameEndColumn() {
        return this.nameLocator.getEndColumn();
    }

    public int getNameEndLine() {
        return this.nameLocator.getEndLine();
    }

    public int getNameStartColumn() {
        return this.nameLocator.getStartColumn();
    }

    public int getNameStartLine() {
        return this.nameLocator.getStartLine();
    }

    public int getValueEndColumn() {
        return this.valueLocator.getEndColumn();
    }

    public int getValueEndLine() {
        return this.valueLocator.getEndLine();
    }

    public int getValueStartColumn() {
        return this.valueLocator.getStartColumn();
    }

    public int getValueStartLine() {
        return this.valueLocator.getStartLine();
    }

    @Override
    public String getPublicId() {
        return this.publicID;
    }

    @Override
    public String getSystemId() {
        return this.systemID;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getUri() {
        return this.uri;
    }

    public void setValueStartLine(int valStartLine) {
        this.valueLocator.setStartLine(valStartLine);
    }

    public void setValueStartColumn(int valStartCol) {
        this.valueLocator.setStartColumn(valStartCol);
    }

    public void setValueEndLine(int valEndLine) {
        this.valueLocator.setEndLine(valEndLine);
    }

    public void setValueEndColumn(int valEndCol) {
        this.valueLocator.setEndColumn(valEndCol);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getQName() {
        return this.prefix != null && this.prefix.length() > 0 ? this.prefix + ":" + this.localName : this.localName;
    }

    public String toString() {
        return "Name location: [" + this.getNameStartLine() + "," + this.getNameStartColumn() + " - " + this.getNameEndLine() + ", " + this.getNameEndColumn() + "]\nValue location: [" + this.getValueStartLine() + ", " + this.getValueStartColumn() + " - " + this.getValueEndLine() + ", " + this.getValueEndColumn() + "]";
    }

    @Override
    public int getColumnNumber() {
        return this.getNameStartColumn();
    }

    @Override
    public int getLineNumber() {
        return this.getNameStartLine();
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setParentElementLocator(ElementLocator parentElementLocator) {
        this.parentElementLocator = parentElementLocator;
    }

    public ElementLocator getParentElementLocator() {
        return this.parentElementLocator;
    }
}

