/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.XMLAttributeDecl;
import org.apache.xerces.impl.dtd.XMLDTDValidatorXerces;
import org.apache.xerces.impl.locator.AttributeOrElementLocator;
import org.apache.xerces.impl.locator.XMLLocatingErrorReporter;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.impl.xs.IDRefLocatorStorer;
import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;

public class XMLDTDValidator
extends XMLDTDValidatorXerces {
    private static boolean DEBUG = false;
    private IDRefLocatorStorer idrefLocatorStorer = new IDRefLocatorStorer();
    private TemporaryDelegatingErrorReporter tmpDelegatingErrorReporter;

    public XMLDTDValidator() {
        this.fValidationState = new ValidationState(){

            @Override
            public void addIdRef(String name) {
                XMLDTDValidator.this.idrefLocatorStorer.addIdRef(name);
                super.addIdRef(name);
            }
        };
    }

    @Override
    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        this.idrefLocatorStorer.init(locator, this.fErrorReporter);
        super.startDocument(locator, encoding, namespaceContext, augs);
    }

    @Override
    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        super.reset(componentManager);
        this.tmpDelegatingErrorReporter = new TemporaryDelegatingErrorReporter(this.fErrorReporter);
        try {
            boolean postValidation = componentManager.getFeature("http://oxygenxml.com/xml/features/dtd/post_validation");
            if (postValidation) {
                this.fValidation = false;
                this.fDynamicValidation = false;
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    @Override
    public void characters(XMLString text, Augmentations augs) throws XNIException {
        boolean callNextCharacters = true;
        boolean allWhiteSpace = true;
        for (int i = text.offset; i < text.offset + text.length; ++i) {
            if (this.isSpace(text.ch[i])) continue;
            allWhiteSpace = false;
            break;
        }
        if (this.fInElementContent && allWhiteSpace && !this.fInCDATASection && this.fDocumentHandler != null) {
            this.fDocumentHandler.ignorableWhitespace(text, augs);
            callNextCharacters = false;
        }
        if (this.fPerformValidation) {
            if (this.fInElementContent) {
                if (this.fGrammarBucket.getStandalone() && this.fDTDGrammar.getElementDeclIsExternal(this.fCurrentElementIndex) && allWhiteSpace) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_WHITE_SPACE_IN_ELEMENT_CONTENT_WHEN_STANDALONE", null, (short)1);
                }
                if (!allWhiteSpace) {
                    this.charDataInContent();
                }
                if (augs != null && augs.getItem("CHAR_REF_PROBABLE_WS") == Boolean.TRUE) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_CONTENT_INVALID_SPECIFIED", new Object[]{this.fCurrentElement.rawname, this.fDTDGrammar.getContentSpecAsString(this.fElementDepth), "character reference"}, (short)1);
                }
            }
            if (this.fCurrentContentSpecType == 1) {
                this.charDataInContent();
            }
        }
        if (this.fPerformValidation && this.fCurrentContentSpecType == 3 && !allWhiteSpace) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_CONTENT_INVALID_UNEXPECTED_CHARACTERS", new Object[]{text}, (short)1);
        }
        if (callNextCharacters && this.fDocumentHandler != null) {
            this.fDocumentHandler.characters(text, augs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void validateDTDattribute(QName element, String attValue, XMLAttributeDecl attributeDecl) throws XNIException {
        try {
            if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
                ((XMLLocatingErrorReporter)this.fErrorReporter).setCurrentValidatedAttribute(attributeDecl.name);
            }
            super.validateDTDattribute(element, attValue, attributeDecl);
        }
        finally {
            if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
                ((XMLLocatingErrorReporter)this.fErrorReporter).setCurrentValidatedAttribute(null);
            }
        }
    }

    private String dump(int[] array, int limit) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < limit; ++i) {
            buf.append(array[i]);
            buf.append("  ");
        }
        return buf.toString();
    }

    private String dump(QName[] array, int limit) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < limit; ++i) {
            buf.append(array[i].rawname);
            buf.append(" ");
        }
        return buf.toString();
    }

    private void dumpState(QName element) {
        System.out.println();
        System.out.println("End element " + element);
        System.out.println();
        System.out.println(" fElementDepth " + this.fElementDepth);
        System.out.println(" fElementChildrenLength " + this.fElementChildrenLength);
        System.out.println(" fElementChildren " + this.dump(this.fElementChildren, this.fElementChildrenLength));
        System.out.println(" fElemOffStackCld " + this.dump(this.fElementChildrenOffsetStack, this.fElementChildrenLength));
        System.out.println(" fElemIndexStack  " + this.dump(this.fElementIndexStack, this.fElementDepth));
        System.out.println(" Checking parent '" + this.fElementQNamePartsStack[this.fElementDepth].rawname + "'");
        System.out.println(" Parent grammar " + this.fElementIndexStack[this.fElementDepth]);
        System.out.println(" Checking parent  " + this.fElementIndexStack[this.fElementDepth]);
        int parentChildrenOffset = this.fElementChildrenOffsetStack[this.fElementDepth] + 1;
        int parentChildrenLength = this.fElementChildrenOffsetStack[this.fElementDepth + 1] - this.fElementChildrenOffsetStack[this.fElementDepth];
        System.out.println(" Parent children offset " + parentChildrenOffset);
        System.out.println(" ParentChildrenLength " + parentChildrenLength);
        System.out.println(" Model for " + this.fElementQNamePartsStack[this.fElementDepth].rawname + " " + this.fDTDGrammar.getContentSpecAsString(this.fElementIndexStack[this.fElementDepth]));
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < parentChildrenLength; ++i) {
            buf.append(this.fElementChildren[i + parentChildrenOffset].rawname);
            buf.append(" ");
        }
        System.out.println(" Seq: " + buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleEndElement(QName element, Augmentations augs, boolean isEmpty) throws XNIException {
        XMLErrorReporter originalErrorReporter = this.fErrorReporter;
        try {
            if (this.tmpDelegatingErrorReporter == null) {
                throw new XNIException("The temporary error reporter must not be null.");
            }
            this.fErrorReporter = this.tmpDelegatingErrorReporter;
            super.handleEndElement(element, augs, isEmpty);
        }
        finally {
            this.fErrorReporter = originalErrorReporter;
        }
        if (this.fPerformValidation && this.fCurrentElementIndex != -1 && this.fCurrentContentSpecType != -1 && this.fElementDepth >= 0) {
            if (DEBUG) {
                this.dumpState(element);
            }
            int parentElementIndex = this.fElementIndexStack[this.fElementDepth];
            QName[] children = this.fElementChildren;
            int parentChildrenOffset = this.fElementChildrenOffsetStack[this.fElementDepth] + 1;
            int parentChildrenLength = this.fElementChildrenOffsetStack[this.fElementDepth + 1] - this.fElementChildrenOffsetStack[this.fElementDepth];
            int result = this.checkContent(parentElementIndex, children, parentChildrenOffset, parentChildrenLength);
            if (DEBUG) {
                System.out.println(" Result " + result + " " + this.fTempElementDecl.type);
                System.out.println(" Parent Children Lenght " + parentChildrenLength);
            }
            if (result != -1 && this.fTempElementDecl.type != 1 && result == parentChildrenLength - 1) {
                String contentSpec = this.fDTDGrammar.getContentSpecAsString(parentElementIndex);
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_CONTENT_INVALID_UNEXPECTED_ELEMENT", new Object[]{this.fElementChildren[parentChildrenOffset + result].rawname, contentSpec == null ? "(#PCDATA)" : contentSpec}, (short)1);
            }
        }
    }

    @Override
    public String[] getRecognizedFeatures() {
        ArrayList<String> features = new ArrayList<String>(Arrays.asList(super.getRecognizedFeatures()));
        features.add("http://oxygenxml.com/xml/features/dtd/post_validation");
        return features.toArray(new String[0]);
    }

    public DTDGrammar getDTDGrammar() {
        return this.fDTDGrammar;
    }

    private class TemporaryDelegatingErrorReporter
    extends XMLErrorReporter {
        private XMLErrorReporter delegate;

        private TemporaryDelegatingErrorReporter(XMLErrorReporter delegate) {
            this.delegate = delegate;
        }

        @Override
        public String reportError(String domain, String key, Object[] arguments, short severity) throws XNIException {
            AttributeOrElementLocator locator;
            if ("MSG_ELEMENT_WITH_ID_REQUIRED".equals(key) && arguments.length == 1) {
                locator = XMLDTDValidator.this.idrefLocatorStorer.getLocatorForIdRef(arguments[0]);
                if (!(this.delegate instanceof XMLLocatingErrorReporter)) {
                    SimpleLocator simpleLocator = null;
                    if (locator != null) {
                        simpleLocator = new SimpleLocator("", locator.getSystemId(), locator.getLineNumber(), locator.getColumnNumber());
                    }
                    return this.delegate.reportError(simpleLocator, domain, key, arguments, severity);
                }
            } else {
                return this.delegate.reportError(domain, key, arguments, severity);
            }
            ((XMLLocatingErrorReporter)this.delegate).setInvalidIdRefLocator(locator);
            this.delegate.reportError(domain, key, arguments, severity);
            return "";
        }

        @Override
        public String reportError(XMLLocator location, String domain, String key, Object[] arguments, short severity) throws XNIException {
            return this.delegate.reportError(location, domain, key, arguments, severity);
        }
    }
}

