/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.IOException;
import org.apache.xerces.impl.XML11NSDocumentScannerImplXerces;
import org.apache.xerces.impl.locator.AttributeLocator;
import org.apache.xerces.impl.locator.XMLItemLocator;
import org.apache.xerces.impl.locator.XMLLocatingErrorReporter;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;

public class XML11NSDocumentScannerImpl
extends XML11NSDocumentScannerImplXerces {
    @Override
    protected boolean scanStartElement() throws IOException, XNIException {
        if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
            ((XMLLocatingErrorReporter)this.fErrorReporter).scanStartElement(this.fEntityScanner.getLineNumber(), this.fEntityScanner.getColumnNumber(), this.fEntityScanner.getPublicId(), this.fEntityScanner.getExpandedSystemId());
        }
        this.fEntityScanner.scanQName(this.fElementQName);
        if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
            ((XMLLocatingErrorReporter)this.fErrorReporter).elementNameScanned(this.fEntityScanner.getLineNumber(), this.fEntityScanner.getColumnNumber());
        }
        String rawname = this.fElementQName.rawname;
        if (this.fBindNamespaces) {
            this.fNamespaceContext.pushContext();
            if (this.fScannerState == 6 && this.fPerformValidation) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_GRAMMAR_NOT_FOUND", new Object[]{rawname}, (short)1);
                if (this.fDoctypeName == null || !this.fDoctypeName.equals(rawname)) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "RootElementTypeMustMatchDoctypedecl", new Object[]{this.fDoctypeName, rawname}, (short)1);
                }
            }
        }
        this.fCurrentElement = this.fElementStack.pushElement(this.fElementQName);
        boolean empty = false;
        this.fAttributes.removeAllAttributes();
        while (true) {
            boolean sawSpace = this.fEntityScanner.skipSpaces();
            int c = this.fEntityScanner.peekChar();
            if (c == 62) {
                this.fEntityScanner.scanChar();
                break;
            }
            if (c == 47) {
                this.fEntityScanner.scanChar();
                if (!this.fEntityScanner.skipChar(62)) {
                    this.reportFatalError("ElementUnterminated", new Object[]{rawname});
                }
                empty = true;
                break;
            }
            if (!(this.isValidNameStartChar(c) && sawSpace || this.isValidNameStartHighSurrogate(c) && sawSpace)) {
                this.reportFatalError("ElementUnterminated", new Object[]{rawname});
            }
            this.scanAttribute(this.fAttributes);
        }
        if (this.fBindNamespaces) {
            QName name;
            if (this.fElementQName.prefix == XMLSymbols.PREFIX_XMLNS) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "ElementXMLNSPrefix", new Object[]{this.fElementQName.rawname}, (short)2);
            }
            String prefix = this.fElementQName.prefix != null ? this.fElementQName.prefix : XMLSymbols.EMPTY_STRING;
            this.fCurrentElement.uri = this.fElementQName.uri = this.fNamespaceContext.getURI(prefix);
            if (this.fElementQName.prefix == null && this.fElementQName.uri != null) {
                this.fElementQName.prefix = XMLSymbols.EMPTY_STRING;
                this.fCurrentElement.prefix = XMLSymbols.EMPTY_STRING;
            }
            if (this.fElementQName.prefix != null && this.fElementQName.uri == null) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "ElementPrefixUnbound", new Object[]{this.fElementQName.prefix, this.fElementQName.rawname}, (short)2);
            }
            int length = this.fAttributes.getLength();
            for (int i = 0; i < length; ++i) {
                this.fAttributes.getName(i, this.fAttributeQName);
                String aprefix = this.fAttributeQName.prefix != null ? this.fAttributeQName.prefix : XMLSymbols.EMPTY_STRING;
                String uri = this.fNamespaceContext.getURI(aprefix);
                if (this.fAttributeQName.uri != null && this.fAttributeQName.uri == uri || aprefix == XMLSymbols.EMPTY_STRING) continue;
                this.fAttributeQName.uri = uri;
                if (uri == null) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "AttributePrefixUnbound", new Object[]{this.fElementQName.rawname, this.fAttributeQName.rawname, aprefix}, (short)2);
                }
                this.fAttributes.setURI(i, uri);
            }
            if (length > 1 && (name = this.fAttributes.checkDuplicatesNS()) != null) {
                if (name.uri != null) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "AttributeNSNotUnique", new Object[]{this.fElementQName.rawname, name.localpart, name.uri}, (short)2);
                } else {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "AttributeNotUnique", new Object[]{this.fElementQName.rawname, name.rawname}, (short)2);
                }
            }
        }
        if (this.fDocumentHandler != null) {
            if (empty) {
                --this.fMarkupDepth;
                if (this.fMarkupDepth < this.fEntityStack[this.fEntityDepth - 1]) {
                    this.reportFatalError("ElementEntityMismatch", new Object[]{this.fCurrentElement.rawname});
                }
                this.fDocumentHandler.emptyElement(this.fElementQName, this.fAttributes, null);
                if (this.fBindNamespaces) {
                    this.fNamespaceContext.popContext();
                }
                this.fElementStack.popElement(this.fElementQName);
            } else {
                this.fDocumentHandler.startElement(this.fElementQName, this.fAttributes, null);
            }
        }
        if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
            if (empty) {
                ((XMLLocatingErrorReporter)this.fErrorReporter).endElementScanned();
            } else {
                ((XMLLocatingErrorReporter)this.fErrorReporter).startElementScanned(this.fEntityScanner.getLineNumber(), this.fEntityScanner.getColumnNumber());
            }
        }
        return empty;
    }

    @Override
    protected void scanStartElementName() throws IOException, XNIException {
        if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
            ((XMLLocatingErrorReporter)this.fErrorReporter).scanStartElement(this.fEntityScanner.getLineNumber(), this.fEntityScanner.getColumnNumber(), this.fEntityScanner.getPublicId(), this.fEntityScanner.getExpandedSystemId());
        }
        super.scanStartElementName();
        if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
            ((XMLLocatingErrorReporter)this.fErrorReporter).elementNameScanned(this.fEntityScanner.getLineNumber(), this.fEntityScanner.getColumnNumber());
        }
    }

    @Override
    protected boolean scanStartElementAfterName() throws IOException, XNIException {
        boolean empty = super.scanStartElementAfterName();
        if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
            if (empty) {
                ((XMLLocatingErrorReporter)this.fErrorReporter).endElementScanned();
            } else {
                ((XMLLocatingErrorReporter)this.fErrorReporter).startElementScanned(this.fEntityScanner.getLineNumber(), this.fEntityScanner.getColumnNumber());
            }
        }
        return empty;
    }

    @Override
    protected void scanAttribute(XMLAttributesImpl attributes) throws IOException, XNIException {
        int attrIndex;
        int attrNameStartLine = this.fEntityScanner.getLineNumber();
        int attrNameStartColumn = this.fEntityScanner.getColumnNumber();
        this.fEntityScanner.scanQName(this.fAttributeQName);
        int attrNameEndLine = this.fEntityScanner.getLineNumber();
        int attrNameEndColumn = this.fEntityScanner.getColumnNumber();
        if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
            AttributeLocator locatedAttribute = new AttributeLocator(this.fAttributeQName.prefix, this.fNamespaceContext.getURI(this.fAttributeQName.prefix), this.fAttributeQName.localpart, attrNameStartLine, attrNameStartColumn, attrNameEndLine, attrNameEndColumn, this.fEntityScanner.getPublicId(), this.fEntityScanner.getExpandedSystemId());
            ((XMLLocatingErrorReporter)this.fErrorReporter).attributeNameScaned(locatedAttribute);
        }
        this.fEntityScanner.skipSpaces();
        if (!this.fEntityScanner.skipChar(61)) {
            this.reportFatalError("EqRequiredInAttribute", new Object[]{this.fCurrentElement.rawname, this.fAttributeQName.rawname});
        }
        this.fEntityScanner.skipSpaces();
        if (this.fBindNamespaces) {
            attrIndex = attributes.getLength();
            attributes.addAttributeNS(this.fAttributeQName, XMLSymbols.fCDATASymbol, null);
        } else {
            int oldLen = attributes.getLength();
            attrIndex = attributes.addAttribute(this.fAttributeQName, XMLSymbols.fCDATASymbol, null);
            if (oldLen == attributes.getLength()) {
                this.reportFatalError("AttributeNotUnique", new Object[]{this.fCurrentElement.rawname, this.fAttributeQName.rawname});
            }
        }
        if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
            int attrValueStartLine = this.fEntityScanner.getLineNumber();
            int attrValueStartColumn = this.fEntityScanner.getColumnNumber();
            XMLLocatingErrorReporter locErrorReporter = (XMLLocatingErrorReporter)this.fErrorReporter;
            AttributeLocator attr = locErrorReporter.getCurrentAttrLocator();
            attr.setValueStartLine(attrValueStartLine);
            attr.setValueStartColumn(attrValueStartColumn);
        }
        boolean isSameNormalizedAttr = this.scanAttributeValue(this.fTempString, this.fTempString2, this.fAttributeQName.rawname, this.fIsEntityDeclaredVC, this.fCurrentElement.rawname);
        String value = this.fTempString.toString();
        attributes.setValue(attrIndex, value);
        if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
            int attrValueEndLine = this.fEntityScanner.getLineNumber();
            int attrValueEndColumn = this.fEntityScanner.getColumnNumber();
            XMLLocatingErrorReporter locErrorReporter = (XMLLocatingErrorReporter)this.fErrorReporter;
            AttributeLocator attr = locErrorReporter.getCurrentAttrLocator();
            attr.setValue(value);
            attr.setValueEndLine(attrValueEndLine);
            attr.setValueEndColumn(attrValueEndColumn);
            if ("xmlns".equals(attr.getPrefix())) {
                locErrorReporter.getCurrentElementLocator().updateAttributesNSURIs(attr.getLocalName(), value);
            }
        }
        if (!isSameNormalizedAttr) {
            attributes.setNonNormalizedValue(attrIndex, this.fTempString2.toString());
        }
        attributes.setSpecified(attrIndex, true);
        if (this.fBindNamespaces) {
            String prefix;
            String localpart = this.fAttributeQName.localpart;
            String string = prefix = this.fAttributeQName.prefix != null ? this.fAttributeQName.prefix : XMLSymbols.EMPTY_STRING;
            if (prefix == XMLSymbols.PREFIX_XMLNS || prefix == XMLSymbols.EMPTY_STRING && localpart == XMLSymbols.PREFIX_XMLNS) {
                String uri = this.fSymbolTable.addSymbol(value);
                if (prefix == XMLSymbols.PREFIX_XMLNS && localpart == XMLSymbols.PREFIX_XMLNS) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXMLNS", new Object[]{this.fAttributeQName}, (short)2);
                }
                if (uri == NamespaceContext.XMLNS_URI) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXMLNS", new Object[]{this.fAttributeQName}, (short)2);
                }
                if (localpart == XMLSymbols.PREFIX_XML) {
                    if (uri != NamespaceContext.XML_URI) {
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXML", new Object[]{this.fAttributeQName}, (short)2);
                    }
                } else if (uri == NamespaceContext.XML_URI) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXML", new Object[]{this.fAttributeQName}, (short)2);
                }
                prefix = localpart != XMLSymbols.PREFIX_XMLNS ? localpart : XMLSymbols.EMPTY_STRING;
                this.fNamespaceContext.declarePrefix(prefix, uri.length() != 0 ? uri : null);
                attributes.setURI(attrIndex, this.fNamespaceContext.getURI(XMLSymbols.PREFIX_XMLNS));
            } else if (this.fAttributeQName.prefix != null) {
                attributes.setURI(attrIndex, this.fNamespaceContext.getURI(this.fAttributeQName.prefix));
            }
        }
    }

    @Override
    protected int scanContent() throws IOException, XNIException {
        XMLItemLocator elementLocator;
        int elementContentEndColumn;
        int elementContentEndLine;
        int elementContentStartLine = this.fEntityScanner.getLineNumber();
        int elementContentStartColumn = this.fEntityScanner.getColumnNumber();
        XMLString content = this.fString;
        int c = this.fEntityScanner.scanContent(content);
        if (c == 13 || c == 133 || c == 8232) {
            this.fEntityScanner.scanChar();
            this.fStringBuffer.clear();
            this.fStringBuffer.append(this.fString);
            this.fStringBuffer.append((char)c);
            content = this.fStringBuffer;
            c = -1;
        }
        if (this.fDocumentHandler != null && content.length > 0) {
            if (this.containsNonWSChars(content) && this.fErrorReporter instanceof XMLLocatingErrorReporter) {
                XMLItemLocator elementLocator2 = new XMLItemLocator(elementContentStartLine, elementContentStartColumn, -1, -1, this.fEntityScanner.getPublicId(), this.fEntityScanner.getExpandedSystemId());
                ((XMLLocatingErrorReporter)this.fErrorReporter).startContentScanned(elementLocator2);
            }
            this.fDocumentHandler.characters(content, null);
            elementContentEndLine = this.fEntityScanner.getLineNumber();
            elementContentEndColumn = this.fEntityScanner.getColumnNumber();
            if (content != null && this.containsNonWSChars(content) && this.fErrorReporter instanceof XMLLocatingErrorReporter) {
                elementLocator = new XMLItemLocator(elementContentStartLine, elementContentStartColumn, elementContentEndLine, elementContentEndColumn, this.fEntityScanner.getPublicId(), this.fEntityScanner.getExpandedSystemId());
                ((XMLLocatingErrorReporter)this.fErrorReporter).elementContentScanned(elementLocator);
            }
        }
        elementContentStartLine = this.fEntityScanner.getLineNumber();
        elementContentStartColumn = this.fEntityScanner.getColumnNumber();
        if (c == 93 && this.fString.length == 0) {
            this.fStringBuffer.clear();
            this.fStringBuffer.append((char)this.fEntityScanner.scanChar());
            this.fInScanContent = true;
            if (this.fEntityScanner.skipChar(93)) {
                this.fStringBuffer.append(']');
                while (this.fEntityScanner.skipChar(93)) {
                    this.fStringBuffer.append(']');
                }
                if (this.fEntityScanner.skipChar(62)) {
                    this.reportFatalError("CDEndInContent", null);
                }
            }
            if (this.fDocumentHandler != null && this.fStringBuffer.length != 0) {
                this.fDocumentHandler.characters(this.fStringBuffer, null);
                elementContentEndLine = this.fEntityScanner.getLineNumber();
                elementContentEndColumn = this.fEntityScanner.getColumnNumber();
                if (this.fStringBuffer != null && this.containsNonWSChars(this.fStringBuffer) && this.fErrorReporter instanceof XMLLocatingErrorReporter) {
                    elementLocator = new XMLItemLocator(elementContentStartLine, elementContentStartColumn, elementContentEndLine, elementContentEndColumn, this.fEntityScanner.getPublicId(), this.fEntityScanner.getExpandedSystemId());
                    ((XMLLocatingErrorReporter)this.fErrorReporter).elementContentScanned(elementLocator);
                }
            }
            this.fInScanContent = false;
            c = -1;
        }
        return c;
    }

    @Override
    protected boolean scanCDATASection(boolean complete) throws IOException, XNIException {
        boolean isNonWS = false;
        int elementContentStartLine = this.fEntityScanner.getLineNumber();
        int elementContentStartColumn = this.fEntityScanner.getColumnNumber();
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startCDATA(null);
        }
        if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
            XMLItemLocator elementLocator = new XMLItemLocator(elementContentStartLine, elementContentStartColumn, -1, -1, this.fEntityScanner.getPublicId(), this.fEntityScanner.getExpandedSystemId());
            ((XMLLocatingErrorReporter)this.fErrorReporter).startContentScanned(elementLocator);
        }
        while (true) {
            int c;
            this.fStringBuffer.clear();
            if (!this.fEntityScanner.scanData("]]", this.fStringBuffer)) {
                if (this.fDocumentHandler != null && this.fStringBuffer.length > 0) {
                    this.fDocumentHandler.characters(this.fStringBuffer, null);
                    isNonWS = isNonWS || this.containsNonWSChars(this.fStringBuffer);
                }
                int brackets = 0;
                while (this.fEntityScanner.skipChar(93)) {
                    ++brackets;
                }
                if (this.fDocumentHandler != null && brackets > 0) {
                    if (brackets > 2) {
                        isNonWS = true;
                    }
                    this.fStringBuffer.clear();
                    if (brackets > 2048) {
                        int i;
                        int chunks = brackets / 2048;
                        int remainder = brackets % 2048;
                        for (i = 0; i < 2048; ++i) {
                            this.fStringBuffer.append(']');
                        }
                        for (i = 0; i < chunks; ++i) {
                            this.fDocumentHandler.characters(this.fStringBuffer, null);
                        }
                        if (remainder != 0) {
                            this.fStringBuffer.length = remainder;
                            this.fDocumentHandler.characters(this.fStringBuffer, null);
                        }
                    } else {
                        for (int i = 0; i < brackets; ++i) {
                            this.fStringBuffer.append(']');
                        }
                        this.fDocumentHandler.characters(this.fStringBuffer, null);
                    }
                }
                if (this.fEntityScanner.skipChar(62)) break;
                if (this.fDocumentHandler == null) continue;
                this.fStringBuffer.clear();
                this.fStringBuffer.append("]]");
                this.fDocumentHandler.characters(this.fStringBuffer, null);
                continue;
            }
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.characters(this.fStringBuffer, null);
                boolean bl = isNonWS = isNonWS || this.containsNonWSChars(this.fStringBuffer);
            }
            if ((c = this.fEntityScanner.peekChar()) == -1 || !this.isInvalidLiteral(c)) continue;
            if (XMLChar.isHighSurrogate(c)) {
                this.fStringBuffer.clear();
                this.scanSurrogates(this.fStringBuffer);
                if (this.fDocumentHandler == null) continue;
                this.fDocumentHandler.characters(this.fStringBuffer, null);
                isNonWS = isNonWS || this.containsNonWSChars(this.fStringBuffer);
                continue;
            }
            this.reportFatalError("InvalidCharInCDSect", new Object[]{Integer.toString(c, 16)});
            this.fEntityScanner.scanChar();
        }
        --this.fMarkupDepth;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endCDATA(null);
        }
        if (isNonWS && this.fErrorReporter instanceof XMLLocatingErrorReporter) {
            XMLItemLocator elementLocator = new XMLItemLocator(elementContentStartLine, elementContentStartColumn, this.fEntityScanner.getLineNumber(), this.fEntityScanner.getColumnNumber() - 3, this.fEntityScanner.getPublicId(), this.fEntityScanner.getExpandedSystemId());
            ((XMLLocatingErrorReporter)this.fErrorReporter).elementContentScanned(elementLocator);
        }
        return true;
    }

    @Override
    protected void scanEntityReference() throws IOException, XNIException {
        String name;
        int startLine = this.fEntityScanner.getLineNumber();
        int startColumn = this.fEntityScanner.getColumnNumber() - 1;
        if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
            ((XMLLocatingErrorReporter)this.fErrorReporter).entityRefScanned(new XMLItemLocator(startLine, startColumn, -1, -1, this.fEntityScanner.getPublicId(), this.fEntityScanner.getExpandedSystemId()));
        }
        if ((name = this.fEntityScanner.scanName()) == null) {
            this.reportFatalError("NameRequiredInReference", null);
            return;
        }
        if (!this.fEntityScanner.skipChar(59)) {
            this.reportFatalError("SemicolonRequiredInReference", new Object[]{name});
        }
        --this.fMarkupDepth;
        int endLine = this.fEntityScanner.getLineNumber();
        int endColumn = this.fEntityScanner.getColumnNumber();
        if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
            XMLItemLocator entityLocator = ((XMLLocatingErrorReporter)this.fErrorReporter).getEntityLocator();
            entityLocator.setEndLine(endLine);
            entityLocator.setEndColumn(endColumn);
        }
        if (name == fAmpSymbol) {
            this.handleCharacter('&', fAmpSymbol);
        } else if (name == fLtSymbol) {
            this.handleCharacter('<', fLtSymbol);
        } else if (name == fGtSymbol) {
            this.handleCharacter('>', fGtSymbol);
        } else if (name == fQuotSymbol) {
            this.handleCharacter('\"', fQuotSymbol);
        } else if (name == fAposSymbol) {
            this.handleCharacter('\'', fAposSymbol);
        } else if (this.fEntityManager.isUnparsedEntity(name)) {
            this.reportFatalError("ReferenceToUnparsedEntity", new Object[]{name});
        } else {
            if (!this.fEntityManager.isDeclaredEntity(name)) {
                if (this.fHasExternalDTD && !this.fStandalone) {
                    if (this.fValidation) {
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EntityNotDeclared", new Object[]{name}, (short)1);
                    } else {
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EntityNotDeclared", new Object[]{name}, (short)0);
                    }
                } else {
                    this.reportFatalError("EntityNotDeclared", new Object[]{name});
                }
            }
            this.fEntityManager.startEntity(name, false);
        }
        if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
            ((XMLLocatingErrorReporter)this.fErrorReporter).entityRefScanned(null);
        }
    }

    @Override
    protected int scanEndElement() throws IOException, XNIException {
        if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
            ((XMLLocatingErrorReporter)this.fErrorReporter).scanEndElement(this.fEntityScanner.getLineNumber(), this.fEntityScanner.getColumnNumber() - 2);
        }
        int toRet = super.scanEndElement();
        if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
            ((XMLLocatingErrorReporter)this.fErrorReporter).endElementScanned();
        }
        return toRet;
    }

    private boolean containsNonWSChars(XMLString string) {
        boolean containsNonWSChars = false;
        for (int i = 0; i < string.length; ++i) {
            if (XMLChar.isSpace(string.ch[string.offset + i])) continue;
            containsNonWSChars = true;
            break;
        }
        return containsNonWSChars;
    }

    @Override
    protected void scanCharReference() throws IOException, XNIException {
        int startLine = this.fEntityScanner.getLineNumber();
        int startColumn = this.fEntityScanner.getColumnNumber() - 2;
        if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
            ((XMLLocatingErrorReporter)this.fErrorReporter).entityRefScanned(new XMLItemLocator(startLine, startColumn, -1, -1, this.fEntityScanner.getPublicId(), this.fEntityScanner.getExpandedSystemId()));
        }
        super.scanCharReference();
        if (this.fErrorReporter instanceof XMLLocatingErrorReporter) {
            ((XMLLocatingErrorReporter)this.fErrorReporter).entityRefScanned(null);
        }
    }
}

