/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.s9api.QName;

public interface XProcSystemPropertySet {
    public static final XProcSystemPropertySet BUILTIN = new XProcSystemPropertySet(){

        @Override
        public String systemProperty(XProcRuntime runtime, QName propertyName) throws XProcException {
            NamespaceUri uri = propertyName.getNamespaceUri();
            String local = propertyName.getLocalName();
            if (uri == XProcConstants.NS_XPROC) {
                if ("episode".equals(local)) {
                    return runtime.getEpisode();
                }
                if ("language".equals(local)) {
                    return runtime.getLanguage();
                }
                if ("product-name".equals(local)) {
                    return runtime.getProductName();
                }
                if ("product-version".equals(local)) {
                    return runtime.getProductVersion();
                }
                if ("vendor".equals(local)) {
                    return runtime.getVendor();
                }
                if ("vendor-uri".equals(local)) {
                    return runtime.getVendorURI();
                }
                if ("version".equals(local)) {
                    return runtime.getXProcVersion();
                }
                if ("xpath-version".equals(local)) {
                    return runtime.getXPathVersion();
                }
                if ("psvi-supported".equals(local)) {
                    return runtime.getPSVISupported() ? "true" : "false";
                }
                return null;
            }
            if (uri == XProcConstants.NS_CALABASH_EX) {
                if ("transparent-json".equals(local)) {
                    return runtime.transparentJSON() ? "true" : "false";
                }
                if ("json-flavor".equals(local)) {
                    return runtime.jsonFlavor();
                }
                if ("general-values".equals(local)) {
                    return runtime.getAllowGeneralExpressions() ? "true" : "false";
                }
                if ("xpointer-on-text".equals(local)) {
                    return runtime.getAllowXPointerOnText() ? "true" : "false";
                }
                if ("use-xslt-1.0".equals(local) || "use-xslt-10".equals(local)) {
                    return runtime.getUseXslt10Processor() ? "true" : "false";
                }
                if ("html-serializer".equals(local)) {
                    return runtime.getHtmlSerializer() ? "true" : "false";
                }
                if ("saxon-version".equals(local)) {
                    return runtime.getConfiguration().getProcessor().getSaxonProductVersion();
                }
                if ("saxon-edition".equals(local)) {
                    return runtime.getConfiguration().saxonProcessor;
                }
                return null;
            }
            return null;
        }
    };

    public String systemProperty(XProcRuntime var1, QName var2) throws XProcException;
}

