/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcRuntime;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Vector;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceCollection;
import net.sf.saxon.om.Item;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XProcCollectionFinder
implements CollectionFinder {
    public static final String DEFAULT = "http://xmlcalabash.com/saxon-default-collection";
    protected Logger logger = LoggerFactory.getLogger(XProcCollectionFinder.class);
    XProcRuntime runtime = null;
    Vector<XdmNode> docs = null;
    CollectionFinder chainedFinder = null;

    public XProcCollectionFinder(XProcRuntime runtime, Vector<XdmNode> docs, CollectionFinder chainedFinder) {
        this.runtime = runtime;
        this.docs = docs;
        this.chainedFinder = chainedFinder;
    }

    public ResourceCollection findCollection(XPathContext context, String collectionURI) throws XPathException {
        this.logger.trace("Collection: " + collectionURI);
        if (collectionURI == null) {
            collectionURI = DEFAULT;
        }
        if (collectionURI.equals(DEFAULT)) {
            return new DocumentResourceCollection(collectionURI, this.docs);
        }
        try {
            URI cURI = new URI(collectionURI);
            Vector<XdmNode> docs = this.runtime.getCollection(cURI);
            if (docs != null) {
                return new DocumentResourceCollection(collectionURI, docs);
            }
        }
        catch (URISyntaxException use) {
            this.logger.trace("URI Syntax exception resolving collection URI: " + collectionURI);
        }
        return this.chainedFinder.findCollection(context, collectionURI);
    }

    private class DocumentResource
    implements Resource {
        private XdmNode doc = null;

        public DocumentResource(XdmNode doc) {
            this.doc = doc;
        }

        public String getResourceURI() {
            return this.doc.getBaseURI().toASCIIString();
        }

        public Item getItem() throws XPathException {
            return this.doc.getUnderlyingValue().head();
        }

        public String getContentType() {
            return null;
        }
    }

    private class DocumentResourceCollection
    implements ResourceCollection {
        private Vector<XdmNode> docs = null;
        private Vector<String> uris = null;
        private Vector<Resource> rsrcs = null;
        private String collectionURI = null;

        public DocumentResourceCollection(String collectionURI, Vector<XdmNode> docs) {
            this.collectionURI = collectionURI;
            this.docs = docs;
        }

        public String getCollectionURI() {
            return this.collectionURI;
        }

        public Iterator<String> getResourceURIs(XPathContext context) throws XPathException {
            if (this.uris == null) {
                this.uris = new Vector();
                for (XdmNode doc : this.docs) {
                    this.uris.add(doc.getBaseURI().toASCIIString());
                }
            }
            return this.uris.iterator();
        }

        public Iterator<? extends Resource> getResources(XPathContext context) throws XPathException {
            if (this.rsrcs == null) {
                this.rsrcs = new Vector();
                for (XdmNode doc : this.docs) {
                    this.rsrcs.add(new DocumentResource(doc));
                }
            }
            return this.rsrcs.iterator();
        }

        public boolean isStable(XPathContext context) {
            return true;
        }
    }
}

