/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;

public class URIUtils {
    private static final String uniqueQueryKey = "xmlcalabash_uniqueid";
    private static int uniqueId = 0;

    protected URIUtils() {
    }

    public static String encode(String src) {
        String genDelims = ":/?#[]@";
        String subDelims = "!$&'()*+,;=";
        String unreserved = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-._~";
        String okChars = genDelims + subDelims + unreserved + "%";
        String filesep = System.getProperty("file.separator");
        if ("\\".equals(filesep)) {
            src = src.replaceAll("\\\\", "/");
        }
        String encoded = "";
        try {
            byte[] bytes = src.getBytes("UTF-8");
            for (int pos = 0; pos < bytes.length; ++pos) {
                encoded = okChars.indexOf(bytes[pos]) >= 0 ? encoded + (char)bytes[pos] : encoded + String.format("%%%02X", bytes[pos]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encoded;
    }

    public static URI homeAsURI() {
        return URIUtils.dirAsURI(System.getProperty("user.home"));
    }

    public static URI cwdAsURI() {
        return URIUtils.dirAsURI(System.getProperty("user.dir"));
    }

    public static URI dirAsURI(String dir) {
        URI cwd = null;
        try {
            String path = URIUtils.encode(dir);
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            cwd = new URI("file:" + path);
        }
        catch (URISyntaxException use) {
            throw new XProcException(use);
        }
        return cwd;
    }

    public static URI makeAbsolute(String localFn) {
        URI cwd = URIUtils.cwdAsURI();
        return cwd.resolve(URIUtils.encode(localFn));
    }

    public static File toFile(URI uri) {
        if (!"file".equalsIgnoreCase(uri.getScheme())) {
            throw new IllegalStateException("Expecting a file URI: " + uri.toASCIIString());
        }
        if (uri.getAuthority() != null && uri.getAuthority().length() > 0) {
            return new File("//" + uri.getAuthority() + uri.getPath());
        }
        return new File(uri.getPath());
    }

    public static int uniqueId(String uri) {
        if (uri == null) {
            return 0;
        }
        int pos = uri.indexOf("?");
        if (pos >= 0) {
            String query = uri.substring(pos + 1);
            if ((pos = query.indexOf(uniqueQueryKey)) >= 0) {
                String id = query.substring(pos).replaceAll("xmlcalabash_uniqueid=([0-9]+).*$", "$1");
                return Integer.parseInt(id, 10);
            }
            return -1;
        }
        return -1;
    }

    public static String makeUnique(String uri) {
        if (uri == null) {
            return uri;
        }
        String id = "xmlcalabash_uniqueid=" + ++uniqueId;
        int pos = uri.indexOf("?");
        if (pos >= 0) {
            String query = uri.substring(pos + 1);
            query = query.contains(uniqueQueryKey) ? query.replaceAll("xmlcalabash_uniqueid=[0-9]+", id) : query + "&" + id;
            return uri.substring(0, pos + 1) + query;
        }
        return uri + "?" + id;
    }
}

