/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.SysIdLocation;
import com.xmlcalabash.util.VoidLocation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.str.StringView;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;

public class TreeWriter {
    protected static final String logger = "com.xmlcalabash.util";
    protected static final AttributeMap emptyAttributeMap = EmptyAttributeMap.getInstance();
    protected Controller controller = null;
    protected XProcRuntime runtime = null;
    protected Executable exec = null;
    protected NamePool pool = null;
    protected XdmDestination destination = null;
    protected Receiver receiver = null;
    protected boolean seenRoot = false;
    protected boolean inDocument = false;

    public TreeWriter(XProcRuntime xproc) {
        this.runtime = xproc;
        this.pool = xproc.getProcessor().getUnderlyingConfiguration().getNamePool();
        this.controller = new Controller(this.runtime.getProcessor().getUnderlyingConfiguration());
    }

    public TreeWriter(Processor proc) {
        this.pool = proc.getUnderlyingConfiguration().getNamePool();
        this.controller = new Controller(proc.getUnderlyingConfiguration());
    }

    public XdmNode getResult() {
        return this.destination.getXdmNode();
    }

    public boolean inDocument() {
        return this.inDocument;
    }

    public void startDocument(URI baseURI) {
        this.inDocument = true;
        this.seenRoot = false;
        try {
            this.exec = new Executable(this.controller.getConfiguration());
            this.destination = new XdmDestination();
            PipelineConfiguration pipe = this.controller.makePipelineConfiguration();
            this.receiver = this.runtime == null ? this.destination.getReceiver(pipe, new SerializationProperties()) : this.destination.getReceiver(pipe, this.runtime.getDefaultSerializationProperties());
            this.receiver.setPipelineConfiguration(pipe);
            if (baseURI != null) {
                this.receiver.setSystemId(baseURI.toASCIIString());
            } else {
                this.receiver.setSystemId("http://example.com/");
            }
            this.receiver = new ComplexContentOutputter((Receiver)new NamespaceReducer(this.receiver));
            this.receiver.open();
            this.receiver.startDocument(0);
        }
        catch (Exception e) {
            throw new XProcException(e);
        }
    }

    public void endDocument() {
        try {
            this.receiver.setSystemId("http://norman-was-here.com/");
            this.receiver.endDocument();
            this.receiver.close();
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addSubtree(XdmNode node) {
        if (node.getNodeKind() == XdmNodeKind.DOCUMENT) {
            this.writeChildren(node);
        } else if (node.getNodeKind() == XdmNodeKind.ELEMENT) {
            this.addStartElement(node);
            this.writeChildren(node);
            this.addEndElement();
        } else if (node.getNodeKind() == XdmNodeKind.COMMENT) {
            this.addComment(node.getStringValue());
        } else if (node.getNodeKind() == XdmNodeKind.TEXT) {
            this.addText(node.getStringValue());
        } else if (node.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION) {
            this.addPI(node.getNodeName().getLocalName(), node.getStringValue());
        } else {
            throw new UnsupportedOperationException("Unexpected node type");
        }
    }

    protected void writeChildren(XdmNode node) {
        XdmSequenceIterator iter = node.axisIterator(Axis.CHILD);
        while (iter.hasNext()) {
            XdmNode child = (XdmNode)iter.next();
            this.addSubtree(child);
        }
    }

    public void addStartElement(QName nodeName) {
        this.addStartElement(nodeName, (AttributeMap)EmptyAttributeMap.getInstance());
    }

    public void addStartElement(XdmNode node) {
        try {
            this.addStartElement(node, node.getNodeName(), node.getBaseURI());
        }
        catch (IllegalStateException e) {
            if (this.runtime != null && this.runtime.getIgnoreInvalidXmlBase()) {
                this.addStartElement(node, node.getNodeName(), null);
            }
            throw e;
        }
    }

    public void addStartElement(XdmNode node, URI overrideBaseURI) {
        this.addStartElement(node, node.getNodeName(), overrideBaseURI);
    }

    public void addStartElement(XdmNode node, QName newName) {
        try {
            this.addStartElement(node, newName, node.getBaseURI());
        }
        catch (IllegalStateException e) {
            if (this.runtime != null && this.runtime.getIgnoreInvalidXmlBase()) {
                this.addStartElement(node, node.getNodeName(), null);
            }
            throw e;
        }
    }

    public void addStartElement(XdmNode node, QName newName, URI overrideBaseURI) {
        AttributeMap attrs = node.getUnderlyingNode().attributes();
        this.addStartElement(node, newName, overrideBaseURI, attrs);
    }

    public void addStartElement(XdmNode node, AttributeMap attrs) {
        NodeInfo inode = node.getUnderlyingNode();
        this.addStartElement(NameOfNode.makeName((NodeInfo)inode), attrs, inode.getSchemaType(), inode.getAllNamespaces(), node.getBaseURI());
    }

    public void addStartElement(XdmNode node, QName newName, URI overrideBaseURI, AttributeMap attrs) {
        NodeInfo inode = node.getUnderlyingNode();
        NamespaceMap inscopeNS = null;
        if (this.seenRoot) {
            ArrayList nslist = new ArrayList();
            Collections.addAll(nslist, inode.getDeclaredNamespaces(null));
            inscopeNS = new NamespaceMap(nslist);
        } else {
            inscopeNS = inode.getAllNamespaces();
        }
        if ("".equals(newName.getPrefix()) && !"".equals(inscopeNS.getDefaultNamespace())) {
            inscopeNS.remove("");
        }
        if (overrideBaseURI != null && !"".equals(overrideBaseURI.toASCIIString())) {
            this.receiver.setSystemId(overrideBaseURI.toASCIIString());
        }
        FingerprintedQName newNameOfNode = new FingerprintedQName(newName.getPrefix(), newName.getNamespaceUri(), newName.getLocalName());
        this.addStartElement((NodeName)newNameOfNode, attrs, inode.getSchemaType(), inscopeNS);
    }

    public void addStartElement(QName newName, AttributeMap attrs) {
        this.addStartElement(newName, attrs, NamespaceMap.emptyMap());
    }

    public void addStartElement(QName newName, AttributeMap attrs, NamespaceMap nsmap) {
        FingerprintedQName elemName = new FingerprintedQName(newName.getPrefix(), newName.getNamespaceUri(), newName.getLocalName());
        this.addStartElement((NodeName)elemName, attrs, (SchemaType)Untyped.INSTANCE, nsmap);
    }

    public void addStartElement(NodeName elemName, SchemaType typeCode) {
        this.addStartElement(elemName, emptyAttributeMap, typeCode, NamespaceMap.emptyMap());
    }

    public void addStartElement(NodeName elemName, SchemaType typeCode, NamespaceMap nsmap) {
        this.addStartElement(elemName, emptyAttributeMap, typeCode, nsmap);
    }

    public void addStartElement(NodeName elemName, AttributeMap attrs, SchemaType typeCode, NamespaceMap nsmap, URI overrideBaseURI) {
        if (overrideBaseURI != null && !"".equals(overrideBaseURI.toASCIIString())) {
            this.receiver.setSystemId(overrideBaseURI.toASCIIString());
        }
        this.addStartElement(elemName, attrs, typeCode, nsmap);
    }

    public void addStartElement(NodeName elemName, AttributeMap attrs, SchemaType typeCode, NamespaceMap nsmap) {
        nsmap = this.updateMap(nsmap, elemName.getPrefix(), elemName.getNamespaceUri());
        for (AttributeInfo attr : attrs) {
            if (attr.getNodeName().getURI() == null || "".equals(attr.getNodeName().getURI())) continue;
            nsmap = this.updateMap(nsmap, attr.getNodeName().getPrefix(), attr.getNodeName().getNamespaceUri());
        }
        String sysId = this.receiver.getSystemId();
        Object loc = sysId == null ? VoidLocation.instance() : new SysIdLocation(sysId);
        try {
            this.receiver.startElement(elemName, typeCode, attrs, nsmap, (Location)loc, 0);
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    private NamespaceMap updateMap(NamespaceMap nsmap, String prefix, NamespaceUri uri) {
        if (uri == NamespaceUri.NULL) {
            return nsmap;
        }
        if (prefix == null || "".equals(prefix)) {
            if (uri != nsmap.getDefaultNamespace()) {
                return nsmap.put("", uri);
            }
            return nsmap;
        }
        NamespaceUri curNS = nsmap.getURIForPrefix(prefix, false);
        if (curNS == null) {
            return nsmap.put(prefix, uri);
        }
        if (curNS.equals(uri)) {
            return nsmap;
        }
        throw new XProcException("Cannot add " + prefix + " to namespace map with URI " + uri);
    }

    public void addEndElement() {
        try {
            this.receiver.endElement();
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addComment(String comment) {
        try {
            this.receiver.comment(StringView.of((String)comment), (Location)VoidLocation.instance(), 0);
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addText(String text) {
        try {
            this.receiver.characters(StringView.of((String)text), (Location)VoidLocation.instance(), 0);
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addPI(String target, String data) {
        this.addPI(target, data, VoidLocation.instance());
    }

    public void addPI(String target, String data, Location location) {
        try {
            this.receiver.processingInstruction(target, StringView.of((String)data), location, 0);
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addPI(XdmNode node) {
        Object location = VoidLocation.instance();
        if (node.getBaseURI() != null) {
            location = new SysIdLocation(node.getBaseURI().toString());
            this.receiver.setSystemId(node.getBaseURI().toString());
        }
        this.addPI(node.getNodeName().getLocalName(), node.getStringValue(), (Location)location);
    }
}

