/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.AxisNodes;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.VoidLocation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SAXDestination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.XPathException;
import nu.validator.htmlparser.sax.HtmlSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class S9apiUtils {
    private static final QName vara = new QName("", "vara");
    private static final QName varb = new QName("", "varb");

    public static void writeXdmValue(XProcRuntime runtime, Vector<XdmValue> values, Destination destination, URI baseURI) throws SaxonApiException {
        S9apiUtils.writeXdmValue(runtime.getProcessor(), values, destination, baseURI);
    }

    public static void writeXdmValue(Processor proc, Vector<XdmValue> values, Destination destination, URI baseURI) throws SaxonApiException {
        try {
            Configuration config = proc.getUnderlyingConfiguration();
            PipelineConfiguration pipeConfig = config.makePipelineConfiguration();
            Receiver out = destination.getReceiver(pipeConfig, new SerializationProperties());
            out = new NamespaceReducer(out);
            out = new ComplexContentOutputter((Receiver)new NamespaceReducer(out));
            TreeReceiver tree = new TreeReceiver(out);
            tree.setPipelineConfiguration(pipeConfig);
            if (baseURI != null) {
                tree.setSystemId(baseURI.toASCIIString());
            }
            tree.open();
            tree.startDocument(0);
            for (XdmValue value : values) {
                for (XdmItem item : value) {
                    tree.append(item.getUnderlyingValue(), (Location)VoidLocation.instance(), 524288);
                }
            }
            tree.endDocument();
            tree.close();
        }
        catch (XPathException err) {
            throw new SaxonApiException((Throwable)err);
        }
    }

    public static void writeXdmValue(XProcRuntime runtime, XdmItem node, Destination destination, URI baseURI) throws SaxonApiException {
        try {
            Processor proc = runtime.getProcessor();
            Configuration config = proc.getUnderlyingConfiguration();
            PipelineConfiguration pipeConfig = config.makePipelineConfiguration();
            Receiver out = destination.getReceiver(pipeConfig, new SerializationProperties());
            out = new NamespaceReducer(out);
            out = new ComplexContentOutputter((Receiver)new NamespaceReducer(out));
            TreeReceiver tree = new TreeReceiver(out);
            tree.setPipelineConfiguration(pipeConfig);
            if (baseURI != null) {
                tree.setSystemId(baseURI.toASCIIString());
            }
            tree.open();
            tree.startDocument(0);
            tree.append(node.getUnderlyingValue(), (Location)VoidLocation.instance(), 524288);
            tree.endDocument();
            tree.close();
        }
        catch (XPathException err) {
            throw new SaxonApiException((Throwable)err);
        }
    }

    public static XdmNode getDocumentElement(XdmNode doc) {
        if (doc.getNodeKind() == XdmNodeKind.DOCUMENT) {
            for (XdmNode node : new AxisNodes(doc, Axis.CHILD, 7)) {
                if (node.getNodeKind() != XdmNodeKind.ELEMENT) continue;
                return node;
            }
            return null;
        }
        return doc;
    }

    public static void serialize(XProcRuntime xproc, XdmNode node, Serializer serializer) throws SaxonApiException {
        Vector<XdmNode> nodes = new Vector<XdmNode>();
        nodes.add(node);
        S9apiUtils.serialize(xproc, nodes, serializer);
    }

    public static void serialize(XProcRuntime xproc, Vector<XdmNode> nodes, Serializer serializer) throws SaxonApiException {
        Processor qtproc = xproc.getProcessor();
        XQueryCompiler xqcomp = qtproc.newXQueryCompiler();
        xqcomp.setModuleURIResolver((ModuleURIResolver)xproc.getResolver());
        xqcomp.getUnderlyingStaticContext().setSchemaAware(xqcomp.getProcessor().getUnderlyingConfiguration().isLicensedFeature(4));
        XQueryExecutable xqexec = xqcomp.compile(".");
        XQueryEvaluator xqeval = xqexec.load();
        if (xproc.getHtmlSerializer() && "html".equals(serializer.getOutputProperty(Serializer.Property.METHOD))) {
            HtmlSerializer ch = null;
            Object outputDest = serializer.getOutputDestination();
            if (outputDest == null) {
                xqeval.setDestination((Destination)serializer);
            } else if (outputDest instanceof OutputStream) {
                ch = new HtmlSerializer((OutputStream)outputDest);
                xqeval.setDestination((Destination)new SAXDestination((ContentHandler)ch));
            } else if (outputDest instanceof Writer) {
                ch = new HtmlSerializer((Writer)outputDest);
                xqeval.setDestination((Destination)new SAXDestination((ContentHandler)ch));
            } else if (outputDest instanceof File) {
                try {
                    FileOutputStream fos = new FileOutputStream((File)outputDest);
                    ch = new HtmlSerializer((OutputStream)fos);
                    xqeval.setDestination((Destination)new SAXDestination((ContentHandler)ch));
                }
                catch (FileNotFoundException fnfe) {
                    xqeval.setDestination((Destination)serializer);
                }
            } else {
                xqeval.setDestination((Destination)serializer);
            }
        } else {
            xqeval.setDestination((Destination)serializer);
        }
        for (XdmNode node : nodes) {
            xqeval.setContextItem((XdmItem)node);
            xqeval.run();
            serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        }
    }

    public static boolean xpathEqual(Processor proc, XdmItem a, XdmItem b) {
        try {
            XPathCompiler c = proc.newXPathCompiler();
            c.setSchemaAware(proc.isSchemaAware());
            c.declareVariable(vara);
            c.declareVariable(varb);
            XPathExecutable xexec = c.compile("$vara = $varb");
            XPathSelector selector = xexec.load();
            selector.setVariable(vara, (XdmValue)a);
            selector.setVariable(varb, (XdmValue)b);
            XdmSequenceIterator values = selector.iterator();
            XdmAtomicValue item = (XdmAtomicValue)values.next();
            return item.getBooleanValue();
        }
        catch (SaxonApiException sae) {
            return false;
        }
    }

    public static InputSource xdmToInputSource(XProcRuntime runtime, XdmNode node) throws SaxonApiException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Serializer serializer = runtime.getProcessor().newSerializer();
        serializer.setOutputStream((OutputStream)out);
        S9apiUtils.serialize(runtime, node, serializer);
        InputSource isource = new InputSource(new ByteArrayInputStream(out.toByteArray()));
        if (node.getBaseURI() != null) {
            isource.setSystemId(node.getBaseURI().toASCIIString());
        }
        return isource;
    }

    public static HashSet<NamespaceUri> excludeInlinePrefixes(XdmNode node, String prefixList) {
        HashSet<NamespaceUri> excludeURIs = new HashSet<NamespaceUri>();
        excludeURIs.add(XProcConstants.NS_XPROC);
        if (prefixList != null) {
            NamespaceMap nsmap = node.getUnderlyingNode().getAllNamespaces();
            boolean all = false;
            for (String pfx : prefixList.split("\\s+")) {
                boolean found = false;
                if ("#all".equals(pfx)) {
                    found = true;
                    all = true;
                } else if ("#default".equals(pfx)) {
                    found = true;
                    if (nsmap.getDefaultNamespace() != NamespaceUri.NULL) {
                        excludeURIs.add(nsmap.getDefaultNamespace());
                    }
                } else {
                    boolean bl = found = nsmap.getURIForPrefix(pfx, false) != null;
                    if (found) {
                        excludeURIs.add(nsmap.getURIForPrefix(pfx, false));
                    }
                }
                if (found) continue;
                throw new XProcException(XProcConstants.staticError(57), node, "No binding for '" + pfx + ":'");
            }
            if (all) {
                Collections.addAll(excludeURIs, nsmap.getURIsAsArray());
            }
        }
        return excludeURIs;
    }

    public static XdmNode removeNamespaces(XProcRuntime runtime, XdmNode node, HashSet<NamespaceUri> excludeNS, boolean preserveUsed) {
        return S9apiUtils.removeNamespaces(runtime.getProcessor(), node, excludeNS, preserveUsed);
    }

    public static XdmNode removeNamespaces(Processor proc, XdmNode node, HashSet<NamespaceUri> excludeNS, boolean preserveUsed) {
        TreeWriter tree = new TreeWriter(proc);
        tree.startDocument(node.getBaseURI());
        S9apiUtils.removeNamespacesWriter(tree, node, excludeNS, preserveUsed);
        tree.endDocument();
        return tree.getResult();
    }

    private static void removeNamespacesWriter(TreeWriter tree, XdmNode node, HashSet<NamespaceUri> excludeNS, boolean preserveUsed) {
        if (node.getNodeKind() == XdmNodeKind.DOCUMENT) {
            XdmSequenceIterator iter = node.axisIterator(Axis.CHILD);
            while (iter.hasNext()) {
                XdmNode cnode = (XdmNode)iter.next();
                S9apiUtils.removeNamespacesWriter(tree, cnode, excludeNS, preserveUsed);
            }
        } else if (node.getNodeKind() == XdmNodeKind.ELEMENT) {
            NamespaceBinding binding;
            boolean usesDefaultNS = "".equals(node.getNodeName().getPrefix()) && node.getNodeName().getNamespaceUri() != NamespaceUri.NULL;
            NamespaceMap nsmap = node.getUnderlyingNode().getAllNamespaces();
            boolean excludeDefault = false;
            boolean changed = false;
            ArrayList<NamespaceBinding> newNS = new ArrayList<NamespaceBinding>();
            Iterator pfxiter = nsmap.iteratePrefixes();
            while (pfxiter.hasNext()) {
                String pfx = (String)pfxiter.next();
                NamespaceUri uri = nsmap.getURIForPrefix(pfx, "".equals(pfx));
                boolean delete = excludeNS.contains(uri);
                boolean bl = excludeDefault = excludeDefault || "".equals(pfx) && delete;
                if ("".equals(pfx) && usesDefaultNS && preserveUsed) {
                    delete = false;
                }
                boolean bl2 = changed = changed || delete;
                if (delete || "xml".equals(pfx)) continue;
                newNS.add(new NamespaceBinding(pfx, uri));
            }
            NodeInfo inode = node.getUnderlyingNode();
            AttributeMap attrs = inode.attributes();
            NodeName newName = NameOfNode.makeName((NodeInfo)inode);
            if (!preserveUsed && excludeNS.contains((binding = newName.getNamespaceBinding()).getNamespaceUri())) {
                newName = new FingerprintedQName("", NamespaceUri.NULL, newName.getLocalPart());
            }
            tree.addStartElement(newName, attrs, inode.getSchemaType(), new NamespaceMap(newNS));
            XdmSequenceIterator iter = node.axisIterator(Axis.CHILD);
            while (iter.hasNext()) {
                XdmNode cnode = (XdmNode)iter.next();
                S9apiUtils.removeNamespacesWriter(tree, cnode, excludeNS, preserveUsed);
            }
            tree.addEndElement();
        } else {
            tree.addSubtree(node);
        }
    }

    public static void dumpTree(XdmNode tree, String message) {
        NodeInfo treeNode = tree.getUnderlyingNode();
        System.err.println(message);
        System.err.println("Dumping tree: " + treeNode.getSystemId() + ", " + tree.getBaseURI());
        XdmSequenceIterator iter = tree.axisIterator(Axis.CHILD);
        while (iter.hasNext()) {
            XdmNode child = (XdmNode)iter.next();
            S9apiUtils.dumpTreeNode(child, "  ");
        }
    }

    private static void dumpTreeNode(XdmNode node, String indent) {
        if (node.getNodeKind() == XdmNodeKind.ELEMENT) {
            System.err.println(indent + node.getNodeName() + ": " + node.getBaseURI());
            XdmSequenceIterator iter = node.axisIterator(Axis.CHILD);
            while (iter.hasNext()) {
                XdmNode child = (XdmNode)iter.next();
                S9apiUtils.dumpTreeNode(child, indent + "  ");
            }
        } else if (node.getNodeKind() == XdmNodeKind.TEXT) {
            System.err.println(indent + "text: ...");
        }
    }

    public static boolean xpathSyntaxError(SaxonApiException sae) {
        Throwable cause = sae.getCause();
        return cause instanceof XPathException;
    }

    public static void assertDocument(XdmNode doc) {
        if (doc.getNodeKind() == XdmNodeKind.DOCUMENT) {
            S9apiUtils.assertDocumentContent((XdmSequenceIterator<XdmNode>)doc.axisIterator(Axis.CHILD));
        } else if (doc.getNodeKind() != XdmNodeKind.ELEMENT) {
            throw XProcException.dynamicError(1, "Document root cannot be " + doc.getNodeKind());
        }
    }

    public static void assertDocumentContent(XdmSequenceIterator<XdmNode> iter) {
        int elemCount = 0;
        while (iter.hasNext()) {
            XdmNode child = (XdmNode)iter.next();
            if (child.getNodeKind() == XdmNodeKind.ELEMENT) {
                if (++elemCount <= 1) continue;
                throw XProcException.dynamicError(1, "Document must have exactly one top-level element");
            }
            if (child.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION || child.getNodeKind() == XdmNodeKind.COMMENT) continue;
            if (child.getNodeKind() == XdmNodeKind.TEXT) {
                if ("".equals(child.getStringValue().trim())) continue;
                throw XProcException.dynamicError(1, "Only whitespace text nodes can appear at the top level in a document");
            }
            throw XProcException.dynamicError(1, "Document cannot have top level " + child.getNodeKind());
        }
    }

    public static AttributeMap mapFromList(List<AttributeInfo> attributes) {
        EmptyAttributeMap map = EmptyAttributeMap.getInstance();
        for (AttributeInfo attr : attributes) {
            map = map.put(attr);
        }
        return map;
    }

    public static XdmNode getParent(XdmNode node) {
        try {
            return node.getParent();
        }
        catch (ClassCastException cce) {
            return null;
        }
    }
}

