/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.util.DefaultBaseURIMapper;
import com.xmlcalabash.util.RebasedNode;
import com.xmlcalabash.util.UniqueSystemIdMapper;
import java.util.function.Function;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.s9api.XdmNode;

public class RebasedDocument
extends GenericTreeInfo {
    private TreeInfo underlyingTree;
    private Function<NodeInfo, String> baseUriMapper;
    private Function<NodeInfo, String> systemIdMapper;

    public RebasedDocument(TreeInfo doc, Function<NodeInfo, String> baseUriMapper, Function<NodeInfo, String> systemIdMapper) {
        super(doc.getConfiguration());
        this.baseUriMapper = baseUriMapper;
        this.systemIdMapper = systemIdMapper;
        this.setRootNode((NodeInfo)this.wrap(doc.getRootNode()));
        this.underlyingTree = doc;
    }

    public RebasedNode wrap(NodeInfo node) {
        return RebasedNode.makeWrapper(node, this, null);
    }

    public boolean isTyped() {
        return this.underlyingTree.isTyped();
    }

    public NodeInfo selectID(String id, boolean getParent) {
        NodeInfo n = this.underlyingTree.selectID(id, false);
        if (n == null) {
            return null;
        }
        return this.wrap(n);
    }

    public TreeInfo getUnderlyingTree() {
        return this.underlyingTree;
    }

    public Function<NodeInfo, String> getBaseUriMapper() {
        return this.baseUriMapper;
    }

    public Function<NodeInfo, String> getSystemIdMapper() {
        return this.systemIdMapper;
    }

    public static XdmNode makeUniqueDocumentId(XdmNode node) {
        DefaultBaseURIMapper bmapper = new DefaultBaseURIMapper(node.getBaseURI().toString());
        UniqueSystemIdMapper smapper = new UniqueSystemIdMapper();
        RebasedDocument rebaser = new RebasedDocument(node.getUnderlyingNode().getTreeInfo(), bmapper, smapper);
        return new XdmNode((NodeInfo)rebaser.wrap(node.getUnderlyingNode()));
    }
}

