/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.util.Input;
import com.xmlcalabash.util.UserArgs;
import net.sf.saxon.om.NamespaceUri;

public class ParseArgs {
    private String[] args = null;
    private int argpos = 0;
    private String arg = null;
    private UserArgs userArgs = new UserArgs();

    public UserArgs parse(String[] args) {
        KeyValuePair v;
        this.args = args;
        this.argpos = 0;
        while (this.arg != null || this.argpos < args.length) {
            KeyValuePair v2;
            String s;
            if (this.arg == null) {
                this.arg = args[this.argpos];
            }
            if (this.arg.startsWith("-P") || this.arg.startsWith("--saxon-processor")) {
                this.userArgs.setSaxonProcessor(this.parseString("P", "saxon-processor"));
                continue;
            }
            if (this.arg.startsWith("--saxon-configuration")) {
                this.userArgs.setSaxonConfig(this.parseString(null, "saxon-configuration"));
                continue;
            }
            if (this.arg.startsWith("-a") || this.arg.startsWith("--schema-aware")) {
                this.userArgs.setSchemaAware(this.parseBoolean("a", "schema-aware"));
                continue;
            }
            if (this.arg.startsWith("-D") || this.arg.startsWith("--debug")) {
                this.userArgs.setDebug(this.parseBoolean("D", "debug"));
                continue;
            }
            if (this.arg.startsWith("--show-messages")) {
                this.userArgs.setShowMessages(this.parseBoolean(null, "show-messages"));
                continue;
            }
            if (this.arg.startsWith("--profile")) {
                this.userArgs.setProfile(this.parseString(null, "profile"));
                continue;
            }
            if (this.arg.startsWith("-S") || this.arg.startsWith("--safe-mode")) {
                this.userArgs.setSafeMode(this.parseBoolean("S", "safe-mode"));
                continue;
            }
            if (this.arg.startsWith("-c") || this.arg.startsWith("--config")) {
                this.userArgs.setConfig(this.parseString("c", "config"));
                continue;
            }
            if (this.arg.startsWith("-G") || this.arg.startsWith("--log-style")) {
                this.userArgs.setLogStyle(this.parseString("G", "log-style"));
                continue;
            }
            if (this.arg.startsWith("-E") || this.arg.startsWith("--entity-resolver")) {
                this.userArgs.setEntityResolverClass(this.parseString("E", "entity-resolver"));
                continue;
            }
            if (this.arg.startsWith("-U") || this.arg.startsWith("--uri-resolver")) {
                this.userArgs.setUriResolverClass(this.parseString("U", "uri-resolver"));
                continue;
            }
            if (this.arg.startsWith("-i") || this.arg.equals("--input")) {
                s = this.parseString("i", "input");
                if (s.contains("=")) {
                    v2 = this.parseOption(s);
                    this.userArgs.addInput(v2.key, v2.value, Input.Type.XML);
                    continue;
                }
                this.userArgs.addInput(null, s, Input.Type.XML);
                continue;
            }
            if (this.arg.startsWith("-d") || this.arg.equals("--data-input")) {
                KeyValuePair v3;
                s = this.parseString("d", "data-input");
                String contentType = null;
                if (s.contains("@")) {
                    v3 = this.parseOption(s, "@");
                    contentType = v3.key;
                    s = v3.value;
                }
                if (s.contains("=")) {
                    v3 = this.parseOption(s);
                    this.userArgs.addInput(v3.key, v3.value, Input.Type.DATA, contentType);
                    continue;
                }
                this.userArgs.addInput(null, s, Input.Type.DATA, contentType);
                continue;
            }
            if (this.arg.startsWith("-o") || this.arg.equals("--output")) {
                s = this.parseString("o", "output");
                if (s.contains("=")) {
                    v2 = this.parseOption(s);
                    this.userArgs.addOutput(v2.key, v2.value);
                    continue;
                }
                this.userArgs.addOutput(null, s);
                continue;
            }
            if (this.arg.startsWith("-b") || this.arg.equals("--binding")) {
                v = this.parseKeyValue("b", "binding");
                this.userArgs.addBinding(v.key, NamespaceUri.of((String)v.value));
                continue;
            }
            if (this.arg.startsWith("-p") || this.arg.equals("--with-param")) {
                v = this.parseKeyValue("p", "with-param");
                this.userArgs.addParam(v.key, v.value);
                continue;
            }
            if (this.arg.startsWith("-v") || this.arg.equals("--version")) {
                this.userArgs.setShowVersion(this.parseBoolean("v", "version"));
                continue;
            }
            if (this.arg.startsWith("-s") || this.arg.startsWith("--step")) {
                this.userArgs.setCurStepName(this.parseString("s", "step"));
                continue;
            }
            if (this.arg.startsWith("-l") || this.arg.startsWith("--library")) {
                this.userArgs.addLibrary(this.parseString("l", "library"));
                continue;
            }
            if (this.arg.startsWith("-X") || this.arg.startsWith("--extension")) {
                String ext = this.parseString("X", "extension");
                if ("general-values".equals(ext)) {
                    this.userArgs.setExtensionValues(true);
                    continue;
                }
                if ("xpointer-on-text".equals(ext)) {
                    this.userArgs.setAllowXPointerOnText(true);
                    continue;
                }
                if ("allow-text-results".equals(ext)) {
                    this.userArgs.setAllowTextResults(true);
                    continue;
                }
                if ("use-xslt-1.0".equals(ext) || "use-xslt-10".equals(ext)) {
                    this.userArgs.setUseXslt10(true);
                    continue;
                }
                if ("html-serializer".equals(ext)) {
                    this.userArgs.setHtmlSerializer(true);
                    continue;
                }
                if ("ignore-invalid-xml-base".equals(ext)) {
                    this.userArgs.setIgnoreInvalidXmlBase(true);
                    continue;
                }
                if ("transparent-json".equals(ext)) {
                    this.userArgs.setTransparentJSON(true);
                    continue;
                }
                if (ext.startsWith("json-flavor=")) {
                    this.userArgs.setJsonFlavor(ext.substring(12));
                    continue;
                }
                throw new XProcException("Unexpected extension: " + ext);
            }
            if (this.arg.startsWith("--serialize")) {
                String ser = this.parseString(null, "serialize");
                String port = null;
                String param = null;
                String value = null;
                int pos = ser.indexOf(61);
                if (pos < 0) {
                    throw new XProcException("Invalid serialization parameter: " + ser);
                }
                param = ser.substring(0, pos);
                value = ser.substring(pos + 1);
                pos = param.indexOf(58);
                if (pos >= 0) {
                    port = param.substring(0, pos);
                    param = param.substring(pos + 1);
                }
                this.userArgs.setSerializationParameter(port, param, value);
                continue;
            }
            if (this.arg.startsWith("-")) {
                throw new XProcException("Unrecognized option: '" + this.arg + "'.");
            }
            if (!this.arg.contains("=")) break;
            v = this.parseOption(this.arg);
            this.userArgs.addOption(v.key, v.value);
            this.arg = null;
            ++this.argpos;
        }
        if (this.argpos < args.length) {
            this.userArgs.setPipeline(args[this.argpos++]);
        }
        while (this.argpos < args.length) {
            if (args[this.argpos].startsWith("-")) {
                throw new XProcException("Only options can occur on the command line after the pipeline document.");
            }
            v = this.parseOption(args[this.argpos++]);
            this.userArgs.addOption(v.key, v.value);
        }
        this.userArgs.checkArgs();
        return this.userArgs;
    }

    public UserArgs parsePiperack(String[] args) {
        KeyValuePair v;
        this.args = args;
        this.argpos = 0;
        while (this.arg != null || this.argpos < args.length) {
            String s;
            if (this.arg == null) {
                this.arg = args[this.argpos];
            }
            if (this.arg.startsWith("-P") || this.arg.startsWith("--saxon-processor")) {
                this.userArgs.setSaxonProcessor(this.parseString("P", "saxon-processor"));
                continue;
            }
            if (this.arg.startsWith("--saxon-configuration")) {
                this.userArgs.setSaxonConfig(this.parseString(null, "saxon-configuration"));
                continue;
            }
            if (this.arg.startsWith("-a") || this.arg.startsWith("--schema-aware")) {
                this.userArgs.setSchemaAware(this.parseBoolean("a", "schema-aware"));
                continue;
            }
            if (this.arg.startsWith("-D") || this.arg.startsWith("--debug")) {
                this.userArgs.setDebug(this.parseBoolean("D", "debug"));
                continue;
            }
            if (this.arg.startsWith("--profile")) {
                this.userArgs.setProfile(this.parseString(null, "profile"));
                continue;
            }
            if (this.arg.startsWith("-S") || this.arg.startsWith("--safe-mode")) {
                this.userArgs.setSafeMode(this.parseBoolean("S", "safe-mode"));
                continue;
            }
            if (this.arg.startsWith("-c") || this.arg.startsWith("--config")) {
                this.userArgs.setConfig(this.parseString("c", "config"));
                continue;
            }
            if (this.arg.startsWith("-G") || this.arg.startsWith("--log-style")) {
                this.userArgs.setLogStyle(this.parseString("G", "log-style"));
                continue;
            }
            if (this.arg.startsWith("-E") || this.arg.startsWith("--entity-resolver")) {
                this.userArgs.setEntityResolverClass(this.parseString("E", "entity-resolver"));
                continue;
            }
            if (this.arg.startsWith("-U") || this.arg.startsWith("--uri-resolver")) {
                this.userArgs.setUriResolverClass(this.parseString("U", "uri-resolver"));
                continue;
            }
            if (this.arg.startsWith("-v") || this.arg.equals("--version")) {
                this.userArgs.setShowVersion(this.parseBoolean("v", "version"));
                continue;
            }
            if (this.arg.startsWith("--piperack-port")) {
                s = this.parseString(null, "piperack-port");
                this.userArgs.setPiperackPort(Integer.parseInt(s));
                continue;
            }
            if (this.arg.startsWith("--piperack-default-expires")) {
                s = this.parseString(null, "piperack-default-expires");
                this.userArgs.setPiperackExpires(Integer.parseInt(s));
                continue;
            }
            if (this.arg.startsWith("-X") || this.arg.startsWith("--extension")) {
                String ext = this.parseString("X", "extension");
                if ("general-values".equals(ext)) {
                    this.userArgs.setExtensionValues(true);
                    continue;
                }
                if ("xpointer-on-text".equals(ext)) {
                    this.userArgs.setAllowXPointerOnText(true);
                    continue;
                }
                if ("use-xslt-1.0".equals(ext) || "use-xslt-10".equals(ext)) {
                    this.userArgs.setUseXslt10(true);
                    continue;
                }
                if ("transparent-json".equals(ext)) {
                    this.userArgs.setTransparentJSON(true);
                    continue;
                }
                if (ext.startsWith("json-flavor=")) {
                    this.userArgs.setJsonFlavor(ext.substring(12));
                    continue;
                }
                throw new XProcException("Unexpected extension: " + ext);
            }
            if (this.arg.startsWith("-")) {
                throw new XProcException("Unrecognized option: '" + this.arg + "'.");
            }
            if (!this.arg.contains("=")) break;
            v = this.parseOption(this.arg);
            this.userArgs.addOption(v.key, v.value);
            this.arg = null;
            ++this.argpos;
        }
        if (this.argpos < args.length) {
            this.userArgs.setPipeline(args[this.argpos++]);
        }
        while (this.argpos < args.length) {
            if (args[this.argpos].startsWith("-")) {
                throw new XProcException("Only options can occur on the command line after the pipeline document.");
            }
            v = this.parseOption(args[this.argpos++]);
            this.userArgs.addOption(v.key, v.value);
        }
        this.userArgs.checkArgs();
        return this.userArgs;
    }

    private boolean parseBoolean(String shortName, String longName) {
        String sOpt = "-" + shortName;
        String lOpt = "--" + longName;
        boolean bool = false;
        if (this.arg.startsWith(sOpt)) {
            bool = true;
            if (this.arg.equals(sOpt)) {
                this.arg = null;
                ++this.argpos;
            } else {
                this.arg = "-" + this.arg.substring(2);
            }
            return bool;
        }
        if (this.arg.equals(lOpt)) {
            bool = true;
            this.arg = null;
            ++this.argpos;
            return bool;
        }
        if (this.arg.startsWith(lOpt + "=")) {
            this.arg = this.arg.substring(lOpt.length() + 1);
            if (!this.arg.equals("true") && !this.arg.equals("false")) {
                throw new XProcException("Unparseable command line argument: " + lOpt + "=" + this.arg);
            }
            bool = this.arg.equals("true");
            this.arg = null;
            ++this.argpos;
            return bool;
        }
        throw new XProcException("Unparseable command line argument: " + this.arg);
    }

    private String parseString(String shortName, String longName) {
        String sOpt;
        String value = null;
        if (shortName != null && this.arg.startsWith(sOpt = "-" + shortName)) {
            if (this.arg.equals(sOpt)) {
                value = this.args[++this.argpos];
                this.arg = null;
                ++this.argpos;
            } else {
                value = this.arg.substring(2);
                this.arg = null;
                ++this.argpos;
            }
            return value;
        }
        String lOpt = "--" + longName;
        if (this.arg.equals(lOpt)) {
            value = this.args[++this.argpos];
            this.arg = null;
            ++this.argpos;
            return value;
        }
        if (this.arg.startsWith(lOpt + "=")) {
            value = this.arg.substring(lOpt.length() + 1);
            this.arg = null;
            ++this.argpos;
            return value;
        }
        throw new XProcException("Unparseable command line argument: " + this.arg);
    }

    private KeyValuePair parseKeyValue(String shortName, String longName) {
        String sOpt = "-" + (shortName == null ? "" : shortName);
        String lOpt = "--" + longName;
        String opt = null;
        if (shortName != null && this.arg.startsWith(sOpt)) {
            if (this.arg.equals(sOpt)) {
                opt = this.args[++this.argpos];
                this.arg = null;
                ++this.argpos;
            } else {
                opt = this.arg.substring(2);
                this.arg = null;
                ++this.argpos;
            }
        } else if (this.arg.equals(lOpt)) {
            opt = this.args[++this.argpos];
            this.arg = null;
            ++this.argpos;
        } else {
            throw new XProcException("Unparseable command line argument: '" + this.arg + "'.");
        }
        return this.parseOption(opt);
    }

    private KeyValuePair parseOption(String opt) {
        return this.parseOption(opt, "=");
    }

    private KeyValuePair parseOption(String opt, String delimiter) {
        String key = null;
        String value = null;
        int delpos = opt.indexOf(delimiter);
        if (delpos <= 0) {
            throw new XProcException("Unparseable command line argument: '" + opt + "'.");
        }
        key = opt.substring(0, delpos);
        value = opt.substring(delpos + 1);
        return new KeyValuePair(key, value);
    }

    private class KeyValuePair {
        public String key = null;
        public String value = null;

        public KeyValuePair(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

