/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TestReporter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTestReporter
implements TestReporter {
    private final Logger logger = LoggerFactory.getLogger(DefaultTestReporter.class);
    XProcRuntime runtime = null;

    public DefaultTestReporter(XProcRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public void runningTest(URI testURI) {
        System.err.println("Running test: " + testURI);
    }

    @Override
    public void startReport(HashMap<String, String> props) {
        GregorianCalendar cal = new GregorianCalendar();
        System.out.println("<test-report xmlns='http://xproc.org/ns/testreport'>");
        System.out.println("<title>XProc Test Results for XML Calabash</title>");
        System.out.print("<date>");
        System.out.print(cal.get(1));
        System.out.print("-");
        if (cal.get(2) + 1 < 10) {
            System.out.print("0");
        }
        System.out.print(cal.get(2) + 1);
        System.out.print("-");
        if (cal.get(5) < 10) {
            System.out.print("0");
        }
        System.out.print(cal.get(5));
        System.out.print("T");
        if (cal.get(11) < 10) {
            System.out.print("0");
        }
        System.out.print(cal.get(11));
        System.out.print(":");
        if (cal.get(12) < 10) {
            System.out.print("0");
        }
        System.out.print(cal.get(12));
        System.out.print(":");
        if (cal.get(13) < 10) {
            System.out.print("0");
        }
        System.out.print(cal.get(13));
        System.out.println("</date>");
        System.out.println("<processor>");
        for (String key : props.keySet()) {
            String value = props.get(key);
            System.out.println("  <" + key + ">" + value + "</" + key + ">");
        }
        System.out.println("</processor>");
    }

    @Override
    public void endReport() {
        System.out.println("</test-report>");
    }

    @Override
    public void startTestSuite() {
        System.out.println("<test-suite>");
    }

    @Override
    public void endTestSuite() {
        System.out.println("</test-suite>");
    }

    @Override
    public void startTestResults(boolean pass, String testfile, String title) {
        String passOrFail = pass ? "pass" : "fail";
        System.out.println("<" + passOrFail + " uri='" + testfile + "'>");
        if (title != null) {
            System.out.println("<title>" + title + "</title>");
        }
    }

    @Override
    public void testError(QName expectedError, QName actualError) {
        System.out.print("<error");
        if (expectedError != null) {
            System.out.print(" expected='" + expectedError + "'");
        }
        System.out.println(">" + actualError + "</error>");
    }

    @Override
    public void testErrorMessages(Vector<String> errorMessages) {
        for (String message : errorMessages) {
            System.out.println("<message>" + this.xmlEscape(message) + "</message>");
        }
    }

    @Override
    public void testExpected(XdmNode expected) {
        if (expected != null) {
            System.out.print("<expected>");
            System.out.print(this.serialize(expected));
            System.out.println("</expected>");
        }
    }

    @Override
    public void testActual(XdmNode actual) {
        if (actual != null) {
            System.out.print("<actual>");
            System.out.print(this.serialize(actual));
            System.out.println("</actual>");
        }
    }

    @Override
    public void endTestResults(boolean pass) {
        String passOrFail = pass ? "pass" : "fail";
        System.out.println("</" + passOrFail + ">");
    }

    private String xmlEscape(String str) {
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        return str;
    }

    public String serialize(XdmNode node) {
        String result = this.serializeAsXML(node);
        result = result.replace("&", "&amp;");
        result = result.replace("<", "&lt;");
        result = result.replace(">", "&gt;");
        return result;
    }

    public String serializeAsXML(XdmNode node) {
        try {
            Serializer serializer = this.runtime.getProcessor().newSerializer();
            serializer.setOutputProperty(Serializer.Property.BYTE_ORDER_MARK, "no");
            serializer.setOutputProperty(Serializer.Property.ENCODING, "utf-8");
            serializer.setOutputProperty(Serializer.Property.INDENT, "yes");
            serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            serializer.setOutputStream((OutputStream)os);
            S9apiUtils.serialize(this.runtime, node, serializer);
            String result = os.toString();
            return result;
        }
        catch (SaxonApiException sae) {
            this.logger.warn("Failed to serialize node: " + node);
            this.logger.debug(sae.getMessage(), (Throwable)sae);
            return "";
        }
    }
}

