/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.QNameUtils;
import com.xmlcalabash.util.S9apiUtils;
import java.util.Iterator;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.trans.XPathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxisNodes
implements Iterable<XdmNode> {
    public static final int NO_PIS = 1;
    public static final int NO_COMMENTS = 2;
    public static final int NO_WHITESPACE = 4;
    public static final int NO_DOC = 8;
    public static final int USE_WHEN = 16;
    public static final int ALL = 0;
    public static final int SIGNIFICANT = 7;
    public static final int PIPELINE = 31;
    private static final int VALID_BITS = 31;
    protected Logger logger = LoggerFactory.getLogger(AxisNodes.class);
    private static final QName use_when = new QName("", "use-when");
    private static final QName p_use_when = XProcConstants.qNameFor(XProcConstants.NS_XPROC, "use-when");
    private AxisNodesIter iter = null;
    private XProcRuntime runtime = null;
    private int filter = 0;

    public AxisNodes(XdmNode start, Axis axis) {
        this.iter = new AxisNodesIter(start, axis);
    }

    public AxisNodes(XdmNode start, Axis axis, int filter) {
        if ((filter | 0x1F) != 31) {
            throw new XProcException("Invalid filter passed to AxisNodes");
        }
        if ((filter & 0x10) == 16) {
            throw new XProcException("Pointless use of USE_WHEN filter in AxisNodes");
        }
        this.filter = filter;
        this.iter = new AxisNodesIter(start, axis);
    }

    public AxisNodes(XProcRuntime runtime, XdmNode start, Axis axis, int filter) {
        if ((filter | 0x1F) != 31) {
            throw new XProcException("Invalid filter passed to AxisNodes");
        }
        this.runtime = runtime;
        this.filter = filter;
        this.iter = new AxisNodesIter(start, axis);
    }

    @Override
    public Iterator<XdmNode> iterator() {
        return this.iter;
    }

    private class AxisNodesIter
    implements Iterator<XdmNode> {
        private XdmSequenceIterator<XdmNode> iter = null;
        private XdmNode next = null;
        private boolean finished = false;
        private boolean hasNext = false;

        public AxisNodesIter(XdmNode start, Axis axis) {
            this.iter = start.axisIterator(axis);
        }

        @Override
        public boolean hasNext() {
            this.hasNext = true;
            if (this.next == null) {
                boolean hasNext = this.iter.hasNext();
                boolean bl = this.finished = this.finished || !hasNext;
                if (this.finished) {
                    return false;
                }
                this.next = (XdmNode)this.iter.next();
                while (this.next != null && !this.ok(this.next)) {
                    if (this.iter.hasNext()) {
                        this.next = (XdmNode)this.iter.next();
                        continue;
                    }
                    this.next = null;
                }
                return this.ok(this.next);
            }
            return true;
        }

        @Override
        public XdmNode next() {
            if (!this.hasNext) {
                this.hasNext();
                this.hasNext = false;
            }
            XdmNode r = this.next;
            this.next = null;
            return r;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported!");
        }

        private boolean ok(XdmNode node) {
            if (node == null) {
                return false;
            }
            if ((AxisNodes.this.filter & 8) == 8 && node.getNodeKind() == XdmNodeKind.ELEMENT && (XProcConstants.p_documentation.equals((Object)node.getNodeName()) || XProcConstants.p_pipeinfo.equals((Object)node.getNodeName()))) {
                return false;
            }
            if ((AxisNodes.this.filter & 2) == 2 && node.getNodeKind() == XdmNodeKind.COMMENT) {
                return false;
            }
            if ((AxisNodes.this.filter & 1) == 1 && node.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION) {
                return false;
            }
            if (node.getNodeKind() == XdmNodeKind.TEXT) {
                if ((AxisNodes.this.filter & 4) == 4) {
                    return !"".equals(node.toString().trim());
                }
                return true;
            }
            if ((AxisNodes.this.filter & 0x10) == 16 && node.getNodeKind() == XdmNodeKind.ELEMENT) {
                String expr = null;
                expr = XProcConstants.NS_XPROC == node.getNodeName().getNamespaceUri() ? node.getAttributeValue(use_when) : node.getAttributeValue(p_use_when);
                if (expr != null) {
                    return this.useWhen(node, expr);
                }
                return true;
            }
            return true;
        }

        private boolean useWhen(XdmNode element, String xpath) {
            boolean use = false;
            if (AxisNodes.this.runtime == null) {
                AxisNodes.this.logger.info("The use-when attribute has no effect on pipelines in a configuration file.");
                return true;
            }
            try {
                XPathCompiler xcomp = AxisNodes.this.runtime.newXPathCompiler(null);
                XdmSequenceIterator nsIter = element.axisIterator(Axis.NAMESPACE);
                while (nsIter.hasNext()) {
                    XdmNode ns = (XdmNode)nsIter.next();
                    xcomp.declareNamespace(ns.getNodeName().getLocalName(), ns.getStringValue());
                }
                XPathExecutable xexec = null;
                xexec = xcomp.compile(xpath);
                XPathSelector selector = xexec.load();
                try {
                    use = selector.effectiveBooleanValue();
                }
                catch (SaxonApiUncheckedException saue) {
                    Throwable sae = saue.getCause();
                    if (sae instanceof XPathException) {
                        XPathException xe = (XPathException)sae;
                        if (QNameUtils.hasForm(xe.getErrorCodeQName(), XProcConstants.NS_XQT_ERRORS, "XPDY0002")) {
                            throw XProcException.dynamicError(26, element, "Expression refers to context when none is available: " + xpath);
                        }
                        throw saue;
                    }
                    throw saue;
                }
            }
            catch (SaxonApiException sae) {
                if (S9apiUtils.xpathSyntaxError(sae)) {
                    throw XProcException.dynamicError(23, element, sae.getCause().getMessage());
                }
                throw new XProcException(sae);
            }
            return use;
        }
    }
}

