/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRunnable;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XInput;
import com.xmlcalabash.runtime.XOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XStep
implements XProcRunnable {
    protected Logger logger = null;
    protected XProcRuntime runtime = null;
    protected Step step = null;
    protected String name = null;
    private HashMap<String, XInput> xinputs = new HashMap();
    private HashMap<String, XOutput> xoutputs = new HashMap();
    private HashMap<QName, RuntimeValue> options = new HashMap();
    private HashMap<String, HashMap<QName, RuntimeValue>> parameters = new HashMap();
    protected XCompoundStep parent = null;
    protected HashMap<QName, RuntimeValue> inScopeOptions = new HashMap();

    public XStep(XProcRuntime runtime, Step step) {
        this.runtime = runtime;
        this.step = step;
        if (step != null) {
            this.name = step.getName();
        }
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public Step getStep() {
        return this.step;
    }

    public XdmNode getNode() {
        return this.step.getNode();
    }

    public QName getType() {
        return this.step.getNode().getNodeName();
    }

    public String getName() {
        return this.name;
    }

    public DeclareStep getDeclareStep() {
        return this.step.getDeclaration();
    }

    public XCompoundStep getParent() {
        return this.parent;
    }

    public void addInput(XInput input) {
        String port = input.getPort();
        if (this.xinputs.containsKey(port)) {
            throw new XProcException(input.getNode(), "Attempt to add output '" + port + "' port to the same step twice.");
        }
        this.xinputs.put(port, input);
    }

    public void addOutput(XOutput output) {
        String port = output.getPort();
        if (this.xoutputs.containsKey(port)) {
            throw new XProcException(output.getNode(), "Attempt to add output '" + port + "' port to the same step twice.");
        }
        this.xoutputs.put(port, output);
    }

    public XInput getInput(String port) {
        if (this.xinputs.containsKey(port)) {
            return this.xinputs.get(port);
        }
        throw new XProcException(this.step.getNode(), "Attempt to get non-existant input '" + port + "' port from step.");
    }

    public XOutput getOutput(String port) {
        if (this.xoutputs.containsKey(port)) {
            return this.xoutputs.get(port);
        }
        if (XProcConstants.NS_XPROC == this.step.getType().getNamespaceUri() && this.step.getStep().getVersion() > 1.0) {
            return null;
        }
        throw new XProcException(this.step.getNode(), "Attempt to get non-existant output '" + port + "' port from step.");
    }

    public void setParameter(QName name, RuntimeValue value) {
        Set<String> ports = this.getParameterPorts();
        int pportCount = 0;
        String pport = null;
        String ppport = null;
        Iterator<String> iterator = ports.iterator();
        while (iterator.hasNext()) {
            String port;
            pport = port = iterator.next();
            ++pportCount;
            Input pin = this.getStep().getInput(port);
            if (!pin.getPrimary()) continue;
            ppport = port;
        }
        if (pportCount == 0) {
            throw new XProcException(this.step.getNode(), "Attempt to set parameter but there's no parameter port.");
        }
        if (ppport != null) {
            pport = ppport;
        } else if (pportCount > 1) {
            throw new XProcException(this.step.getNode(), "Attempt to set parameter w/o specifying a port (and there's more than one)");
        }
        this.setParameter(pport, name, value);
    }

    public void setParameter(String port, QName name, RuntimeValue value) {
        HashMap<Object, RuntimeValue> pparams;
        if (this.parameters.containsKey(port)) {
            pparams = this.parameters.get(port);
        } else {
            XInput xinput = this.getInput(port);
            Input input = this.getDeclareStep().getInput(port);
            if (!input.getParameterInput()) {
                throw new XProcException(this.step.getNode(), "Attempt to write parameters to non-parameter input port: " + port);
            }
            pparams = new HashMap();
            this.parameters.put(port, pparams);
        }
        if (pparams.containsKey(name)) {
            throw new XProcException(this.step.getNode(), "Duplicate parameter: " + name);
        }
        if (XProcConstants.NS_XPROC == name.getNamespaceUri()) {
            throw XProcException.dynamicError(31);
        }
        pparams.put(name, value);
    }

    public Set<QName> getOptions() {
        return this.options.keySet();
    }

    public RuntimeValue getOption(QName name) {
        return this.options.getOrDefault(name, null);
    }

    public void setOption(QName name, RuntimeValue value) {
        this.options.put(name, value);
    }

    public void clearOptions() {
        this.options.clear();
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public Set<QName> getParameters() {
        return this.getParameters("*");
    }

    public RuntimeValue getParameter(QName name) {
        Set<String> ports = this.getParameterPorts();
        int pportCount = 0;
        String pport = null;
        Iterator<String> iterator = ports.iterator();
        while (iterator.hasNext()) {
            String port;
            pport = port = iterator.next();
            ++pportCount;
        }
        if (pportCount != 1) {
            return null;
        }
        return this.getParameter(pport, name);
    }

    public Set<String> getParameterPorts() {
        HashSet<String> ports = new HashSet<String>();
        for (Input input : this.step.inputs()) {
            if (!input.getParameterInput()) continue;
            ports.add(input.getPort());
        }
        return ports;
    }

    public Set<QName> getParameters(String port) {
        if (this.parameters.containsKey(port)) {
            return this.parameters.get(port).keySet();
        }
        return new HashSet<QName>();
    }

    public RuntimeValue getParameter(String port, QName name) {
        HashMap<QName, RuntimeValue> pparams;
        if (this.parameters.containsKey(port) && (pparams = this.parameters.get(port)).containsKey(name)) {
            return pparams.get(name);
        }
        return null;
    }

    public String getExtensionAttribute(QName name) {
        if (this.step != null) {
            return this.step.getExtensionAttribute(name);
        }
        return null;
    }

    public String getInheritedExtensionAttribute(QName name) {
        if (this.getExtensionAttribute(name) != null) {
            return this.getExtensionAttribute(name);
        }
        if (this.parent != null) {
            return this.parent.getInheritedExtensionAttribute(name);
        }
        return null;
    }

    public boolean hasInScopeVariableBinding(QName name) {
        if (this.inScopeOptions.containsKey(name)) {
            return true;
        }
        return this.getParent() != null && this.getParent().hasInScopeVariableBinding(name);
    }

    public boolean hasInScopeVariableValue(QName name) {
        if (this.inScopeOptions.containsKey(name)) {
            RuntimeValue v = this.getOption(name);
            return v.initialized();
        }
        return this.getParent() != null && this.getParent().hasInScopeVariableBinding(name);
    }

    public HashMap<QName, RuntimeValue> getInScopeOptions() {
        HashMap<QName, RuntimeValue> globals = new HashMap<QName, RuntimeValue>();
        if (this.inScopeOptions != null) {
            for (QName name : this.inScopeOptions.keySet()) {
                globals.put(name, this.inScopeOptions.get(name));
            }
        }
        return globals;
    }

    public abstract RuntimeValue optionAvailable(QName var1);

    public abstract void instantiate(Step var1);

    @Override
    public abstract void reset();

    @Override
    public abstract void run() throws SaxonApiException;

    public void error(XdmNode node, String message, QName code) {
        this.runtime.error(this, node, message, code);
    }

    public void warning(XdmNode node, String message) {
        this.runtime.warning(this, node, message);
    }

    public void info(XdmNode node, String message) {
        this.runtime.info(this, node, message);
    }
}

