/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.PipeNameBinding;
import com.xmlcalabash.model.PipelineLibrary;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.runtime.XRootStep;
import net.sf.saxon.s9api.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLibrary {
    private XProcRuntime runtime = null;
    private PipelineLibrary library = null;
    private Logger logger = LoggerFactory.getLogger(XLibrary.class);

    public XLibrary(XProcRuntime runtime, PipelineLibrary library) {
        this.runtime = runtime;
        this.library = library;
    }

    public XPipeline getFirstPipeline() {
        QName name = this.library.firstStep();
        return this.getPipeline(name);
    }

    public QName getFirstPipelineType() {
        return this.library.firstStep();
    }

    public XPipeline getPipeline(QName stepName) {
        DeclareStep step = this.library.getDeclaration(stepName);
        if (step == null) {
            this.runtime.error(null, this.library.getNode(), "No step named " + stepName + " in library.", null);
            return null;
        }
        XRootStep root = new XRootStep(this.runtime);
        if (step.subpipeline().size() == 0) {
            Step atomicReplacement = new Step(this.runtime, step.getNode(), step.getDeclaredType(), step.getName());
            atomicReplacement.setDeclaration(step);
            String wrapper = "XML-CALABASH-GENERATED-WRAPPER-PIPELINE";
            QName ptype = new QName("", "XML-CALABASH-WRAPPER-TYPE");
            DeclareStep pipeline = new DeclareStep(this.runtime, step.getNode(), wrapper);
            for (Input input : step.inputs()) {
                Input pInput = new Input(this.runtime, input.getNode());
                pInput.setPort(input.getPort());
                pInput.setPrimary(input.getPrimary());
                pInput.setSequence(input.getSequence());
                pInput.setParameterInput(input.getParameterInput());
                pipeline.addInput(pInput);
                PipeNameBinding pnb = new PipeNameBinding(this.runtime, input.getNode());
                pnb.setStep(wrapper);
                pnb.setPort(pInput.getPort());
                input.addBinding(pnb);
                atomicReplacement.addInput(input);
            }
            for (Output output : step.outputs()) {
                Output pOutput = new Output(this.runtime, output.getNode());
                pOutput.setPort(output.getPort());
                pOutput.setPrimary(output.getPrimary());
                pOutput.setSequence(output.getSequence());
                Input pInput = new Input(this.runtime, output.getNode());
                pInput.setPort("|" + output.getPort());
                pInput.setSequence(output.getSequence());
                pipeline.addInput(pInput);
                PipeNameBinding pnb = new PipeNameBinding(this.runtime, output.getNode());
                pnb.setStep(step.getName());
                pnb.setPort(output.getPort());
                pInput.addBinding(pnb);
                pipeline.addOutput(pOutput);
                atomicReplacement.addOutput(output);
            }
            pipeline.addStep(atomicReplacement);
            pipeline.setDeclaredType(ptype);
            this.runtime.declareStep(ptype, pipeline);
            step = pipeline;
            step.setup();
        } else {
            step.setup();
        }
        XPipeline xpipeline = new XPipeline(this.runtime, step, root);
        if (this.runtime.getErrorCode() != null) {
            throw new XProcException(this.runtime.getErrorCode(), this.runtime.getErrorMessage());
        }
        xpipeline.instantiate(step);
        return xpipeline;
    }
}

