/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.piperack;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.piperack.BaseStatus;
import com.xmlcalabash.piperack.Help;
import com.xmlcalabash.piperack.Input;
import com.xmlcalabash.piperack.Option;
import com.xmlcalabash.piperack.Options;
import com.xmlcalabash.piperack.Output;
import com.xmlcalabash.piperack.Parameter;
import com.xmlcalabash.piperack.Parameters;
import com.xmlcalabash.piperack.Pipeline;
import com.xmlcalabash.piperack.PipelineConfiguration;
import com.xmlcalabash.piperack.PipelineSource;
import com.xmlcalabash.piperack.Pipelines;
import com.xmlcalabash.piperack.Reset;
import com.xmlcalabash.piperack.Run;
import com.xmlcalabash.piperack.Status;
import com.xmlcalabash.piperack.Stop;
import com.xmlcalabash.runtime.XPipeline;
import java.io.InputStream;
import java.net.URI;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.restlet.Application;
import org.restlet.Restlet;
import org.restlet.routing.Router;
import org.xml.sax.InputSource;

public class PiperackApplication
extends Application {
    private ConcurrentMap<String, PipelineConfiguration> pipes = new ConcurrentHashMap<String, PipelineConfiguration>();
    private XProcConfiguration config = null;
    private XProcRuntime globalRuntime = null;
    private XdmNode xsl = null;
    private boolean stopped = false;

    public PiperackApplication(XProcConfiguration config, XProcRuntime runtime) throws SaxonApiException {
        this.config = config;
        this.globalRuntime = runtime;
        InputStream instream = PiperackApplication.class.getResourceAsStream("/etc/serializepr.xsl");
        if (instream == null) {
            System.err.println("Error: cannot load /etc/serializepr.xsl from jar file");
            System.exit(-1);
        } else {
            SAXSource source = new SAXSource(new InputSource(instream));
            DocumentBuilder builder = config.getProcessor().newDocumentBuilder();
            builder.setLineNumbering(true);
            builder.setBaseURI(URI.create("http://xmlcalabash.com/ns/piperack"));
            this.xsl = builder.build((Source)source);
        }
        for (String name : config.piperackDefaultPipelines.keySet()) {
            PipelineSource src = config.piperackDefaultPipelines.get(name);
            this.loadPipeline(src.uri, name, src.expires);
        }
        this.setStatusService(new BaseStatus(this.globalRuntime));
    }

    public Restlet createInboundRoot() {
        Router router = new Router(this.getContext());
        router.attach("/pipelines", Pipelines.class);
        router.attach("/pipelines/{id}", Pipeline.class);
        router.attach("/pipelines/{id}/inputs/{port}", Input.class);
        router.attach("/pipelines/{id}/outputs/{port}", Output.class);
        router.attach("/pipelines/{id}/options", Options.class);
        router.attach("/pipelines/{id}/options/{option}", Option.class);
        router.attach("/pipelines/{id}/parameters", Parameters.class);
        router.attach("/pipelines/{id}/parameters/{port}", Parameters.class);
        router.attach("/pipelines/{id}/parameters/{port}/{param}", Parameter.class);
        router.attach("/pipelines/{id}/run", Run.class);
        router.attach("/pipelines/{id}/reset", Reset.class);
        router.attach("/status", Status.class);
        router.attach("/help", Help.class);
        router.attach("/stop", Stop.class);
        router.attach("/", Help.class);
        return router;
    }

    public void stop() throws Exception {
        super.stop();
        this.stopped = true;
    }

    public void expirePipelines() {
        Calendar now = GregorianCalendar.getInstance();
        HashSet<String> deleteKeys = new HashSet<String>();
        for (String key : this.pipes.keySet()) {
            PipelineConfiguration pipeconfig = (PipelineConfiguration)this.pipes.get(key);
            if (now.compareTo(pipeconfig.expires) <= 0) continue;
            deleteKeys.add(key);
        }
        for (String key : deleteKeys) {
            System.err.println("Expired: " + key);
            this.pipes.remove(key);
        }
    }

    public ConcurrentMap<String, PipelineConfiguration> getPipelines() {
        return this.pipes;
    }

    public XProcConfiguration getConfiguration() {
        return this.config;
    }

    public XProcRuntime getGlobalRuntime() {
        return this.globalRuntime;
    }

    public XdmNode xsl() {
        return this.xsl;
    }

    public boolean stopped() {
        return this.stopped;
    }

    private void loadPipeline(String uri, String id, int seconds) {
        Calendar expires = GregorianCalendar.getInstance();
        if (seconds >= 0) {
            long millis = seconds;
            long extime = expires.getTimeInMillis() + millis * 1000L;
            expires.setTimeInMillis(extime);
        } else {
            expires.setTimeInMillis(Long.MAX_VALUE);
        }
        XProcRuntime runtime = new XProcRuntime(this.getConfiguration());
        try {
            XdmNode doc = runtime.parse(uri, runtime.getStaticBaseURI().toASCIIString());
            XPipeline pipeline = runtime.use(doc);
            this.getPipelines().put(id, new PipelineConfiguration(runtime, pipeline, expires));
        }
        catch (Exception e) {
            throw new XProcException(e);
        }
    }
}

