/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.piperack;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.piperack.BaseResource;
import com.xmlcalabash.piperack.PipelineConfiguration;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.util.TreeWriter;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import net.sf.saxon.s9api.XdmNode;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.engine.header.Header;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.util.Series;
import org.xml.sax.InputSource;

public class Pipelines
extends BaseResource {
    protected Representation get(Variant variant) {
        TreeWriter tree = new TreeWriter(this.getGlobalRuntime());
        tree.startDocument(URI.create("http://example.com/"));
        tree.addStartElement(pr_pipelines);
        for (String id : this.getPipelines().keySet()) {
            PipelineConfiguration pipeconfig = (PipelineConfiguration)this.getPipelines().get(id);
            tree.addStartElement(pr_pipeline);
            tree.addStartElement(pr_uri);
            tree.addText(this.pipelineUri(id));
            tree.addEndElement();
            tree.addStartElement(pr_has_run);
            tree.addText("" + pipeconfig.ran);
            tree.addEndElement();
            this.formatExpires(tree, pipeconfig.expires);
            tree.addEndElement();
        }
        tree.addEndElement();
        tree.endDocument();
        return new StringRepresentation((CharSequence)this.serialize(tree.getResult(), variant.getMediaType()), variant.getMediaType());
    }

    protected Representation post(Representation entity, Variant variant) {
        Form form = this.getQuery();
        Random random = new Random();
        String name = form.getFirstValue("name");
        String id = null;
        id = name == null ? "" + Math.abs(random.nextLong()) : name;
        while (this.getPipelines().containsKey(id)) {
            if (name == null) {
                id = "" + Math.abs(random.nextLong());
                continue;
            }
            id = name + "-" + Math.abs(random.nextLong());
        }
        int seconds = this.getConfiguration().piperackDefaultExpires;
        String secstr = form.getFirstValue("expires");
        if (secstr != null) {
            seconds = Integer.parseInt(secstr);
        }
        Calendar expires = GregorianCalendar.getInstance();
        if (seconds >= 0) {
            long extime = expires.getTimeInMillis() + (long)(seconds * 1000);
            expires.setTimeInMillis(extime);
        } else {
            expires.setTimeInMillis(Long.MAX_VALUE);
        }
        XProcRuntime runtime = new XProcRuntime(this.getConfiguration());
        try {
            InputSource is = new InputSource(entity.getStream());
            String base = this.getHostRef().toString();
            is.setSystemId(base + "/" + name);
            XdmNode doc = runtime.parse(is);
            XPipeline pipeline = runtime.use(doc);
            this.getPipelines().put(id, new PipelineConfiguration(runtime, pipeline, expires));
        }
        catch (Exception e) {
            throw new XProcException(e);
        }
        Series responseHeaders = (Series)this.getResponse().getAttributes().get("org.restlet.http.headers");
        if (responseHeaders == null) {
            responseHeaders = new Series(Header.class);
            this.getResponse().getAttributes().put("org.restlet.http.headers", responseHeaders);
        }
        responseHeaders.add((Object)new Header("Location", this.pipelineUri(id)));
        TreeWriter tree = new TreeWriter(this.getGlobalRuntime());
        tree.startDocument(URI.create("http://example.com/"));
        tree.addStartElement(pr_response);
        tree.addStartElement(pr_code);
        tree.addText("" + Status.SUCCESS_CREATED.getCode());
        tree.addEndElement();
        if (expires.getTimeInMillis() != Long.MAX_VALUE) {
            tree.addStartElement(pr_expires);
            SimpleDateFormat gmtFrmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
            gmtFrmt.setTimeZone(TimeZone.getTimeZone("GMT"));
            tree.addText(gmtFrmt.format(expires.getTime()));
            tree.addEndElement();
        }
        tree.addStartElement(pr_uri);
        tree.addText(this.pipelineUri(id));
        tree.addEndElement();
        tree.addStartElement(pr_message);
        tree.addText("Created " + this.pipelineUri(id));
        tree.addEndElement();
        tree.addEndElement();
        tree.endDocument();
        this.setStatus(Status.SUCCESS_CREATED);
        return new StringRepresentation((CharSequence)this.serialize(tree.getResult(), variant.getMediaType()), variant.getMediaType());
    }
}

