/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.extensions.UntilUnchanged;
import com.xmlcalabash.model.Binding;
import com.xmlcalabash.model.Catch;
import com.xmlcalabash.model.Choose;
import com.xmlcalabash.model.ComputableValue;
import com.xmlcalabash.model.DataBinding;
import com.xmlcalabash.model.DeclarationScope;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.DocumentBinding;
import com.xmlcalabash.model.EmptyBinding;
import com.xmlcalabash.model.EndPoint;
import com.xmlcalabash.model.ErrorBinding;
import com.xmlcalabash.model.ForEach;
import com.xmlcalabash.model.Group;
import com.xmlcalabash.model.Import;
import com.xmlcalabash.model.InlineBinding;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.Log;
import com.xmlcalabash.model.NamespaceBinding;
import com.xmlcalabash.model.Option;
import com.xmlcalabash.model.Otherwise;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.Parameter;
import com.xmlcalabash.model.PipeNameBinding;
import com.xmlcalabash.model.PipelineLibrary;
import com.xmlcalabash.model.Port;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Serialization;
import com.xmlcalabash.model.SourceArtifact;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.model.Try;
import com.xmlcalabash.model.Variable;
import com.xmlcalabash.model.Viewport;
import com.xmlcalabash.model.When;
import com.xmlcalabash.util.AxisNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TypeUtils;
import com.xmlcalabash.util.URIUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Parser {
    private static QName px_name = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "name");
    private static QName _name = new QName("name");
    private static QName _href = new QName("href");
    private static QName _type = new QName("type");
    private static QName _version = new QName("version");
    private static QName _namespace = new QName("namespace");
    private static QName err_XS0063 = XProcConstants.qNameFor(XProcConstants.NS_XPROC_ERROR, "XS0063");
    private static QName p_use_when = XProcConstants.qNameFor(XProcConstants.NS_XPROC, "use-when");
    private static QName _use_when = new QName("use-when");
    private static QName _exclude_inline_prefixes = new QName("exclude-inline-prefixes");
    private static QName cx_import = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "import");
    private XProcRuntime runtime = null;
    private boolean loadingStandardLibrary = false;
    private Logger logger = LoggerFactory.getLogger(Parser.class);
    private static int importCount = 0;
    private Map<URI, PipelineLibrary> parsedLibraries = new HashMap<URI, PipelineLibrary>();
    private List<DeclareStep> isDeclareStepBodyParsed = new ArrayList<DeclareStep>();

    public Parser(XProcRuntime runtime) {
        this.runtime = runtime;
    }

    @Deprecated
    public DeclareStep loadPipeline(InputStream inputStream) throws SaxonApiException, IOException {
        return this.loadPipeline(inputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeclareStep loadPipeline(InputStream inputStream, String base) throws SaxonApiException, IOException {
        InputSource is = new InputSource(inputStream);
        if (base != null) {
            is.setSystemId(base);
        }
        try {
            XdmNode doc = this.runtime.parse(is);
            DeclareStep declareStep = this.loadPipeline(doc);
            return declareStep;
        }
        finally {
            inputStream.close();
        }
    }

    public DeclareStep loadPipeline(String uri) throws SaxonApiException {
        return this.loadPipeline(uri, URIUtils.cwdAsURI().toASCIIString());
    }

    public DeclareStep loadPipeline(String uri, String base) throws SaxonApiException {
        XdmNode doc = this.runtime.parse(uri, base);
        return this.loadPipeline(doc);
    }

    private DeclareStep loadPipeline(XdmNode doc) throws SaxonApiException {
        XdmNode root = S9apiUtils.getDocumentElement(doc);
        if (!XProcConstants.p_declare_step.equals((Object)root.getNodeName()) && !XProcConstants.p_pipeline.equals((Object)root.getNodeName())) {
            throw new UnsupportedOperationException("Pipelines must be p:pipeline or p:declare-step documents");
        }
        return this.usePipeline(root);
    }

    public DeclareStep usePipeline(XdmNode node) {
        if (node.getNodeKind() == XdmNodeKind.DOCUMENT) {
            node = S9apiUtils.getDocumentElement(node);
        }
        DeclareStep decl = this.readDeclareStep(node, this.runtime);
        this.parseDeclareStepBodyPassTwo(decl);
        return decl;
    }

    public PipelineLibrary loadStandardLibrary() throws FileNotFoundException, URISyntaxException, SaxonApiException {
        URI home = URIUtils.homeAsURI();
        URI cwd = URIUtils.cwdAsURI();
        URI puri = home;
        InputStream instream = this.getClass().getResourceAsStream("/etc/pipeline-library.xml");
        if (instream == null) {
            throw new UnsupportedOperationException("Failed to load standard pipeline library from JAR file");
        }
        XdmNode doc = this.parse(instream, puri);
        XdmNode root = S9apiUtils.getDocumentElement(doc);
        if (!XProcConstants.p_library.equals((Object)root.getNodeName())) {
            throw new UnsupportedOperationException("Pipeline libraries must be p:library documents");
        }
        this.loadingStandardLibrary = true;
        PipelineLibrary library = this.readLibrary(root, null);
        this.loadingStandardLibrary = false;
        return library;
    }

    private XdmNode loadExtensionLibrary() throws FileNotFoundException, URISyntaxException, SaxonApiException {
        URI home;
        URI puri = home = URIUtils.homeAsURI();
        InputStream instream = this.getClass().getResourceAsStream("/etc/extension-library.xml");
        if (instream == null) {
            throw new UnsupportedOperationException("Failed to load XProc pipeline library from JAR file");
        }
        XdmNode doc = this.parse(instream, puri);
        XdmNode root = S9apiUtils.getDocumentElement(doc);
        if (!XProcConstants.p_library.equals((Object)root.getNodeName())) {
            throw new UnsupportedOperationException("Pipeline libraries must be p:library documents");
        }
        return doc;
    }

    @Deprecated
    public PipelineLibrary loadLibrary(InputStream libraryInputStream) throws SaxonApiException, IOException {
        return this.loadLibrary(libraryInputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PipelineLibrary loadLibrary(InputStream libraryInputStream, String base) throws SaxonApiException, IOException {
        InputSource is = new InputSource(libraryInputStream);
        if (base != null) {
            is.setSystemId(base);
        }
        try {
            XdmNode doc = this.runtime.parse(is);
            XdmNode root = S9apiUtils.getDocumentElement(doc);
            PipelineLibrary pipelineLibrary = this.useLibrary(root);
            return pipelineLibrary;
        }
        finally {
            libraryInputStream.close();
        }
    }

    public PipelineLibrary loadLibrary(String libraryURI) throws SaxonApiException {
        XdmNode doc = this.runtime.parse(libraryURI, URIUtils.cwdAsURI().toASCIIString());
        XdmNode root = S9apiUtils.getDocumentElement(doc);
        return this.useLibrary(root);
    }

    public PipelineLibrary useLibrary(XdmNode root) throws SaxonApiException {
        if (!XProcConstants.p_library.equals((Object)root.getNodeName())) {
            throw new UnsupportedOperationException("Pipelines libraries must be p:library documents");
        }
        return this.readLibrary(root, null);
    }

    private XdmNode parse(InputStream instream, URI baseURI) throws SaxonApiException {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setEntityResolver(this.runtime.getResolver());
            SAXSource source = new SAXSource(reader, new InputSource(instream));
            DocumentBuilder builder = this.runtime.getProcessor().newDocumentBuilder();
            builder.setLineNumbering(true);
            builder.setDTDValidation(false);
            builder.setBaseURI(baseURI);
            return builder.build((Source)source);
        }
        catch (SAXException se) {
            throw new XProcException(se);
        }
    }

    private PipelineLibrary readLibrary(XdmNode node, URI baseURI) {
        if (!(XProcConstants.p_library.equals((Object)node.getNodeName()) || XProcConstants.p_pipeline.equals((Object)node.getNodeName()) || XProcConstants.p_declare_step.equals((Object)node.getNodeName()))) {
            this.runtime.error(null, node, "Not a pipeline or library: " + node.getNodeName(), XProcConstants.staticError(52));
            return null;
        }
        if (baseURI != null && this.parsedLibraries.containsKey(baseURI)) {
            return this.parsedLibraries.get(baseURI);
        }
        PipelineLibrary library = new PipelineLibrary(this.runtime, node);
        if (!this.loadingStandardLibrary) {
            library.addImport(this.runtime.getStandardLibrary());
        }
        if (baseURI != null) {
            this.parsedLibraries.put(baseURI, library);
        }
        if (XProcConstants.p_library.equals((Object)node.getNodeName())) {
            Step substep;
            this.checkAttributes(node, new String[]{"xpath-version", "psvi-required", "version", "exclude-inline-prefixes"}, false);
            library.setVersion(this.inheritedVersion(node));
            for (XdmNode snode : new AxisNodes(this.runtime, node, Axis.CHILD, 31)) {
                if (snode.getNodeName().equals((Object)XProcConstants.p_import)) continue;
                substep = this.readStep(library, library, snode);
                if (substep instanceof DeclareStep) {
                    ((DeclareStep)substep).setSourceImport(baseURI);
                    library.addStep((DeclareStep)substep);
                    continue;
                }
                throw new UnsupportedOperationException("A p:library must contain only p:pipeline and p:declare-steps.");
            }
            for (XdmNode snode : new AxisNodes(this.runtime, node, Axis.CHILD, 31)) {
                Import importElem;
                XdmNode root;
                PipelineLibrary lib;
                if (!snode.getNodeName().equals((Object)XProcConstants.p_import) || (lib = this.readLibrary(root = (importElem = (Import)(substep = this.readStep(library, library, snode))).getRoot(), importElem.getHref())) == null) continue;
                library.addImport(lib);
            }
        } else {
            Step substep = this.readStep(library, library, node);
            if (XProcConstants.NS_CALABASH_EX == substep.getDeclaredType().getNamespaceUri() && substep.getDeclaredType().getLocalName().startsWith("anonymousType")) {
                throw XProcException.staticError(53, node, "No type attribute on imported pipeline.");
            }
            if (substep instanceof DeclareStep) {
                ((DeclareStep)substep).setSourceImport(baseURI);
                library.addStep((DeclareStep)substep);
            } else {
                throw new UnsupportedOperationException("A p:library must contain only p:pipeline and p:declare-steps.");
            }
        }
        this.checkExtensionAttributes(node, library);
        return library;
    }

    private Vector<XdmNode> readSignature(Step step) {
        Vector<XdmNode> rest = new Vector<XdmNode>();
        boolean allowPrimary = false;
        boolean allowVariables = false;
        int primaryParamInputCount = 0;
        int primaryDocInputCount = 0;
        int primaryOutputCount = 0;
        HashSet<QName> sig = new HashSet<QName>();
        if (XProcConstants.p_pipeline.equals((Object)step.getType()) || XProcConstants.p_declare_step.equals((Object)step.getType())) {
            sig.add(XProcConstants.p_import);
            sig.add(XProcConstants.p_input);
            sig.add(XProcConstants.p_output);
            sig.add(XProcConstants.p_log);
            sig.add(XProcConstants.p_option);
            sig.add(XProcConstants.p_serialization);
            allowVariables = true;
            allowPrimary = XProcConstants.p_declare_step.equals((Object)step.getType());
        } else if (XProcConstants.p_for_each.equals((Object)step.getType())) {
            sig.add(XProcConstants.p_iteration_source);
            sig.add(XProcConstants.p_output);
            sig.add(XProcConstants.p_log);
            allowVariables = true;
            allowPrimary = true;
        } else if (XProcConstants.cx_until_unchanged.equals((Object)step.getType())) {
            sig.add(XProcConstants.p_iteration_source);
            sig.add(XProcConstants.p_output);
            sig.add(XProcConstants.p_log);
            allowVariables = true;
            allowPrimary = true;
        } else if (XProcConstants.p_viewport.equals((Object)step.getType())) {
            sig.add(XProcConstants.p_viewport_source);
            sig.add(XProcConstants.p_output);
            sig.add(XProcConstants.p_log);
            allowVariables = true;
            allowPrimary = true;
        } else if (XProcConstants.p_choose.equals((Object)step.getType())) {
            sig.add(XProcConstants.p_xpath_context);
            allowVariables = true;
            allowPrimary = true;
        } else if (XProcConstants.p_when.equals((Object)step.getType())) {
            sig.add(XProcConstants.p_xpath_context);
            sig.add(XProcConstants.p_output);
            sig.add(XProcConstants.p_log);
            allowVariables = true;
            allowPrimary = true;
        } else if (XProcConstants.p_group.equals((Object)step.getType()) || XProcConstants.p_catch.equals((Object)step.getType()) || XProcConstants.p_otherwise.equals((Object)step.getType())) {
            sig.add(XProcConstants.p_output);
            sig.add(XProcConstants.p_log);
            allowVariables = true;
            allowPrimary = true;
        } else if (XProcConstants.p_try.equals((Object)step.getType())) {
            allowVariables = true;
        } else {
            sig.add(XProcConstants.p_input);
            sig.add(XProcConstants.p_log);
            sig.add(XProcConstants.p_with_option);
            sig.add(XProcConstants.p_with_param);
        }
        HashMap<Object, Serialization> serializations = new HashMap<Object, Serialization>();
        HashMap<String, Log> loggers = new HashMap<String, Log>();
        int pos = 1;
        boolean done = false;
        for (XdmNode node : new AxisNodes(this.runtime, step.getNode(), Axis.CHILD, 31)) {
            if (done) {
                if (node.getNodeKind() == XdmNodeKind.TEXT) {
                    throw XProcException.staticError(37, node, "Unexpected text: " + node.getStringValue());
                }
                rest.add(node);
                continue;
            }
            if (sig.contains(node.getNodeName())) {
                QName nodeName = node.getNodeName();
                if (XProcConstants.p_input.equals((Object)nodeName) || XProcConstants.p_iteration_source.equals((Object)nodeName) || XProcConstants.p_viewport_source.equals((Object)nodeName) || XProcConstants.p_xpath_context.equals((Object)nodeName)) {
                    Input input = this.readInput(step, node);
                    if (input.getPrimarySet() && input.getPrimary()) {
                        if (!allowPrimary) {
                            throw XProcException.staticError(8, node, "The \"primary\" attribute is not allowed in this context.");
                        }
                        if (input.getParameterInput()) {
                            if (++primaryParamInputCount > 1) {
                                throw XProcException.staticError(30, node, "You cannot have more than one primary parameter input port.");
                            }
                        } else if (++primaryDocInputCount > 1) {
                            throw XProcException.staticError(30, node, "You cannot have more than one primary input port.");
                        }
                    }
                    input.setPosition(pos++);
                    if (step.getInput(input.getPort()) != null || step.getOutput(input.getPort()) != null) {
                        this.runtime.error(null, node, "Duplicate port name: " + input.getPort(), XProcConstants.staticError(11));
                        continue;
                    }
                    step.addInput(input);
                    continue;
                }
                if (XProcConstants.p_output.equals((Object)nodeName)) {
                    Output output = this.readOutput(step, node);
                    if (output.getPrimarySet() && output.getPrimary()) {
                        if (!allowPrimary) {
                            throw XProcException.staticError(8, node, "The \"primary\" attribute is not allowed in this context.");
                        }
                        if (++primaryOutputCount > 1) {
                            throw XProcException.staticError(14, node, "You cannot have more than one primary output port.");
                        }
                    }
                    if (output.getBinding().size() != 0) {
                        Input input = new Input(this.runtime, output.getNode());
                        input.setPort("|" + output.getPort());
                        for (Binding binding : output.getBinding()) {
                            input.addBinding(binding);
                        }
                        output.clearBindings();
                        input.setPrimary(output.getPrimary());
                        input.setSequence(output.getSequence());
                        step.addInput(input);
                    }
                    if (step.getInput(output.getPort()) != null || step.getOutput(output.getPort()) != null) {
                        this.runtime.error(null, node, "Duplicate port name: " + output.getPort(), XProcConstants.staticError(11));
                        continue;
                    }
                    step.addOutput(output);
                    continue;
                }
                if (XProcConstants.p_option.equals((Object)nodeName) || XProcConstants.p_with_option.equals((Object)nodeName)) {
                    if (XProcConstants.p_pipeline.equals((Object)step.getType()) || XProcConstants.p_declare_step.equals((Object)step.getType())) {
                        if (XProcConstants.p_with_option.equals((Object)nodeName)) {
                            throw XProcException.staticError(44, node, "Can't use p:with-option here.");
                        }
                    } else if (XProcConstants.p_option.equals((Object)nodeName)) {
                        throw XProcException.staticError(44, node, "Can't use p:option here.");
                    }
                    Option option = this.readOption(step, node);
                    option.setStep(step);
                    step.addOption(option);
                    continue;
                }
                if (XProcConstants.p_with_param.equals((Object)nodeName)) {
                    Parameter param = this.readParameter(step, node);
                    param.setStep(step);
                    param.setPosition(pos++);
                    step.addParameter(param);
                    continue;
                }
                if (XProcConstants.p_log.equals((Object)nodeName)) {
                    Log log = this.readLog(node);
                    if (log.getPort() == null) {
                        throw XProcException.staticError(26, node, "A p:log must specify a port.");
                    }
                    if (log.getPort() != null && loggers.containsKey(log.getPort())) {
                        throw XProcException.staticError(26, node, "A p:log was specified more than once for the same port: " + log.getPort());
                    }
                    loggers.put(log.getPort(), log);
                    continue;
                }
                if (XProcConstants.p_import.equals((Object)nodeName)) {
                    rest.add(node);
                    continue;
                }
                if (XProcConstants.p_serialization.equals((Object)nodeName)) {
                    Serialization ser = this.readSerialization(node);
                    String port = ser.getPort();
                    if (port == null || serializations.containsKey(port)) {
                        throw XProcException.staticError(39, node, "A p:serialization must specify a port and can only be specified once.");
                    }
                    serializations.put(port, ser);
                    continue;
                }
                throw XProcException.staticError(44, node, "Unexpected element: " + nodeName);
            }
            if (node.getNodeKind() == XdmNodeKind.TEXT) {
                throw XProcException.staticError(37, node, "Unexpected text: " + node.getStringValue());
            }
            done = true;
            rest.add(node);
        }
        int inputCount = 0;
        Port maybePrimaryInput = null;
        for (Input input : step.inputs()) {
            if (input.getParameterInput() || input.getPort().startsWith("|")) continue;
            ++inputCount;
            maybePrimaryInput = input;
        }
        if (inputCount == 1 && !maybePrimaryInput.getPrimary() && !maybePrimaryInput.getPrimarySet()) {
            maybePrimaryInput.setPrimary(true);
        }
        inputCount = 0;
        maybePrimaryInput = null;
        for (Input input : step.inputs()) {
            if (!input.getParameterInput() || input.getPort().startsWith("|")) continue;
            ++inputCount;
            maybePrimaryInput = input;
        }
        if (inputCount == 1 && !maybePrimaryInput.getPrimary() && !maybePrimaryInput.getPrimarySet()) {
            maybePrimaryInput.setPrimary(true);
        }
        int outputCount = 0;
        Port maybePrimaryOutput = null;
        for (Output output : step.outputs()) {
            ++outputCount;
            maybePrimaryOutput = output;
        }
        if (outputCount == 1 && !maybePrimaryOutput.getPrimary() && !maybePrimaryOutput.getPrimarySet()) {
            maybePrimaryOutput.setPrimary(true);
        }
        if (XProcConstants.p_declare_step.equals((Object)step.getType())) {
            for (Output output : step.outputs()) {
                String port = output.getPort();
                if (!serializations.containsKey(port)) continue;
                Serialization serial = (Serialization)serializations.get(port);
                output.setSerialization(serial);
                serializations.remove(port);
            }
            if (serializations.size() != 0) {
                throw XProcException.staticError(39, step.getNode(), "A p:serialization specifies a non-existant port.");
            }
        }
        for (Object port : loggers.keySet()) {
            step.addLog((Log)loggers.get(port));
        }
        boolean vars = false;
        for (XdmNode node : rest) {
            vars = vars || XProcConstants.p_variable.equals((Object)node.getNodeName());
        }
        if (vars) {
            if (!allowVariables) {
                throw XProcException.staticError(44, step.getNode(), "Variables are not allowed here");
            }
            if (!XProcConstants.p_pipeline.equals((Object)step.getType()) && !XProcConstants.p_declare_step.equals((Object)step.getType())) {
                while (rest.size() > 0 && XProcConstants.p_variable.equals((Object)rest.get(0).getNodeName())) {
                    Variable var = this.readVariable(step, rest.remove(0));
                    step.addVariable(var);
                }
            }
        }
        return rest.size() == 0 ? null : rest;
    }

    private Input readInput(Step parent, XdmNode node) {
        QName nodeName = node.getNodeName();
        if (XProcConstants.p_input.equals((Object)nodeName)) {
            this.checkAttributes(node, new String[]{"kind", "port", "primary", "sequence", "select"}, false);
        } else if (XProcConstants.p_iteration_source.equals((Object)nodeName)) {
            this.checkAttributes(node, new String[]{"select"}, false);
        } else if (XProcConstants.p_viewport_source.equals((Object)nodeName) || XProcConstants.p_xpath_context.equals((Object)nodeName)) {
            this.checkAttributes(node, null, false);
        } else {
            throw new UnsupportedOperationException("Unexpected name in readInput: " + nodeName);
        }
        String kind = node.getAttributeValue(new QName("kind"));
        String port = this.checkNCName(node.getAttributeValue(new QName("port")));
        String primary = node.getAttributeValue(new QName("primary"));
        String sequence = node.getAttributeValue(new QName("sequence"));
        String select = node.getAttributeValue(new QName("select"));
        if (!XProcConstants.p_declare_step.equals((Object)parent.node.getNodeName())) {
            if (kind != null) {
                throw XProcException.staticError(8, node, "The 'kind' attribute is only allowed on an input declaration");
            }
            if (sequence != null) {
                throw XProcException.staticError(8, node, "The 'sequence' attribute is only allowed on an input declaration");
            }
        }
        if (port == null && XProcConstants.p_input.equals((Object)node.getNodeName())) {
            throw XProcException.staticError(38, node, "You must specify a port name for all p:input ports.");
        }
        if (kind == null) {
            kind = "document";
        }
        if (!"document".equals(kind) && !"parameter".equals(kind)) {
            this.runtime.error(null, node, "Kind must be document or parameter", XProcConstants.staticError(33));
        }
        if (primary != null && !"true".equals(primary) && !"false".equals(primary)) {
            this.runtime.error(null, node, "Primary must be 'true' or 'false'", XProcConstants.staticError(40));
        }
        if (sequence != null) {
            if ("parameter".equals(kind)) {
                if (!"true".equals(sequence)) {
                    this.runtime.error(null, node, "Sequence cannot be 'false' on a parameter input", XProcConstants.staticError(40));
                }
            } else if (!"true".equals(sequence) && !"false".equals(sequence)) {
                this.runtime.error(null, node, "Sequence must be 'true' or 'false'", XProcConstants.staticError(40));
            }
        }
        if (XProcConstants.p_iteration_source.equals((Object)nodeName)) {
            port = "#iteration-source";
            sequence = "true";
            primary = "true";
        } else if (XProcConstants.p_viewport_source.equals((Object)nodeName)) {
            port = "#viewport-source";
            sequence = "false";
            primary = "true";
        } else if (XProcConstants.p_xpath_context.equals((Object)nodeName)) {
            port = "#xpath-context";
            sequence = "false";
            primary = "true";
        } else if (port == null) {
            throw XProcException.staticError(44, node, "No port name specified on input.");
        }
        Input input = new Input(this.runtime, node);
        input.setPort(port);
        input.setSequence(sequence);
        input.setPrimary(primary);
        if ("parameter".equals(kind)) {
            input.setParameterInput();
            input.setSequence(true);
        }
        input.setDebugReader(node.getAttributeValue(XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "debug-reader")) != null);
        input.setDebugWriter(node.getAttributeValue(XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "debug-writer")) != null);
        if (select != null) {
            input.setSelect(select);
        }
        for (XdmNode snode : new AxisNodes(this.runtime, node, Axis.CHILD, 31)) {
            Binding binding = this.readBinding(parent, snode);
            if (binding == null) continue;
            input.addBinding(binding);
        }
        this.checkExtensionAttributes(node, input);
        return input;
    }

    private Output readOutput(Step parent, XdmNode node) {
        this.checkAttributes(node, new String[]{"port", "primary", "sequence"}, false);
        String port = this.checkNCName(node.getAttributeValue(new QName("port")));
        if (port == null) {
            throw XProcException.staticError(38, node, "You must specify a port name for all p:output ports.");
        }
        String primary = node.getAttributeValue(new QName("primary"));
        String sequence = node.getAttributeValue(new QName("sequence"));
        Output output = new Output(this.runtime, node);
        output.setPort(port);
        output.setSequence(sequence);
        output.setPrimary(primary);
        for (XdmNode snode : new AxisNodes(this.runtime, node, Axis.CHILD, 31)) {
            Binding binding = this.readBinding(parent, snode);
            if (binding == null) continue;
            output.addBinding(binding);
        }
        this.checkExtensionAttributes(node, output);
        return output;
    }

    private Binding readBinding(Step parent, XdmNode node) {
        Binding binding = null;
        QName nodeName = node.getNodeName();
        if (XProcConstants.p_pipe.equals((Object)nodeName)) {
            binding = this.readPipe(node);
        } else if (XProcConstants.p_document.equals((Object)nodeName)) {
            binding = this.readDocument(node);
        } else if (XProcConstants.p_inline.equals((Object)nodeName)) {
            binding = this.readInline(parent, node);
        } else if (XProcConstants.p_empty.equals((Object)nodeName)) {
            binding = this.readEmpty(node);
        } else if (XProcConstants.p_data.equals((Object)nodeName)) {
            binding = this.readData(node);
        } else {
            throw XProcException.staticError(44, node, "Unexpected in input: " + nodeName);
        }
        this.checkExtensionAttributes(node, binding);
        return binding;
    }

    private PipeNameBinding readPipe(XdmNode node) {
        this.checkAttributes(node, new String[]{"port", "step"}, false);
        String step = this.checkNCName(node.getAttributeValue(new QName("step")));
        String port = this.checkNCName(node.getAttributeValue(new QName("port")));
        if (step == null || port == null) {
            if (step == null) {
                throw XProcException.staticError(38, node, "Missing step attribute.");
            }
            throw XProcException.staticError(38, node, "Missing port attribute.");
        }
        PipeNameBinding pipe = new PipeNameBinding(this.runtime, node);
        pipe.setStep(step);
        pipe.setPort(port);
        Iterator<XdmNode> iterator = new AxisNodes(this.runtime, node, Axis.CHILD, 31).iterator();
        if (iterator.hasNext()) {
            XdmNode snode = iterator.next();
            throw new IllegalArgumentException("Unexpected in pipe: " + snode.getNodeName());
        }
        this.checkExtensionAttributes(node, pipe);
        return pipe;
    }

    private DocumentBinding readDocument(XdmNode node) {
        this.checkAttributes(node, new String[]{"href"}, false);
        String href = node.getAttributeValue(new QName("href"));
        DocumentBinding doc = new DocumentBinding(this.runtime, node);
        doc.setHref(href);
        Iterator<XdmNode> iterator = new AxisNodes(this.runtime, node, Axis.CHILD, 31).iterator();
        if (iterator.hasNext()) {
            XdmNode snode = iterator.next();
            throw new IllegalArgumentException("Unexpected in document: " + snode.getNodeName());
        }
        this.checkExtensionAttributes(node, doc);
        return doc;
    }

    private DataBinding readData(XdmNode node) {
        Iterator<XdmNode> iterator;
        this.checkAttributes(node, new String[]{"href", "wrapper", "wrapper-namespace", "wrapper-prefix", "content-type"}, false);
        String href = node.getAttributeValue(new QName("href"));
        String wrapstr = node.getAttributeValue(new QName("wrapper"));
        String wrappfx = node.getAttributeValue(new QName("wrapper-prefix"));
        String wrapns = node.getAttributeValue(new QName("wrapper-namespace"));
        String contentType = node.getAttributeValue(new QName("content-type"));
        if (wrappfx != null && wrapns == null) {
            throw XProcException.dynamicError(34, node, "You cannot specify a prefix without a namespace.");
        }
        if (wrapns != null && wrapstr == null) {
            throw XProcException.dynamicError(34, node, "You cannot specify a namespace without a wrapper.");
        }
        if (wrapns != null && wrapstr != null && wrapstr.indexOf(":") >= 0) {
            throw XProcException.dynamicError(34, node, "You cannot specify a namespace if the wrapper name contains a colon.");
        }
        if (wrapns == null && wrapstr != null && wrapstr.indexOf(":") <= 0) {
            throw XProcException.dynamicError(25, node, "FIXME: what error is this?");
        }
        DataBinding doc = new DataBinding(this.runtime, node);
        doc.setHref(href);
        if (wrapstr != null) {
            if (wrapstr.indexOf(":") > 0) {
                doc.setWrapper(new QName(wrapstr, node));
            } else if (wrappfx != null) {
                doc.setWrapper(new QName(wrappfx, wrapns, wrapstr));
            } else {
                doc.setWrapper(new QName(wrapns, wrapstr));
            }
        }
        if (contentType != null) {
            doc.setContentType(contentType);
        }
        if ((iterator = new AxisNodes(this.runtime, node, Axis.CHILD, 31).iterator()).hasNext()) {
            XdmNode snode = iterator.next();
            throw new IllegalArgumentException("Unexpected in document: " + snode.getNodeName());
        }
        this.checkExtensionAttributes(node, doc);
        return doc;
    }

    private EmptyBinding readEmpty(XdmNode node) {
        this.checkAttributes(node, new String[0], false);
        EmptyBinding empty = new EmptyBinding(this.runtime, node);
        Iterator<XdmNode> iterator = new AxisNodes(this.runtime, node, Axis.CHILD, 31).iterator();
        if (iterator.hasNext()) {
            XdmNode snode = iterator.next();
            throw new IllegalArgumentException("Unexpected in empty: " + snode.getNodeName());
        }
        this.checkExtensionAttributes(node, empty);
        return empty;
    }

    private InlineBinding readInline(Step parent, XdmNode node) {
        this.checkAttributes(node, new String[]{"exclude-inline-prefixes"}, false);
        InlineBinding inline = new InlineBinding(this.runtime, node);
        boolean seenelem = false;
        XdmSequenceIterator iter = node.axisIterator(Axis.CHILD);
        while (iter.hasNext()) {
            XdmNode child = (XdmNode)iter.next();
            if (child.getNodeKind() == XdmNodeKind.ELEMENT) {
                if (seenelem) {
                    throw new IllegalArgumentException("Not a well-formed inline document");
                }
                seenelem = true;
            }
            inline.addNode(child);
        }
        HashSet<NamespaceUri> excludeURIs = S9apiUtils.excludeInlinePrefixes(node, node.getAttributeValue(_exclude_inline_prefixes));
        while (!(parent instanceof DeclareStep)) {
            parent = parent.parent;
        }
        HashSet<NamespaceUri> excluded = ((DeclareStep)parent).getExcludeInlineNamespaces();
        if (excluded != null) {
            excludeURIs.addAll(excluded);
        }
        this.checkExtensionAttributes(node, inline);
        inline.excludeNamespaces(excludeURIs);
        return inline;
    }

    private Option readOption(Step parent, XdmNode node) {
        this.checkAttributes(node, new String[]{"name", "required", "select"}, false);
        String name = node.getAttributeValue(new QName("name"));
        String required = node.getAttributeValue(new QName("required"));
        String select = node.getAttributeValue(new QName("select"));
        String type = node.getAttributeValue(XProcConstants.cx_type);
        if (name == null) {
            throw XProcException.staticError(38, node, "Attribute \"name\" required on p:option");
        }
        QName oname = name.contains(":") ? new QName(name, node) : new QName(name);
        if (XProcConstants.NS_XPROC == oname.getNamespaceUri()) {
            throw XProcException.staticError(28, node, "You cannot specify an option in the p: namespace.");
        }
        if (required != null && !"false".equals(required) && !"true".equals(required)) {
            throw XProcException.staticError(19, node, "The required attribute must be 'true' or 'false'.");
        }
        Option option = new Option(this.runtime, node);
        option.setName(oname);
        option.setRequired(required);
        option.setSelect(select);
        option.setType(type, node);
        this.readNamespaceBindings(parent, option, node, select);
        this.checkExtensionAttributes(node, option);
        return option;
    }

    private Parameter readParameter(Step parent, XdmNode node) {
        this.checkAttributes(node, new String[]{"port", "name", "select"}, false);
        String name = node.getAttributeValue(new QName("name"));
        String select = node.getAttributeValue(new QName("select"));
        String port = this.checkNCName(node.getAttributeValue(new QName("port")));
        if (name == null) {
            this.runtime.error(null, node, "Attribute \"name\" required on p:with-param", XProcConstants.staticError(38));
        }
        Parameter parameter = new Parameter(this.runtime, node);
        parameter.setPort(port);
        if (name.contains(":")) {
            parameter.setName(new QName(name, node));
        } else {
            parameter.setName(new QName("", name));
        }
        parameter.setSelect(select);
        this.readNamespaceBindings(parent, parameter, node, select);
        this.checkExtensionAttributes(node, parameter);
        return parameter;
    }

    private Variable readVariable(Step parent, XdmNode node) {
        this.checkAttributes(node, new String[]{"name", "select"}, false);
        String name = node.getAttributeValue(new QName("name"));
        String select = node.getAttributeValue(new QName("select"));
        QName oname = new QName(name, node);
        if (oname.getPrefix() == null || "".equals(oname.getPrefix())) {
            oname = new QName("", name);
        }
        if (XProcConstants.NS_XPROC == oname.getNamespaceUri()) {
            throw XProcException.staticError(28, node, "You cannot specify a variable in the p: namespace.");
        }
        Variable variable = new Variable(this.runtime, node);
        variable.setName(oname);
        variable.setSelect(select);
        this.readNamespaceBindings(parent, variable, node, select);
        this.checkExtensionAttributes(node, variable);
        return variable;
    }

    private void readNamespaceBindings(Step parent, EndPoint endpoint, XdmNode node, String select) {
        boolean hadNamespaceBinding = false;
        for (XdmNode snode : new AxisNodes(this.runtime, node, Axis.CHILD, 31)) {
            QName nodeName = snode.getNodeName();
            if (XProcConstants.p_namespaces.equals((Object)nodeName)) {
                hadNamespaceBinding = true;
                NamespaceBinding nsbinding = new NamespaceBinding(this.runtime, snode);
                this.checkAttributes(snode, new String[]{"binding", "element", "except-prefixes"}, false);
                String value = snode.getAttributeValue(new QName("binding"));
                if (value != null) {
                    nsbinding.setBinding(value);
                }
                if ((value = snode.getAttributeValue(new QName("element"))) != null) {
                    nsbinding.setXPath(value);
                }
                if ((value = snode.getAttributeValue(new QName("except-prefixes"))) != null) {
                    for (String pfx : value.split("\\s+")) {
                        try {
                            QName n = new QName(pfx + ":localName", snode);
                            nsbinding.addExcludedNamespace(n.getNamespaceUri());
                        }
                        catch (IllegalArgumentException iae) {
                            throw XProcException.staticError(51, node, "Unbound prefix in except-prefixes: " + pfx);
                        }
                    }
                }
                ((ComputableValue)((Object)endpoint)).addNamespaceBinding(nsbinding);
                Iterator<XdmNode> iterator = new AxisNodes(this.runtime, snode, Axis.CHILD, 31).iterator();
                if (!iterator.hasNext()) continue;
                XdmNode tnode = (XdmNode)iterator.next();
                throw XProcException.staticError(44, snode, "p:namespaces must be empty");
            }
            Binding binding = this.readBinding(parent, snode);
            if (binding == null) continue;
            if (XProcConstants.p_option.equals((Object)node.getNodeName())) {
                throw XProcException.staticError(44, node, "No bindings allowed.");
            }
            endpoint.addBinding(binding);
        }
        if (!hadNamespaceBinding) {
            if (select != null && select.matches("^\\$[a-zA-Z_][-a-zA-Z0-9_]*$")) {
                String string = select.substring(1);
            }
            NamespaceBinding nsbinding = new NamespaceBinding(this.runtime, node);
            ((ComputableValue)((Object)endpoint)).addNamespaceBinding(nsbinding);
        }
    }

    private Serialization readSerialization(XdmNode node) {
        this.checkAttributes(node, new String[]{"port", "byte-order-mark", "cdata-section-elements", "doctype-public", "doctype-system", "encoding", "escape-uri-attributes", "include-content-type", "indent", "media-type", "method", "normalization-form", "omit-xml-declaration", "standalone", "undeclare-prefixes", "version"}, false);
        Serialization serial = new Serialization(this.runtime, node);
        String value = node.getAttributeValue(new QName("port"));
        serial.setPort(value);
        value = node.getAttributeValue(new QName("byte-order-mark"));
        if (value != null) {
            this.checkBoolean(node, "byte-order-mark", value);
            serial.setByteOrderMark("true".equals(value));
        }
        if ((value = node.getAttributeValue(new QName("cdata-section-elements"))) != null) {
            StringBuilder sb = new StringBuilder();
            for (String qname : value.split("\\s+")) {
                QName name = new QName(qname, node);
                sb.append(name.getClarkName());
                sb.append(" ");
            }
            serial.setCdataSectionElements(sb.toString());
        }
        value = node.getAttributeValue(new QName("doctype-public"));
        serial.setDoctypePublic(value);
        value = node.getAttributeValue(new QName("doctype-system"));
        serial.setDoctypeSystem(value);
        value = node.getAttributeValue(new QName("encoding"));
        serial.setEncoding(value);
        value = node.getAttributeValue(new QName("escape-uri-attributes"));
        if (value != null) {
            this.checkBoolean(node, "escape-uri-attributes", value);
            serial.setEscapeURIAttributes("true".equals(value));
        }
        if ((value = node.getAttributeValue(new QName("include-content-type"))) != null) {
            this.checkBoolean(node, "include-content-type", value);
            serial.setIncludeContentType("true".equals(value));
        }
        if ((value = node.getAttributeValue(new QName("indent"))) != null) {
            this.checkBoolean(node, "indent", value);
            serial.setIndent("true".equals(value));
        }
        value = node.getAttributeValue(new QName("media-type"));
        serial.setMediaType(value);
        value = node.getAttributeValue(new QName("method"));
        if (value != null) {
            QName name = null;
            name = value.contains(":") ? new QName(value, node) : new QName("", value);
            if ("".equals(name.getPrefix())) {
                String method = name.getLocalName();
                if ("html".equals(method) || "xhtml".equals(method) || "text".equals(method) || "xml".equals(method)) {
                    serial.setMethod(name);
                } else {
                    this.runtime.error(null, node, "Only the xml, xhtml, html, and text serialization methods are supported.", XProcConstants.stepError(1));
                }
            } else {
                this.runtime.error(null, node, "Only the xml, xhtml, html, and text serialization methods are supported.", XProcConstants.stepError(1));
            }
        }
        value = node.getAttributeValue(new QName("normalization-form"));
        serial.setNormalizationForm(value);
        value = node.getAttributeValue(new QName("omit-xml-declaration"));
        if (value != null) {
            this.checkBoolean(node, "omit-xml-declaration", value);
            serial.setOmitXMLDeclaration("true".equals(value));
        }
        value = node.getAttributeValue(new QName("standalone"));
        serial.setStandalone(value);
        value = node.getAttributeValue(new QName("undeclare-prefixes"));
        if (value != null) {
            this.checkBoolean(node, "undeclare-prefixes", value);
            serial.setUndeclarePrefixes("true".equals(value));
        }
        value = node.getAttributeValue(new QName("version"));
        serial.setVersion(value);
        Iterator<XdmNode> iterator = new AxisNodes(this.runtime, node, Axis.CHILD, 31).iterator();
        if (iterator.hasNext()) {
            XdmNode snode = iterator.next();
            throw XProcException.staticError(44, node, "p:serialization must be empty.");
        }
        this.checkExtensionAttributes(node, serial);
        return serial;
    }

    private void checkBoolean(XdmNode node, String name, String value) {
        if (value != null && !"true".equals(value) && !"false".equals(value)) {
            this.runtime.error(null, node, name + " on serialization must be 'true' or 'false'", XProcConstants.staticError(40));
        }
    }

    private Log readLog(XdmNode node) {
        this.checkAttributes(node, new String[]{"port", "href"}, false);
        String port = this.checkNCName(node.getAttributeValue(new QName("port")));
        String href = node.getAttributeValue(new QName("href"));
        URI hrefURI = null;
        if (href != null) {
            hrefURI = node.getBaseURI().resolve(href);
        }
        Log log = new Log(this.runtime, node);
        log.setPort(port);
        log.setHref(hrefURI);
        this.checkExtensionAttributes(node, log);
        Iterator<XdmNode> iterator = new AxisNodes(this.runtime, node, Axis.CHILD, 31).iterator();
        if (iterator.hasNext()) {
            XdmNode snode = iterator.next();
            throw XProcException.staticError(44, node, "p:log must be empty");
        }
        this.checkExtensionAttributes(node, log);
        return log;
    }

    private Step readStep(Step parent, DeclarationScope declScope, XdmNode node) {
        QName stepType = node.getNodeName();
        if (XProcConstants.p_declare_step.equals((Object)stepType) || XProcConstants.p_pipeline.equals((Object)stepType)) {
            return this.readDeclareStep(node, declScope);
        }
        if (XProcConstants.p_import.equals((Object)stepType)) {
            return this.readImport(node);
        }
        if (XProcConstants.p_for_each.equals((Object)stepType)) {
            return this.readForEach(parent, node);
        }
        if (XProcConstants.p_viewport.equals((Object)stepType)) {
            return this.readViewport(parent, node);
        }
        if (XProcConstants.p_choose.equals((Object)stepType)) {
            return this.readChoose(parent, node);
        }
        if (XProcConstants.p_when.equals((Object)stepType)) {
            return this.readWhen(parent, node);
        }
        if (XProcConstants.p_otherwise.equals((Object)stepType)) {
            return this.readOtherwise(parent, node);
        }
        if (XProcConstants.p_group.equals((Object)stepType)) {
            return this.readGroup(parent, node);
        }
        if (XProcConstants.p_try.equals((Object)stepType)) {
            return this.readTry(parent, node);
        }
        if (XProcConstants.p_catch.equals((Object)stepType)) {
            return this.readCatch(parent, node);
        }
        if (XProcConstants.cx_until_unchanged.equals((Object)stepType)) {
            return this.readUntilUnchanged(parent, node);
        }
        DeclareStep decl = declScope.getDeclaration(stepType);
        if (decl == null) {
            throw XProcException.staticError(44, node, "Unexpected step name: " + stepType);
        }
        this.checkAttributes(node, new String[]{"name"}, true);
        String stepName = this.checkNCName(node.getAttributeValue(new QName("name")));
        Step step = new Step(this.runtime, node, stepType, stepName);
        step.setDeclaration(decl);
        step.parent = parent;
        boolean pStep = XProcConstants.NS_XPROC == node.getNodeName().getNamespaceUri();
        for (XdmNode attr : new AxisNodes(node, Axis.ATTRIBUTE)) {
            QName aname = attr.getNodeName();
            if (pStep && aname.equals((Object)_use_when) || !pStep && aname.equals((Object)p_use_when)) continue;
            if (NamespaceUri.NULL == aname.getNamespaceUri()) {
                if ("name".equals(aname.getLocalName())) continue;
                Option option = new Option(this.runtime, node);
                option.setName(new QName("", aname.getLocalName()));
                option.setSelect("'" + attr.getStringValue().replace("'", "''") + "'");
                option.addNamespaceBinding(new NamespaceBinding(step.getXProc(), node));
                step.addOption(option);
                continue;
            }
            step.addExtensionAttribute(attr);
        }
        Vector<XdmNode> rest = this.readSignature(step);
        if (rest != null) {
            String message = "A " + stepType + " step must contain only a signature.";
            message = XProcConstants.p_option.equals((Object)rest.get(0).getNodeName()) ? message + " p:option is not allowed, did you mean p:with-option instead?" : (XProcConstants.p_parameter.equals((Object)rest.get(0).getNodeName()) ? message + " p:parameter is not allowed, did you mean p:with-param instead?" : message + " " + rest.get(0).getNodeName() + " not allowed.");
            throw XProcException.staticError(44, rest.get(0), message);
        }
        return step;
    }

    private DeclareStep readDeclareStep(XdmNode node, DeclarationScope declScope) {
        Vector<XdmNode> rest;
        XdmNode parent;
        QName name = node.getNodeName();
        if (!name.equals((Object)XProcConstants.p_declare_step) && !name.equals((Object)XProcConstants.p_pipeline)) {
            throw XProcException.staticError(59, node, "Expected p:declare-step or p:pipeline, got " + name);
        }
        this.checkAttributes(node, new String[]{"type", "name", "version", "psvi-required", "xpath-version", "exclude-inline-prefixes"}, false);
        String stepName = this.checkNCName(node.getAttributeValue(_name));
        String typeName = node.getAttributeValue(_type);
        QName type = null;
        if (typeName == null) {
            type = TypeUtils.generateUniqueType();
        } else {
            if (typeName.indexOf(":") <= 0) {
                throw XProcException.staticError(25, node, "Type must be in a namespace.");
            }
            type = new QName(typeName, node);
            if (!this.loadingStandardLibrary && XProcConstants.NS_XPROC == type.getNamespaceUri()) {
                throw XProcException.staticError(25, node, "Type cannot be in the p: namespace.");
            }
        }
        DeclareStep step = new DeclareStep(this.runtime, node, stepName);
        step.setVersion(this.inheritedVersion(node));
        boolean psviRequired = this.booleanAttr(node.getAttributeValue(new QName("psvi-required")));
        String xpathVersion = node.getAttributeValue(new QName("xpath-version"));
        if (!"1.0".equals(xpathVersion) && xpathVersion != null && !"2.0".equals(xpathVersion)) {
            throw XProcException.dynamicError(27, node, "XPath version must be 1.0 or 2.0.");
        }
        for (XdmNode attr : new AxisNodes(node, Axis.ATTRIBUTE)) {
            QName aname = attr.getNodeName();
            if (NamespaceUri.NULL == aname.getNamespaceUri()) {
                if ("type".equals(aname.getLocalName()) || "name".equals(aname.getLocalName()) || "version".equals(aname.getLocalName()) || "use-when".equals(aname.getLocalName()) || "psvi-required".equals(aname.getLocalName()) || "xpath-version".equals(aname.getLocalName()) || "exclude-inline-prefixes".equals(aname.getLocalName())) continue;
                throw XProcException.staticError(44, node, "Attribute not allowed: " + aname.getLocalName());
            }
            step.addExtensionAttribute(attr);
        }
        step.setDeclaredType(type);
        step.setPsviRequired(psviRequired);
        step.setXPathVersion(xpathVersion);
        HashSet<NamespaceUri> excludeURIs = S9apiUtils.excludeInlinePrefixes(node, node.getAttributeValue(_exclude_inline_prefixes));
        if (S9apiUtils.getParent(node) != null && (parent = node.getParent()).getAttributeValue(_exclude_inline_prefixes) != null && (XProcConstants.p_library.equals((Object)parent.getNodeName()) || XProcConstants.p_pipeline.equals((Object)parent.getNodeName()) || XProcConstants.p_declare_step.equals((Object)parent.getNodeName()))) {
            HashSet<NamespaceUri> pexcl = S9apiUtils.excludeInlinePrefixes(parent, parent.getAttributeValue(_exclude_inline_prefixes));
            excludeURIs.addAll(pexcl);
        }
        step.setExcludeInlineNamespaces(excludeURIs);
        if (name.equals((Object)XProcConstants.p_pipeline)) {
            Input input = new Input(this.runtime, node);
            input.setPort("source");
            input.setPrimary(true);
            input.setSequence(false);
            step.addInput(input);
            input = new Input(this.runtime, node);
            input.setPort("parameters");
            input.setParameterInput(true);
            input.setPrimary(true);
            input.setSequence(true);
            step.addInput(input);
            Output output = new Output(this.runtime, node);
            output.setPort("result");
            output.setPrimary(true);
            output.setSequence(false);
            step.addOutput(output);
        }
        step.setAtomic((rest = this.readSignature(step)) == null);
        step.setParentScope(declScope);
        declScope.declareStep(step.getDeclaredType(), step);
        for (Input input : step.inputs()) {
            if (step.isAtomic()) {
                if (input.getBinding().size() == 0) continue;
                this.runtime.error(null, input.getNode(), "Input bindings are not allowed on an atomic step", XProcConstants.staticError(42));
                continue;
            }
            if (input.getPort().startsWith("|")) continue;
            for (Binding binding : input.getBinding()) {
                if (binding.getBindingType() != 1) continue;
                this.runtime.error(null, input.getNode(), "Default input bindings cannot use p:pipe", XProcConstants.staticError(44));
            }
        }
        for (Output output : step.outputs()) {
            Input input = step.getInput("|" + output.getPort());
            if (!step.isAtomic() || input == null) continue;
            this.runtime.error(null, output.getNode(), "Output bindings are not allowed on an atomic step", XProcConstants.staticError(29));
        }
        Vector<XdmNode> steps = new Vector<XdmNode>();
        if (rest != null) {
            for (XdmNode substepNode : rest) {
                SourceArtifact var;
                if (XProcConstants.p_variable.equals((Object)substepNode.getNodeName())) {
                    var = this.readVariable(step, substepNode);
                    step.addVariable((Variable)var);
                    continue;
                }
                if (cx_import.equals((Object)substepNode.getNodeName())) {
                    this.importFunctions(substepNode);
                    continue;
                }
                if (XProcConstants.p_declare_step.equals((Object)substepNode.getNodeName()) || XProcConstants.p_pipeline.equals((Object)substepNode.getNodeName())) {
                    var = (DeclareStep)this.readStep(step, step, substepNode);
                    continue;
                }
                if (XProcConstants.p_import.equals((Object)substepNode.getNodeName())) {
                    Import importElem = (Import)this.readStep(step, step, substepNode);
                    XdmNode root = importElem.getRoot();
                    PipelineLibrary lib = this.readLibrary(root, importElem.getHref());
                    if (lib == null) continue;
                    step.addImport(lib);
                    continue;
                }
                steps.add(substepNode);
            }
            step.checkPrimaryIO();
            rest = steps;
        }
        step.setXmlContent(rest);
        return step;
    }

    private void parseDeclareStepBodyPassTwo(DeclareStep step) {
        if (this.isDeclareStepBodyParsed.contains(step)) {
            return;
        }
        this.isDeclareStepBodyParsed.add(step);
        for (QName type : step.getInScopeTypes()) {
            this.parseDeclareStepBodyPassTwo(step.getDeclaration(type));
        }
        Vector<XdmNode> rest = step.getXmlContent();
        if (rest != null) {
            for (XdmNode substepNode : rest) {
                Step substep = this.readStep(step, step, substepNode);
                step.addStep(substep);
            }
        }
    }

    private Double inheritedVersion(XdmNode node) {
        String version;
        XdmNode parent = S9apiUtils.getParent(node);
        if ((XProcConstants.p_declare_step.equals((Object)node.getNodeName()) || XProcConstants.p_pipeline.equals((Object)node.getNodeName()) || XProcConstants.p_library.equals((Object)node.getNodeName())) && (version = node.getAttributeValue(_version)) != null) {
            TypeUtils.checkType(this.runtime, version, XProcConstants.xs_decimal, node, err_XS0063);
            return Double.parseDouble(version);
        }
        if (parent == null) {
            throw XProcException.staticError(62, node, "Version attribute is required.");
        }
        return this.inheritedVersion(parent);
    }

    private Import readImport(XdmNode node) {
        XdmNode doc;
        this.checkAttributes(node, new String[]{"href"}, false);
        String href = node.getAttributeValue(_href);
        URI importURI = node.getBaseURI().resolve(href);
        Iterator<XdmNode> iterator = new AxisNodes(this.runtime, node, Axis.CHILD, 31).iterator();
        if (iterator.hasNext()) {
            XdmNode child = iterator.next();
            throw new UnsupportedOperationException("p:import must be empty.");
        }
        Import importElem = new Import(this.runtime, node);
        try {
            doc = importURI.toASCIIString().equals(XProcConstants.CALABASH_EXTENSION_LIBRARY_1_0) ? this.loadExtensionLibrary() : this.runtime.parse(href, node.getBaseURI().toASCIIString());
        }
        catch (XProcException xe) {
            if (XProcConstants.dynamicError(11).equals((Object)xe.getErrorCode())) {
                throw XProcException.staticError(52, node, xe.getCause(), "Cannot import: " + importURI.toASCIIString());
            }
            throw xe;
        }
        catch (Exception e) {
            throw new XProcException(e);
        }
        importURI = doc.getBaseURI();
        importElem.setHref(importURI);
        importElem.setRoot(S9apiUtils.getDocumentElement(doc));
        this.checkExtensionAttributes(node, importElem);
        return importElem;
    }

    private ForEach readForEach(Step parent, XdmNode node) {
        QName name = node.getNodeName();
        if (!XProcConstants.p_for_each.equals((Object)name)) {
            throw new UnsupportedOperationException("Can't parse " + name + " as a pipeline!");
        }
        this.checkAttributes(node, new String[]{"name"}, false);
        String stepName = this.checkNCName(node.getAttributeValue(_name));
        ForEach step = new ForEach(this.runtime, node, stepName);
        this.checkExtensionAttributes(node, step);
        step.setParentScope((DeclareStep)parent);
        step.parent = parent;
        Vector<XdmNode> rest = this.readSignature(step);
        if (rest == null) {
            throw XProcException.staticError(15, node, "A p:for-each must contain a subpipeline.");
        }
        for (XdmNode substepNode : rest) {
            Step substep = this.readStep(step, step, substepNode);
            step.addStep(substep);
        }
        step.checkPrimaryIO();
        return step;
    }

    private UntilUnchanged readUntilUnchanged(Step parent, XdmNode node) {
        QName name = node.getNodeName();
        if (!XProcConstants.cx_until_unchanged.equals((Object)name)) {
            throw new UnsupportedOperationException("Can't parse " + name + " as a cx:until-unchanged!");
        }
        this.checkAttributes(node, new String[]{"name"}, false);
        String stepName = this.checkNCName(node.getAttributeValue(_name));
        UntilUnchanged step = new UntilUnchanged(this.runtime, node, stepName);
        this.checkExtensionAttributes(node, step);
        step.setParentScope((DeclareStep)parent);
        step.parent = parent;
        Vector<XdmNode> rest = this.readSignature(step);
        if (rest == null) {
            throw XProcException.staticError(15, node, "A cx:until-unchanged must contain a subpipeline.");
        }
        for (XdmNode substepNode : rest) {
            Step substep = this.readStep(step, step, substepNode);
            step.addStep(substep);
        }
        step.checkPrimaryIO();
        return step;
    }

    private Viewport readViewport(Step parent, XdmNode node) {
        QName name = node.getNodeName();
        if (!XProcConstants.p_viewport.equals((Object)name)) {
            throw new UnsupportedOperationException("Can't parse " + name + " as a pipeline!");
        }
        this.checkAttributes(node, new String[]{"name", "match"}, false);
        String stepName = this.checkNCName(node.getAttributeValue(_name));
        RuntimeValue match = new RuntimeValue(node.getAttributeValue(new QName("match")), node);
        Viewport step = new Viewport(this.runtime, node, stepName);
        this.checkExtensionAttributes(node, step);
        step.setParentScope((DeclareStep)parent);
        step.parent = parent;
        step.setMatch(match);
        Vector<XdmNode> rest = this.readSignature(step);
        if (rest == null) {
            throw XProcException.staticError(15, node, "A p:viewport must contain a subpipeline.");
        }
        for (XdmNode substepNode : rest) {
            Step substep = this.readStep(step, step, substepNode);
            step.addStep(substep);
        }
        step.checkPrimaryIO();
        return step;
    }

    private Choose readChoose(Step parent, XdmNode node) {
        this.checkAttributes(node, new String[]{"name"}, false);
        String stepName = this.checkNCName(node.getAttributeValue(_name));
        Choose step = new Choose(this.runtime, node, stepName);
        this.checkExtensionAttributes(node, step);
        step.setParentScope((DeclareStep)parent);
        step.parent = parent;
        Vector<XdmNode> rest = this.readSignature(step);
        if (rest == null) {
            throw XProcException.staticError(15, node, "A p:choose must contain at least one p:when.");
        }
        for (XdmNode child : rest) {
            DeclareStep substep;
            if (XProcConstants.p_when.equals((Object)child.getNodeName())) {
                substep = this.readWhen(step, child);
                step.addStep(substep);
                continue;
            }
            if (XProcConstants.p_otherwise.equals((Object)child.getNodeName())) {
                substep = this.readOtherwise(step, child);
                step.addStep(substep);
                continue;
            }
            throw new UnsupportedOperationException("Not valid in a choose: " + child.getNodeName());
        }
        step.checkPrimaryIO();
        return step;
    }

    private When readWhen(Step parent, XdmNode node) {
        this.checkAttributes(node, new String[]{"test"}, false);
        String stepName = this.checkNCName(node.getAttributeValue(px_name));
        String testExpr = node.getAttributeValue(new QName("test"));
        When step = new When(this.runtime, node, stepName);
        this.checkExtensionAttributes(node, step);
        step.setTest(testExpr);
        step.setParentScope((DeclareStep)parent);
        step.parent = parent;
        Vector<XdmNode> rest = this.readSignature(step);
        if (rest == null) {
            throw XProcException.staticError(15, node, "A p:when must contain a subpipeline.");
        }
        for (XdmNode substepNode : rest) {
            Step substep = this.readStep(step, step, substepNode);
            step.addStep(substep);
        }
        step.checkPrimaryIO();
        return step;
    }

    private Otherwise readOtherwise(Step parent, XdmNode node) {
        this.checkAttributes(node, null, false);
        String stepName = this.checkNCName(node.getAttributeValue(px_name));
        Otherwise step = new Otherwise(this.runtime, node, stepName);
        this.checkExtensionAttributes(node, step);
        step.setParentScope((DeclareStep)parent);
        step.parent = parent;
        Vector<XdmNode> rest = this.readSignature(step);
        if (rest == null) {
            throw XProcException.staticError(15, node, "A p:otherwise must contain a subpipeline.");
        }
        for (XdmNode substepNode : rest) {
            Step substep = this.readStep(step, step, substepNode);
            step.addStep(substep);
        }
        step.checkPrimaryIO();
        return step;
    }

    private Group readGroup(Step parent, XdmNode node) {
        this.checkAttributes(node, new String[]{"name"}, false);
        String stepName = this.checkNCName(node.getAttributeValue(_name));
        Group step = new Group(this.runtime, node, stepName);
        this.checkExtensionAttributes(node, step);
        step.setParentScope((DeclareStep)parent);
        step.parent = parent;
        Vector<XdmNode> rest = this.readSignature(step);
        if (rest == null) {
            throw XProcException.staticError(15, node, "A p:group must contain a subpipeline.");
        }
        for (XdmNode substepNode : rest) {
            Step substep = this.readStep(step, step, substepNode);
            step.addStep(substep);
        }
        step.checkPrimaryIO();
        return step;
    }

    private Try readTry(Step parent, XdmNode node) {
        this.checkAttributes(node, new String[]{"name"}, false);
        String stepName = this.checkNCName(node.getAttributeValue(_name));
        Try step = new Try(this.runtime, node, stepName);
        this.checkExtensionAttributes(node, step);
        step.setParentScope((DeclareStep)parent);
        step.parent = parent;
        Vector<XdmNode> rest = this.readSignature(step);
        if (rest == null) {
            throw XProcException.staticError(15, node, "A p:try must contain a subpipeline.");
        }
        for (XdmNode substepNode : rest) {
            Step substep = this.readStep(step, step, substepNode);
            step.addStep(substep);
        }
        step.checkPrimaryIO();
        return step;
    }

    private Catch readCatch(Step parent, XdmNode node) {
        this.checkAttributes(node, new String[]{"name"}, false);
        String stepName = this.checkNCName(node.getAttributeValue(_name));
        Catch step = new Catch(this.runtime, node, stepName);
        this.checkExtensionAttributes(node, step);
        step.setParentScope((DeclareStep)parent);
        step.parent = parent;
        Vector<XdmNode> rest = this.readSignature(step);
        Input input = new Input(this.runtime, step.getNode());
        input.setPort("error");
        input.addBinding(new ErrorBinding(this.runtime, step.getNode()));
        input.setPrimary(false);
        input.setSequence(true);
        step.addInput(input);
        if (rest == null) {
            throw XProcException.staticError(15, node, "A p:catch must contain a subpipeline.");
        }
        for (XdmNode substepNode : rest) {
            Step substep = this.readStep(step, step, substepNode);
            step.addStep(substep);
        }
        step.checkPrimaryIO();
        return step;
    }

    private HashSet<String> checkAttributes(XdmNode node, String[] attrs, boolean optionShortcutsOk) {
        HashSet<String> hash = new HashSet<String>();
        if (attrs != null) {
            hash.addAll(Arrays.asList(attrs));
        }
        HashSet<String> options = null;
        Double version = this.inheritedVersion(node);
        for (XdmNode attr : new AxisNodes(node, Axis.ATTRIBUTE)) {
            QName aname = attr.getNodeName();
            if (XProcConstants.NS_XPROC == node.getNodeName().getNamespaceUri() && aname.equals((Object)_use_when) || XProcConstants.NS_XPROC != node.getNodeName().getNamespaceUri() && aname.equals((Object)p_use_when)) continue;
            if (NamespaceUri.NULL == aname.getNamespaceUri()) {
                if (hash.contains(aname.getLocalName())) continue;
                if (optionShortcutsOk) {
                    if (options == null) {
                        options = new HashSet<String>();
                    }
                    options.add(aname.getLocalName());
                    continue;
                }
                if (version > 1.0) continue;
                this.runtime.error(null, node, "Attribute \"" + aname + "\" not allowed on " + node.getNodeName(), XProcConstants.staticError(8));
                continue;
            }
            if (XProcConstants.NS_XPROC != aname.getNamespaceUri()) continue;
            this.runtime.error(null, node, "Attribute \"" + aname + "\" not allowed on " + node.getNodeName(), XProcConstants.staticError(8));
            return null;
        }
        return options;
    }

    private void checkExtensionAttributes(XdmNode node, SourceArtifact src) {
        for (XdmNode attr : new AxisNodes(node, Axis.ATTRIBUTE)) {
            QName aname = attr.getNodeName();
            if (NamespaceUri.NULL == aname.getNamespaceUri()) continue;
            if (XProcConstants.NS_XPROC == aname.getNamespaceUri()) {
                this.runtime.error(null, node, "Attribute \"" + aname + "\" not allowed on " + node.getNodeName(), XProcConstants.staticError(8));
                continue;
            }
            src.addExtensionAttribute(attr);
        }
    }

    private boolean booleanAttr(String value) {
        return this.booleanAttr(value, false);
    }

    private boolean booleanAttr(String value, boolean defval) {
        if (value == null) {
            return defval;
        }
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        throw new IllegalArgumentException("Boolean value must be 'true' or 'false'.");
    }

    private String checkNCName(String name) {
        if (name != null) {
            try {
                TypeUtils.checkType(this.runtime, name, XProcConstants.xs_NCName, null);
            }
            catch (XProcException xe) {
                throw new XProcException("Invalid name: \"" + name + "\". Step and port names must be NCNames.", xe.getCause());
            }
        }
        return name;
    }

    private void importFunctions(XdmNode node) {
        String href = node.getAttributeValue(_href);
        String ns = node.getAttributeValue(_namespace);
        String type = node.getAttributeValue(_type);
        Processor processor = this.runtime.getProcessor();
        String sed = processor.getUnderlyingConfiguration().getEditionCode();
        if (!"EE".equals(sed)) {
            throw new XProcException("Importing functions is only supported by Saxon EE.");
        }
        try {
            URL url = this.runtime.getStaticBaseURI().resolve(href).toURL();
            URLConnection connection = url.openConnection();
            FunctionLibraryList fl = null;
            if (type.contains("xsl")) {
                SAXSource stylesheet = new SAXSource(new InputSource(connection.getInputStream()));
                XsltCompiler compiler = processor.newXsltCompiler();
                XsltExecutable exec = compiler.compile((Source)stylesheet);
                PreparedStylesheet ps = exec.getUnderlyingCompiledStylesheet();
                fl = ps.getFunctionLibrary();
            } else {
                XQueryCompiler xqcomp = processor.newXQueryCompiler();
                StaticQueryContext sqc = xqcomp.getUnderlyingStaticContext();
                sqc.compileLibrary(connection.getInputStream(), "utf-8");
                XQueryExpression xqe = sqc.compileQuery("import module namespace f='" + ns + "'; .");
                QueryModule qm = xqe.getMainModule();
                fl = qm.getGlobalFunctionLibrary();
            }
            Class<?> pc = Class.forName("com.saxonica.config.ProfessionalConfiguration");
            Class<?> fc = Class.forName("net.sf.saxon.functions.FunctionLibrary");
            Method setBinder = pc.getMethod("setExtensionBinder", String.class, fc);
            setBinder.invoke((Object)processor.getUnderlyingConfiguration(), "xmlcalabash" + importCount, fl);
            ++importCount;
        }
        catch (Exception e) {
            throw new XProcException(e);
        }
    }
}

