/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.DefaultBaseURIMapper;
import com.xmlcalabash.util.RebasedDocument;
import com.xmlcalabash.util.RebasedNode;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.TypeUtils;
import com.xmlcalabash.util.UniqueSystemIdMapper;
import com.xmlcalabash.util.XProcCollectionFinder;
import com.xmlcalabash.util.XProcURIResolver;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Vector;
import java.util.function.Function;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.s9api.Action;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.MessageListener2;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.RawDestination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.ValidationMode;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmEmptySequence;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.xml.sax.InputSource;

@XMLCalabash(name="p:xslt", type="{http://www.w3.org/ns/xproc}xslt")
public class XSLT
extends DefaultStep {
    private static final QName _initial_mode = new QName("", "initial-mode");
    private static final QName _template_name = new QName("", "template-name");
    private static final QName _output_base_uri = new QName("", "output-base-uri");
    private static final QName _version = new QName("", "version");
    private static final QName _content_type = new QName("content-type");
    private static final QName cx_decode = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "decode");
    private ReadablePipe sourcePipe = null;
    private ReadablePipe stylesheetPipe = null;
    private WritablePipe resultPipe = null;
    private WritablePipe secondaryPipe = null;
    private final HashMap<QName, RuntimeValue> params = new HashMap();

    public XSLT(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.sourcePipe = pipe;
        } else {
            this.stylesheetPipe = pipe;
        }
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        if ("result".equals(port)) {
            this.resultPipe = pipe;
        } else {
            this.secondaryPipe = pipe;
        }
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        this.params.put(name, value);
    }

    @Override
    public void reset() {
        this.sourcePipe.resetReader();
        this.stylesheetPipe.resetReader();
        this.resultPipe.resetWriter();
        this.secondaryPipe.resetWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws SaxonApiException {
        super.run();
        XdmNode stylesheet = this.stylesheetPipe.read();
        if (stylesheet == null) {
            throw XProcException.dynamicError(6, this.step.getNode(), "No stylesheet provided.");
        }
        Vector<XdmNode> defaultCollection = new Vector<XdmNode>();
        while (this.sourcePipe.moreDocuments()) {
            defaultCollection.add(this.sourcePipe.read());
        }
        XdmNode document = null;
        if (defaultCollection.size() > 0) {
            document = (XdmNode)defaultCollection.firstElement();
        }
        String version = null;
        if (this.getOption(_version) == null) {
            XdmNode ssroot = S9apiUtils.getDocumentElement(stylesheet);
            if (ssroot != null && (version = ssroot.getAttributeValue(new QName("", "version"))) == null) {
                version = ssroot.getAttributeValue(new QName("http://www.w3.org/1999/XSL/Transform", "version"));
            }
            if (version == null) {
                version = "2.0";
            }
        } else {
            version = this.getOption(_version).getString();
        }
        if ("1.0".equals(version) && defaultCollection.size() > 1) {
            throw XProcException.stepError(39);
        }
        if ("1.0".equals(version) && this.runtime.getUseXslt10Processor()) {
            this.run10(stylesheet, document);
            return;
        }
        QName initialMode = null;
        QName templateName = null;
        String outputBaseURI = null;
        RuntimeValue opt = this.getOption(_initial_mode);
        if (opt != null) {
            initialMode = opt.getQName();
        }
        if ((opt = this.getOption(_template_name)) != null) {
            templateName = opt.getQName();
        }
        if ((opt = this.getOption(_output_base_uri)) != null) {
            outputBaseURI = opt.getString();
        }
        Processor processor = this.runtime.getProcessor();
        Configuration config = processor.getUnderlyingConfiguration();
        this.runtime.getConfigurer().getSaxonConfigurer().configXSLT(config);
        OutputURIResolver uriResolver = config.getOutputURIResolver();
        CollectionFinder collectionFinder = config.getCollectionFinder();
        XProcURIResolver unparsedTextURIResolver = this.runtime.getResolver();
        config.setDefaultCollection("http://xmlcalabash.com/saxon-default-collection");
        config.setCollectionFinder((CollectionFinder)new XProcCollectionFinder(this.runtime, defaultCollection, collectionFinder));
        RawDestination result = new RawDestination();
        try {
            XsltCompiler compiler = this.runtime.getProcessor().newXsltCompiler();
            compiler.setSchemaAware(processor.isSchemaAware());
            XsltExecutable exec = compiler.compile(stylesheet.asSource());
            XsltTransformer transformer = exec.load();
            transformer.setResultDocumentHandler((Function)new DocumentHandler());
            for (QName name : this.params.keySet()) {
                RuntimeValue v = this.params.get(name);
                if (this.runtime.getAllowGeneralExpressions()) {
                    transformer.setParameter(name, v.getValue());
                    continue;
                }
                transformer.setParameter(name, (XdmValue)v.getUntypedAtomic(this.runtime));
            }
            if (document != null) {
                transformer.setInitialContextNode(document);
            }
            transformer.setMessageListener((MessageListener2)new CatchMessages());
            transformer.setDestination((Destination)result);
            if (initialMode != null) {
                transformer.setInitialMode(initialMode);
            }
            if (templateName != null) {
                transformer.setInitialTemplate(templateName);
            }
            if (outputBaseURI != null) {
                transformer.setBaseOutputURI(outputBaseURI);
            }
            transformer.setSchemaValidationMode(ValidationMode.DEFAULT);
            transformer.getUnderlyingController().setUnparsedTextURIResolver((UnparsedTextURIResolver)unparsedTextURIResolver);
            transformer.transform();
        }
        finally {
            config.setCollectionFinder(collectionFinder);
        }
        XdmValue value = result.getXdmValue();
        XdmNode xformed = null;
        if (value != null && value != XdmEmptySequence.getInstance()) {
            TreeWriter docout = new TreeWriter(this.runtime);
            if (document == null) {
                docout.startDocument(null);
            } else {
                docout.startDocument(document.getBaseURI());
            }
            for (XdmValue v : value) {
                if (v instanceof XdmNode) {
                    docout.addSubtree((XdmNode)v);
                    continue;
                }
                throw new XProcException(this.step.getStep(), "p:xslt returned non-XML result");
            }
            docout.endDocument();
            xformed = docout.getResult();
        }
        if (xformed != null) {
            if (this.getOption(_output_base_uri) == null && document != null) {
                DefaultBaseURIMapper bmapper = new DefaultBaseURIMapper(document.getBaseURI().toASCIIString());
                UniqueSystemIdMapper smapper = new UniqueSystemIdMapper();
                TreeInfo tree = xformed.getUnderlyingNode().getTreeInfo();
                RebasedDocument rebaser = new RebasedDocument(tree, bmapper, smapper);
                RebasedNode xfixbase = rebaser.wrap(xformed.getUnderlyingNode());
                xformed = new XdmNode((NodeInfo)xfixbase);
            }
            try {
                S9apiUtils.assertDocument(xformed);
                this.resultPipe.write(xformed);
            }
            catch (XProcException e) {
                if (this.runtime.getAllowTextResults()) {
                    TreeWriter tree = new TreeWriter(this.runtime);
                    tree.startDocument(xformed.getBaseURI());
                    EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
                    attr = attr.put(TypeUtils.attributeInfo(_content_type, "text/plain"));
                    attr = attr.put(TypeUtils.attributeInfo(cx_decode, "true"));
                    tree.addStartElement(XProcConstants.c_result, (AttributeMap)attr);
                    Serializer serializer = this.makeSerializer();
                    serializer.setOutputProperty(Serializer.Property.METHOD, "text");
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    serializer.setOutputStream((OutputStream)baos);
                    try {
                        S9apiUtils.serialize(this.runtime, xformed, serializer);
                    }
                    catch (SaxonApiException e2) {
                        throw new XProcException(e2);
                    }
                    tree.addText(baos.toString());
                    tree.addEndElement();
                    tree.endDocument();
                    this.resultPipe.write(tree.getResult());
                }
                throw new XProcException(this.step.getStep(), "p:xslt returned non-XML result", e.getCause());
            }
        }
    }

    public void run10(XdmNode stylesheet, XdmNode document) {
        try {
            InputSource is = S9apiUtils.xdmToInputSource(this.runtime, stylesheet);
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer transformer = tfactory.newTransformer(new SAXSource(is));
            transformer.setURIResolver(this.runtime.getResolver());
            for (QName name : this.params.keySet()) {
                RuntimeValue v = this.params.get(name);
                transformer.setParameter(name.getClarkName(), v.getString());
            }
            DOMResult result = new DOMResult();
            is = S9apiUtils.xdmToInputSource(this.runtime, document);
            transformer.transform(new SAXSource(is), result);
            DocumentBuilder xdmBuilder = this.runtime.getConfiguration().getProcessor().newDocumentBuilder();
            XdmNode xformed = xdmBuilder.build((Source)new DOMSource(result.getNode()));
            if (xformed != null) {
                this.resultPipe.write(xformed);
            }
        }
        catch (TransformerException | SaxonApiException sae) {
            throw new XProcException(sae);
        }
    }

    class CatchMessages
    implements MessageListener2 {
        public void message(XdmNode content, QName errorCode, boolean terminate, SourceLocator locator) {
            if (XSLT.this.runtime.getShowMessages()) {
                System.err.println(content.toString());
            }
            TreeWriter treeWriter = new TreeWriter(XSLT.this.runtime);
            treeWriter.startDocument(content.getBaseURI());
            treeWriter.addStartElement(XProcConstants.c_error);
            treeWriter.addSubtree(content);
            treeWriter.addEndElement();
            treeWriter.endDocument();
            XSLT.this.step.reportError(treeWriter.getResult());
            XSLT.this.step.info(XSLT.this.step.getNode(), content.toString());
        }
    }

    private class DocumentCloseAction
    implements Action {
        private URI uri = null;
        private XdmDestination destination = null;

        public DocumentCloseAction(URI uri, XdmDestination destination) {
            this.uri = uri;
            this.destination = destination;
        }

        public void act() throws SaxonApiException {
            XdmNode doc = this.destination.getXdmNode();
            DefaultBaseURIMapper bmapper = new DefaultBaseURIMapper(doc.getBaseURI().toASCIIString());
            UniqueSystemIdMapper smapper = new UniqueSystemIdMapper();
            TreeInfo treeinfo = doc.getUnderlyingNode().getTreeInfo();
            RebasedDocument rebaser = new RebasedDocument(treeinfo, bmapper, smapper);
            RebasedNode xfixbase = rebaser.wrap(doc.getUnderlyingNode());
            doc = new XdmNode((NodeInfo)xfixbase);
            try {
                S9apiUtils.assertDocument(doc);
                XSLT.this.secondaryPipe.write(doc);
            }
            catch (XProcException e) {
                if (XSLT.this.runtime.getAllowTextResults()) {
                    TreeWriter tree = new TreeWriter(XSLT.this.runtime);
                    tree.startDocument(doc.getBaseURI());
                    EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
                    attr = attr.put(TypeUtils.attributeInfo(_content_type, "text/plain"));
                    attr = attr.put(TypeUtils.attributeInfo(cx_decode, "true"));
                    tree.addStartElement(XProcConstants.c_result, (AttributeMap)attr);
                    tree.addText(doc.toString());
                    tree.addEndElement();
                    tree.endDocument();
                    XSLT.this.secondaryPipe.write(tree.getResult());
                }
                throw new XProcException(XSLT.this.step.getStep(), "p:xslt returned non-XML secondary result", e.getCause());
            }
        }
    }

    private class DocumentHandler
    implements Function<URI, Destination> {
        private DocumentHandler() {
        }

        @Override
        public Destination apply(URI uri) {
            XdmDestination xdmResult = new XdmDestination();
            xdmResult.setBaseURI(uri);
            xdmResult.onClose((Action)new DocumentCloseAction(uri, xdmResult));
            return xdmResult;
        }
    }
}

