/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.TypeUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

@XMLCalabash(name="p:www-form-urldecode", type="{http://www.w3.org/ns/xproc}www-form-urldecode")
public class WWWFormURLDecode
extends DefaultStep {
    public static final QName _value = new QName("", "value");
    public static final QName _name = new QName("", "name");
    public static final QName c_paramset = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "param-set");
    public static final QName c_param = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "param");
    private static final QName cx_encoding = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "encoding");
    private WritablePipe result = null;

    public WWWFormURLDecode(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String value = this.getOption(_value).getString();
        String encoding = this.step.getExtensionAttribute(cx_encoding);
        if (encoding == null) {
            encoding = "UTF-8";
        }
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(c_paramset);
        if (!"".equals(value)) {
            String[] params;
            for (String p : params = value.split("&")) {
                String val;
                String name;
                int pos = p.indexOf("=");
                if (pos > 0) {
                    name = p.substring(0, pos);
                    val = p.substring(pos + 1);
                    try {
                        name = URLDecoder.decode(name, encoding);
                        val = URLDecoder.decode(val, encoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new XProcException(e);
                    }
                    try {
                        TypeUtils.checkType(this.runtime, name, XProcConstants.xs_NCName, null);
                    }
                    catch (XProcException e) {
                        throw XProcException.stepError(61);
                    }
                }
                throw new XProcException(this.step.getNode(), "Badly formatted parameters");
                EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
                attr = attr.put(TypeUtils.attributeInfo(_name, name));
                attr = attr.put(TypeUtils.attributeInfo(_value, val));
                tree.addStartElement(c_param, (AttributeMap)attr);
                tree.addEndElement();
            }
        }
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }
}

