/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.sun.msv.verifier.jarv.TheFactoryImpl;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.io.IOException;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidateWithRNG
extends DefaultStep {
    private static final QName _assert_valid = new QName("", "assert-valid");
    private static final QName _dtd_compatibility = new QName("", "dtd-compatibility");
    private static final String language = "http://relaxng.org/ns/structure/1.0";
    private ReadablePipe source = null;
    private ReadablePipe schema = null;
    private WritablePipe result = null;
    private URI docBaseURI = null;

    public ValidateWithRNG(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.source = pipe;
        } else if ("schema".equals(port)) {
            this.schema = pipe;
        }
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        XdmNode doc = null;
        try {
            TheFactoryImpl vfactory = new TheFactoryImpl();
            Verifier verifier = null;
            XdmNode schemaNode = this.schema.read();
            InputSource schemaSource = S9apiUtils.xdmToInputSource(this.runtime, schemaNode);
            schemaSource.setSystemId(schemaNode.getBaseURI().toASCIIString());
            Schema docSchema = vfactory.compileSchema(schemaSource);
            verifier = docSchema.newVerifier();
            verifier.setErrorHandler((ErrorHandler)new RNGErrorHandler());
            doc = this.source.read();
            this.docBaseURI = doc.getBaseURI();
            if (!verifier.verify(S9apiUtils.xdmToInputSource(this.runtime, doc))) {
                throw new XProcException(XProcException.err_E0001, "Document is not valid");
            }
            this.result.write(doc);
        }
        catch (IOException | VerifierConfigurationException ex) {
            this.logger.debug(ex.getMessage(), ex);
            throw new XProcException(ex);
        }
        catch (SAXException sx) {
            if (this.getOption(_assert_valid, false)) {
                throw XProcException.stepError(53, sx);
            }
            this.result.write(doc);
        }
    }

    class RNGErrorHandler
    implements ErrorHandler {
        RNGErrorHandler() {
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.error(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            TreeWriter treeWriter = new TreeWriter(ValidateWithRNG.this.runtime);
            treeWriter.startDocument(ValidateWithRNG.this.docBaseURI);
            treeWriter.addStartElement(XProcConstants.c_error);
            treeWriter.addText(e.toString());
            treeWriter.addEndElement();
            treeWriter.endDocument();
            ValidateWithRNG.this.step.reportError(treeWriter.getResult());
            throw e;
        }

        @Override
        public void warning(SAXParseException e) {
        }
    }
}

