/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.xmlcalabash.config.JingConfigurer;
import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.TypeUtils;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@XMLCalabash(name="p:validate-with-relax-ng", type="{http://www.w3.org/ns/xproc}validate-with-relax-ng")
public class ValidateJing
extends DefaultStep {
    private static final QName _assert_valid = new QName("", "assert-valid");
    private static final QName _dtd_attribute_values = new QName("", "dtd-attribute-values");
    private static final QName _dtd_id_idref_warnings = new QName("", "dtd-id-idref-warnings");
    private static final QName _encoding = new QName("encoding");
    private static final QName _line = new QName("line");
    private static final QName _column = new QName("column");
    private ReadablePipe source = null;
    private ReadablePipe schemaSource = null;
    private WritablePipe result = null;
    private URI docBaseURI = null;

    public ValidateJing(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.source = pipe;
        } else if ("schema".equals(port)) {
            this.schemaSource = pipe;
        }
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        XdmNode doc;
        block12: {
            super.run();
            boolean assertValid = this.getOption(_assert_valid, true);
            boolean checkIdRefs = this.getOption(_dtd_id_idref_warnings, false);
            boolean dtdAugment = this.getOption(_dtd_attribute_values, false);
            RNGErrorHandler eh = new RNGErrorHandler();
            PropertyMapBuilder properties = new PropertyMapBuilder();
            properties.put(ValidateProperty.ERROR_HANDLER, (Object)eh);
            properties.put(ValidateProperty.URI_RESOLVER, (Object)this.runtime.getResolver());
            properties.put(ValidateProperty.ENTITY_RESOLVER, (Object)this.runtime.getResolver());
            if (checkIdRefs) {
                RngProperty.CHECK_ID_IDREF.add(properties);
            }
            doc = this.source.read();
            XdmNode schema = this.schemaSource.read();
            XdmNode root = S9apiUtils.getDocumentElement(schema);
            assert (root != null);
            this.docBaseURI = doc.getBaseURI();
            SchemaReader sr = null;
            boolean compact = XProcConstants.c_data.equals((Object)root.getNodeName());
            String contentType = root.getAttributeValue(XProcConstants.c_content_type);
            if (contentType != null) {
                compact |= contentType.startsWith("text/") || contentType.equals("application/relax-ng-compact-syntax");
            }
            InputSource schemaInputSource = null;
            JingConfigurer configurer = this.runtime.getConfigurer().getJingConfigurer();
            if (compact) {
                configurer.configRNC(properties);
                sr = CompactSchemaReader.getInstance();
                StringReader srdr = new StringReader(this.compactSchema(root));
                schemaInputSource = new InputSource(srdr);
                schemaInputSource.setSystemId(root.getBaseURI().toASCIIString());
            } else {
                configurer.configRNG(properties);
                sr = new AutoSchemaReader();
                schemaInputSource = S9apiUtils.xdmToInputSource(this.runtime, schema);
            }
            ValidationDriver driver = new ValidationDriver(properties.toPropertyMap(), sr);
            try {
                if (driver.loadSchema(schemaInputSource)) {
                    InputSource din = S9apiUtils.xdmToInputSource(this.runtime, doc);
                    if (!driver.validate(din) && assertValid) {
                        throw XProcException.stepError(53, eh.getErr());
                    }
                    break block12;
                }
                throw new XProcException(this.step.getNode(), "Error loading schema");
            }
            catch (SAXParseException e) {
                if (assertValid) {
                    throw XProcException.stepError(53, e);
                }
            }
            catch (SAXException e) {
                throw new XProcException("SAX Exception", (Throwable)e);
            }
            catch (IOException e) {
                throw new XProcException("IO Exception", (Throwable)e);
            }
        }
        this.result.write(doc);
    }

    private String compactSchema(XdmNode doc) {
        if ("base64".equals(doc.getAttributeValue(_encoding))) {
            byte[] decoded = Base64.decode(doc.getStringValue());
            String s = new String(decoded);
            return s;
        }
        return doc.getStringValue();
    }

    class RNGErrorHandler
    implements ErrorHandler {
        SAXParseException err = null;

        RNGErrorHandler() {
        }

        public SAXParseException getErr() {
            return this.err;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.error(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            if (ValidateJing.this.runtime.getShowMessages()) {
                System.err.println(e.getMessage());
            }
            EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
            TreeWriter treeWriter = new TreeWriter(ValidateJing.this.runtime);
            treeWriter.startDocument(ValidateJing.this.docBaseURI);
            if (e.getLineNumber() != -1) {
                attr = attr.put(TypeUtils.attributeInfo(_line, "" + e.getLineNumber()));
            }
            if (e.getColumnNumber() != -1) {
                attr = attr.put(TypeUtils.attributeInfo(_column, "" + e.getColumnNumber()));
            }
            treeWriter.addStartElement(XProcConstants.c_error, (AttributeMap)attr);
            treeWriter.addText(e.toString());
            treeWriter.addEndElement();
            treeWriter.endDocument();
            ValidateJing.this.step.reportError(treeWriter.getResult());
            if (this.err == null) {
                this.err = e;
            }
        }

        @Override
        public void warning(SAXParseException e) {
            if (ValidateJing.this.runtime.getShowMessages()) {
                System.err.println(e.getMessage());
            }
        }
    }
}

