/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.URIUtils;
import java.net.URI;
import java.util.ArrayList;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;

@XMLCalabash(name="p:make-absolute-uris", type="{http://www.w3.org/ns/xproc}make-absolute-uris")
public class MakeAbsoluteURIs
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _match = new QName("", "match");
    private static final QName _base_uri = new QName("", "base-uri");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private ProcessMatch matcher = null;
    private URI setBaseURI = null;

    public MakeAbsoluteURIs(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        XdmNode doc = this.source.read();
        RuntimeValue base = this.getOption(_base_uri);
        if (base != null) {
            this.setBaseURI = base.getBaseURI().resolve(base.getString());
        }
        this.logger.trace(MessageFormatter.nodeMessage(doc, "Making URIs absolute against: " + this.setBaseURI));
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(doc, this.getOption(_match));
        if (this.source.moreDocuments()) {
            throw XProcException.dynamicError(6, "Reading source on " + this.getStep().getName());
        }
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode node) {
        return true;
    }

    @Override
    public void processEndDocument(XdmNode node) {
    }

    @Override
    public AttributeMap processAttributes(XdmNode node, AttributeMap matchingAttributes, AttributeMap nonMatchingAttributes) {
        ArrayList<AttributeInfo> alist = new ArrayList<AttributeInfo>();
        for (AttributeInfo attr : nonMatchingAttributes) {
            alist.add(attr);
        }
        for (AttributeInfo attr : matchingAttributes) {
            String value = attr.getValue();
            value = URIUtils.encode(value);
            URI baseURI = this.setBaseURI == null ? node.getBaseURI() : this.setBaseURI;
            String resolved = baseURI.resolve(value).toString();
            alist.add(new AttributeInfo(attr.getNodeName(), (SimpleType)BuiltInAtomicType.ANY_ATOMIC, resolved, attr.getLocation(), 0));
        }
        return S9apiUtils.mapFromList(alist);
    }

    @Override
    public boolean processStartElement(XdmNode node, AttributeMap attributes) {
        this.matcher.addStartElement(node, attributes);
        String value = node.getStringValue();
        value = URIUtils.encode(value);
        URI baseURI = this.setBaseURI == null ? node.getBaseURI() : this.setBaseURI;
        String resolved = baseURI.resolve(value).toString();
        this.matcher.addText(resolved);
        return false;
    }

    @Override
    public void processEndElement(XdmNode node) {
        this.matcher.addEndElement();
    }

    @Override
    public void processText(XdmNode node) {
        throw XProcException.stepError(23);
    }

    @Override
    public void processComment(XdmNode node) {
        throw XProcException.stepError(23);
    }

    @Override
    public void processPI(XdmNode node) {
        throw XProcException.stepError(23);
    }
}

