/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;

@XMLCalabash(name="p:label-elements", type="{http://www.w3.org/ns/xproc}label-elements")
public class LabelElements
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _attribute = new QName("attribute");
    private static final QName _attribute_prefix = new QName("attribute-prefix");
    private static final QName _attribute_namespace = new QName("attribute-namespace");
    private static final QName _match = new QName("match");
    private static final QName _label = new QName("label");
    private static final QName _replace = new QName("replace");
    private static final QName p_index = XProcConstants.qNameFor(XProcConstants.NS_XPROC, "index");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private ProcessMatch matcher = null;
    private QName attribute = null;
    private RuntimeValue label = null;
    private boolean replace = true;
    private int count = 1;

    public LabelElements(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue attrNameValue = this.getOption(_attribute);
        String attrNameStr = attrNameValue.getString();
        String apfx = this.getOption(_attribute_prefix, (String)null);
        String ans = this.getOption(_attribute_namespace, (String)null);
        if (apfx != null && ans == null) {
            throw XProcException.dynamicError(34, "You can't specify a prefix without a namespace");
        }
        if (ans != null && attrNameStr.contains(":")) {
            throw XProcException.dynamicError(34, "You can't specify a namespace if the attribute name contains a colon");
        }
        if (attrNameStr.contains(":")) {
            this.attribute = new QName(attrNameStr, attrNameValue.getNode());
        } else {
            if (apfx == null && ans != null) {
                apfx = "_1";
            }
            this.attribute = new QName(apfx == null ? "" : apfx, ans, attrNameStr);
        }
        this.label = this.getOption(_label);
        this.replace = this.getOption(_replace).getBoolean();
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(this.source.read(), this.getOption(_match));
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode node) {
        throw XProcException.stepError(24);
    }

    @Override
    public void processEndDocument(XdmNode node) {
        throw XProcException.stepError(24);
    }

    @Override
    public AttributeMap processAttributes(XdmNode node, AttributeMap matchingAttributes, AttributeMap nonMatchingAttributes) {
        throw XProcException.stepError(23);
    }

    @Override
    public boolean processStartElement(XdmNode node, AttributeMap attributes) {
        NamespaceMap nsmap = node.getUnderlyingNode().getAllNamespaces();
        EmptyAttributeMap amap = EmptyAttributeMap.getInstance();
        String prefix = this.prefixFor(nsmap, this.attribute.getPrefix(), this.attribute.getNamespaceUri());
        FingerprintedQName aname = new FingerprintedQName(prefix, this.attribute.getNamespaceUri(), this.attribute.getLocalName());
        boolean found = false;
        for (AttributeInfo ainfo : attributes) {
            if (aname.equals(ainfo.getNodeName())) {
                found = true;
                if (this.replace) {
                    amap = amap.put(new AttributeInfo((NodeName)aname, (SimpleType)BuiltInAtomicType.UNTYPED_ATOMIC, this.computedLabel(node), ainfo.getLocation(), 0));
                    continue;
                }
                amap = amap.put(ainfo);
                continue;
            }
            amap = amap.put(ainfo);
        }
        if (!found) {
            amap = amap.put(new AttributeInfo((NodeName)aname, (SimpleType)BuiltInAtomicType.UNTYPED_ATOMIC, this.computedLabel(node), null, 0));
        }
        this.matcher.addStartElement(node, (AttributeMap)amap);
        return true;
    }

    @Override
    public void processEndElement(XdmNode node) {
        this.matcher.addEndElement();
    }

    @Override
    public void processText(XdmNode node) {
        throw XProcException.stepError(23);
    }

    @Override
    public void processComment(XdmNode node) {
        throw XProcException.stepError(23);
    }

    @Override
    public void processPI(XdmNode node) {
        throw XProcException.stepError(23);
    }

    private String computedLabel(XdmNode node) {
        try {
            XPathCompiler xcomp = this.runtime.newXPathCompiler(this.step.getNode().getBaseURI(), this.label.getNamespaceBindings());
            xcomp.declareVariable(p_index);
            XPathExecutable xexec = xcomp.compile(this.label.getString());
            XPathSelector selector = xexec.load();
            selector.setVariable(p_index, (XdmValue)new XdmAtomicValue(this.count++));
            selector.setContextItem((XdmItem)node);
            XdmSequenceIterator values = selector.iterator();
            XdmItem item = (XdmItem)values.next();
            return item.getStringValue();
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
    }
}

