/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;

@XMLCalabash(name="p:insert", type="{http://www.w3.org/ns/xproc}insert")
public class Insert
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _match = new QName("match");
    private static final QName _position = new QName("position");
    private ReadablePipe insertion = null;
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private ProcessMatch matcher = null;
    private String position = null;

    public Insert(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.source = pipe;
        } else {
            this.insertion = pipe;
        }
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        this.position = this.getOption(_position).getString();
        XdmNode doc = this.source.read();
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(doc, this.getOption(_match));
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode node) {
        throw XProcException.stepError(25);
    }

    @Override
    public void processEndDocument(XdmNode node) {
        throw XProcException.stepError(25);
    }

    @Override
    public AttributeMap processAttributes(XdmNode node, AttributeMap matchingAttributes, AttributeMap nonMatchingAttributes) {
        throw XProcException.stepError(23);
    }

    @Override
    public boolean processStartElement(XdmNode node, AttributeMap attributes) {
        if ("before".equals(this.position)) {
            this.doInsert();
        }
        this.matcher.addStartElement(node, attributes);
        if ("first-child".equals(this.position)) {
            this.doInsert();
        }
        return true;
    }

    @Override
    public void processEndElement(XdmNode node) {
        if ("last-child".equals(this.position)) {
            this.doInsert();
        }
        this.matcher.addEndElement();
        if ("after".equals(this.position)) {
            this.doInsert();
        }
    }

    @Override
    public void processText(XdmNode node) {
        this.process(node);
    }

    @Override
    public void processComment(XdmNode node) {
        this.process(node);
    }

    @Override
    public void processPI(XdmNode node) {
        this.process(node);
    }

    private void process(XdmNode node) {
        if ("before".equals(this.position)) {
            this.doInsert();
        }
        if (node.getNodeKind() == XdmNodeKind.COMMENT) {
            this.matcher.addComment(node.getStringValue());
        } else if (node.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION) {
            this.matcher.addPI(node.getNodeName().getLocalName(), node.getStringValue());
        } else if (node.getNodeKind() == XdmNodeKind.TEXT) {
            this.matcher.addText(node.getStringValue());
        } else {
            throw new IllegalArgumentException("What kind of node was that!?");
        }
        if ("after".equals(this.position)) {
            this.doInsert();
        }
        if ("first-child".equals(this.position) || "last-child".equals(this.position)) {
            throw XProcException.stepError(25);
        }
    }

    private void doInsert() {
        while (this.insertion.moreDocuments()) {
            XdmNode doc = this.insertion.read();
            XdmSequenceIterator iter = doc.axisIterator(Axis.CHILD);
            while (iter.hasNext()) {
                XdmNode child = (XdmNode)iter.next();
                this.matcher.addSubtree(child);
            }
        }
        this.insertion.resetReader();
    }
}

