/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.HashUtils;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import com.xmlcalabash.util.S9apiUtils;
import java.util.ArrayList;
import java.util.HashMap;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;

@XMLCalabash(name="p:hash", type="{http://www.w3.org/ns/xproc}hash")
public class Hash
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _value = new QName("", "value");
    private static final QName _algorithm = new QName("", "algorithm");
    private static final QName _version = new QName("", "version");
    private static final QName _match = new QName("", "match");
    private static final QName _crc = new QName("", "crc");
    private static final QName _md = new QName("", "md");
    private static final QName _sha = new QName("", "sha");
    private static final QName _hmac = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "hmac");
    private static final QName _accessKey = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "accessKey");
    private final HashMap<QName, String> params = new HashMap();
    protected static final String logger = "org.xproc.library.hash";
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private ProcessMatch matcher = null;
    private String hash = null;

    public Hash(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        this.params.put(name, value.getString());
    }

    @Override
    public void reset() {
        this.params.clear();
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String value = this.getOption(_value).getString();
        QName algorithm = this.getOption(_algorithm).getQName();
        String version = null;
        if (this.getOption(_version) != null) {
            version = this.getOption(_version).getString();
        }
        if (_crc.equals((Object)algorithm)) {
            this.hash = HashUtils.crc(value.getBytes(), version);
        } else if (_md.equals((Object)algorithm)) {
            this.hash = HashUtils.md(value.getBytes(), version);
        } else if (_sha.equals((Object)algorithm)) {
            this.hash = HashUtils.sha(value.getBytes(), version);
        } else if (_hmac.equals((Object)algorithm)) {
            this.hash = HashUtils.hmac(value.getBytes(), this.params.get(_accessKey));
        } else {
            throw XProcException.dynamicError(36);
        }
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(this.source.read(), this.getOption(_match));
        if (this.source.moreDocuments()) {
            throw XProcException.dynamicError(6, "Reading source on " + this.getStep().getName());
        }
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode node) {
        return true;
    }

    @Override
    public void processEndDocument(XdmNode node) {
    }

    @Override
    public AttributeMap processAttributes(XdmNode node, AttributeMap matchingAttributes, AttributeMap nonMatchingAttributes) {
        ArrayList<AttributeInfo> alist = new ArrayList<AttributeInfo>();
        for (AttributeInfo attr : nonMatchingAttributes) {
            alist.add(attr);
        }
        for (AttributeInfo attr : matchingAttributes) {
            alist.add(new AttributeInfo(attr.getNodeName(), (SimpleType)BuiltInAtomicType.ANY_ATOMIC, this.hash, attr.getLocation(), 0));
        }
        return S9apiUtils.mapFromList(alist);
    }

    @Override
    public boolean processStartElement(XdmNode node, AttributeMap attributes) {
        this.matcher.addText(this.hash);
        return false;
    }

    @Override
    public void processEndElement(XdmNode node) {
    }

    @Override
    public void processText(XdmNode node) {
        this.matcher.addText(this.hash);
    }

    @Override
    public void processComment(XdmNode node) {
        this.matcher.addComment(this.hash);
    }

    @Override
    public void processPI(XdmNode node) {
        this.matcher.addPI(node.getNodeName().getLocalName(), this.hash);
    }
}

