/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.AxisNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.io.StringWriter;
import java.io.Writer;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;

@XMLCalabash(name="p:escape-markup", type="{http://www.w3.org/ns/xproc}escape-markup")
public class EscapeMarkup
extends DefaultStep {
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public EscapeMarkup(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        Serializer serializer = this.makeSerializer();
        XdmNode doc = this.source.read();
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(doc.getBaseURI());
        for (XdmNode child : new AxisNodes(doc, Axis.CHILD)) {
            if (child.getNodeKind() == XdmNodeKind.COMMENT) {
                tree.addComment(child.getStringValue());
                continue;
            }
            if (child.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION) {
                tree.addPI(child.getNodeName().getLocalName(), child.getStringValue());
                continue;
            }
            if (child.getNodeKind() == XdmNodeKind.TEXT) {
                tree.addText(child.getStringValue());
                continue;
            }
            tree.addStartElement(child, child.getUnderlyingNode().attributes());
            StringWriter sw = new StringWriter();
            serializer.setOutputWriter((Writer)sw);
            S9apiUtils.serialize(this.runtime, child, serializer);
            String data = sw.toString();
            data = data.replaceAll("^<.*?>", "");
            data = data.replaceAll("<[^<>]*?>$", "");
            tree.addText(data);
            tree.addEndElement();
        }
        tree.endDocument();
        this.result.write(tree.getResult());
    }
}

