/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.TypeUtils;
import com.xmlcalabash.util.URIUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.om.SingletonAttributeMap;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

@XMLCalabash(name="p:directory-list", type="{http://www.w3.org/ns/xproc}directory-list")
public class DirectoryList
extends DefaultStep {
    private static final QName _name = new QName("", "name");
    private static final QName _path = new QName("", "path");
    private static final QName _include_filter = new QName("", "include-filter");
    private static final QName _exclude_filter = new QName("", "exclude-filter");
    private static final QName c_directory = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "directory");
    private static final QName c_file = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "file");
    private static final QName px_show_excluded = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "show-excluded");
    private WritablePipe result = null;
    private String inclFilter = null;
    private String exclFilter = null;

    public DirectoryList(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        String path = ".";
        if (this.getOption(_path) != null) {
            URI pathbase = this.getOption(_path).getBaseURI();
            String pathstr = URIUtils.encode(this.getOption(_path).getString());
            path = pathbase.resolve(pathstr).toASCIIString();
        } else {
            path = this.step.getNode().getBaseURI().resolve(".").toASCIIString();
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "path: " + path));
        RuntimeValue value = this.getOption(_include_filter);
        if (value != null) {
            this.inclFilter = value.getString();
            this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "include: " + this.inclFilter));
        }
        if ((value = this.getOption(_exclude_filter)) != null) {
            this.exclFilter = value.getString();
            this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "exclude: " + this.exclFilter));
        }
        final boolean showExcluded = "true".equals(this.step.getExtensionAttribute(px_show_excluded));
        URI uri = URI.create("file:///").resolve(path);
        final TreeWriter tree = new TreeWriter(this.runtime);
        EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
        tree.startDocument(this.step.getNode().getBaseURI());
        attr = attr.put(TypeUtils.attributeInfo(_name, this.getName(uri)));
        attr = attr.put(TypeUtils.attributeInfo(XProcConstants.xml_base, uri.toASCIIString()));
        tree.addStartElement(c_directory, (AttributeMap)attr);
        DataStore store = this.runtime.getDataStore();
        try {
            store.listEachEntry(path, "file:///", "*/*", new DataStore.DataInfo(){

                @Override
                public void list(URI id, String media, long lastModified) throws IOException {
                    boolean use = true;
                    String filename = DirectoryList.this.getName(id);
                    DirectoryList.this.logger.trace(MessageFormatter.nodeMessage(DirectoryList.this.step.getNode(), "name: " + filename));
                    if (DirectoryList.this.inclFilter != null) {
                        use = filename.matches(DirectoryList.this.inclFilter);
                        DirectoryList.this.logger.trace(MessageFormatter.nodeMessage(DirectoryList.this.step.getNode(), "include: " + use));
                    }
                    if (DirectoryList.this.exclFilter != null) {
                        use = use && !filename.matches(DirectoryList.this.exclFilter);
                        DirectoryList.this.logger.trace(MessageFormatter.nodeMessage(DirectoryList.this.step.getNode(), "exclude: " + !use));
                    }
                    if (use) {
                        if (!DirectoryList.this.isFile(id)) {
                            tree.addStartElement(c_directory, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_name, filename)));
                            tree.addEndElement();
                            DirectoryList.this.logger.trace(MessageFormatter.nodeMessage(DirectoryList.this.step.getNode(), "Including directory: " + filename));
                        } else {
                            tree.addStartElement(c_file, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_name, filename)));
                            tree.addEndElement();
                            DirectoryList.this.logger.trace(MessageFormatter.nodeMessage(DirectoryList.this.step.getNode(), "Including file: " + filename));
                        }
                    } else if (showExcluded) {
                        tree.addComment(" excluded: " + filename + " ");
                        DirectoryList.this.logger.trace(MessageFormatter.nodeMessage(DirectoryList.this.step.getNode(), "Excluding: " + filename));
                    }
                }
            });
        }
        catch (FileNotFoundException e) {
            throw XProcException.stepError(17);
        }
        catch (IOException e) {
            throw XProcException.stepError(12);
        }
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }

    String getName(URI id) {
        String path = id.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path.replaceAll("^.*/", "");
    }

    boolean isFile(URI id) throws IOException {
        String entry = id.toASCIIString();
        final ArrayList entries = new ArrayList();
        DataStore store = this.runtime.getDataStore();
        store.infoEntry(entry, entry, "*/*", new DataStore.DataInfo(){

            @Override
            public void list(URI id, String media, long lastModified) {
                if (media != null) {
                    entries.add(media);
                }
            }
        });
        return !entries.isEmpty();
    }
}

