/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TypeUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Stack;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;

@XMLCalabash(name="p:add-xml-base", type="{http://www.w3.org/ns/xproc}add-xml-base")
public class AddXmlBase
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName xml_base = new QName("xml", "http://www.w3.org/XML/1998/namespace", "base");
    private static final QName _all = new QName("", "all");
    private static final QName _relative = new QName("", "relative");
    private ProcessMatch matcher = null;
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private boolean all = false;
    private boolean relative = false;
    private Stack<URI> baseURIStack = new Stack();

    public AddXmlBase(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        this.all = this.getOption(_all, false);
        this.relative = this.getOption(_relative, true);
        if (this.all && this.relative) {
            throw XProcException.stepError(58);
        }
        this.matcher = new ProcessMatch(this.runtime, this);
        XdmNode idoc = this.source.read();
        this.matcher.match(idoc, new RuntimeValue("*", this.step.getNode()));
        XdmNode doc = this.matcher.getResult();
        this.result.write(doc);
    }

    @Override
    public boolean processStartDocument(XdmNode node) {
        return true;
    }

    @Override
    public void processEndDocument(XdmNode node) {
    }

    @Override
    public AttributeMap processAttributes(XdmNode node, AttributeMap matchingAttributes, AttributeMap nonMatchingAttributes) {
        throw new UnsupportedOperationException("This can't happen");
    }

    @Override
    public boolean processStartElement(XdmNode node, AttributeMap attributes) {
        boolean addXmlBase;
        String xmlBase = node.getBaseURI().normalize().toASCIIString();
        boolean bl = addXmlBase = this.all || this.baseURIStack.size() == 0;
        if (!addXmlBase) {
            boolean bl2 = addXmlBase = !this.baseURIStack.peek().equals(node.getBaseURI());
        }
        if (addXmlBase && this.relative && this.baseURIStack.size() > 0) {
            URI relURI = node.getBaseURI();
            String p1 = this.baseURIStack.peek().toASCIIString();
            String p2 = relURI.toASCIIString();
            boolean commonancestor = false;
            int i1 = p1.indexOf("/");
            int i2 = p2.indexOf("/");
            while (i1 >= 0 && i2 >= 0 && p1.substring(0, i1).equals(p2.substring(0, i2))) {
                commonancestor = true;
                p1 = p1.substring(i1 + 1);
                p2 = p2.substring(i2 + 1);
                i1 = p1.indexOf("/");
                i2 = p2.indexOf("/");
            }
            if (commonancestor) {
                StringBuilder walkUp = new StringBuilder();
                i1 = p1.indexOf("/");
                while (i1 >= 0) {
                    walkUp.append("../");
                    p1 = p1.substring(i1 + 1);
                    i1 = p1.indexOf("/");
                }
                xmlBase = walkUp + p2;
                p1 = "5";
            } else {
                xmlBase = relURI.toASCIIString();
            }
        }
        this.baseURIStack.push(node.getBaseURI());
        ArrayList<AttributeInfo> alist = new ArrayList<AttributeInfo>();
        FingerprintedQName fq_xml_base = TypeUtils.fqName(xml_base);
        boolean found = false;
        for (AttributeInfo ainfo : attributes) {
            if (ainfo.getNodeName().equals(fq_xml_base)) {
                found = true;
                if (!this.all && !addXmlBase && ainfo.getValue().equals(xmlBase) || "".equals(xmlBase)) continue;
                alist.add(new AttributeInfo((NodeName)fq_xml_base, (SimpleType)BuiltInAtomicType.ANY_ATOMIC, xmlBase, null, 0));
                continue;
            }
            alist.add(ainfo);
        }
        if (!found && addXmlBase) {
            alist.add(new AttributeInfo((NodeName)fq_xml_base, (SimpleType)BuiltInAtomicType.ANY_ATOMIC, xmlBase, null, 0));
        }
        this.matcher.addStartElement(node, S9apiUtils.mapFromList(alist));
        return true;
    }

    @Override
    public void processEndElement(XdmNode node) {
        this.matcher.addEndElement();
        this.baseURIStack.pop();
    }

    @Override
    public void processText(XdmNode node) {
        throw new UnsupportedOperationException("This can't happen");
    }

    @Override
    public void processComment(XdmNode node) {
        throw new UnsupportedOperationException("This can't happen");
    }

    @Override
    public void processPI(XdmNode node) {
        throw new UnsupportedOperationException("This can't happen");
    }
}

