/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.MessageFormatter;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pipe
implements ReadablePipe,
WritablePipe {
    private Logger logger = LoggerFactory.getLogger(Pipe.class);
    private static int idCounter = 0;
    private int id = 0;
    private XProcRuntime runtime = null;
    private DocumentSequence documents = null;
    private int pos = 0;
    private boolean readSeqOk = false;
    private boolean writeSeqOk = false;
    private Step writer = null;
    private Step reader = null;
    private String stepName = null;
    private String portName = null;

    public Pipe(XProcRuntime xproc) {
        this.runtime = xproc;
        this.documents = new DocumentSequence(xproc);
        this.documents.addReader();
        this.id = idCounter++;
    }

    public Pipe(XProcRuntime xproc, DocumentSequence seq) {
        this.runtime = xproc;
        this.documents = seq;
        seq.addReader();
        this.id = ++idCounter;
    }

    @Override
    public void setReader(Step step) {
        this.reader = step;
    }

    @Override
    public void setWriter(Step step) {
        this.writer = step;
    }

    @Override
    public void setNames(String stepName, String portName) {
        this.stepName = stepName;
        this.portName = portName;
    }

    @Override
    public void canWriteSequence(boolean sequence) {
        this.writeSeqOk = sequence;
    }

    @Override
    public void resetReader() {
        this.pos = 0;
    }

    @Override
    public void resetWriter() {
        this.documents.reset();
        this.pos = 0;
    }

    @Override
    public void canReadSequence(boolean sequence) {
        this.readSeqOk = sequence;
    }

    @Override
    public boolean readSequence() {
        return this.readSeqOk;
    }

    @Override
    public boolean writeSequence() {
        return this.writeSeqOk;
    }

    @Override
    public boolean moreDocuments() {
        return this.pos < this.documents.size();
    }

    @Override
    public boolean closed() {
        return this.documents.closed();
    }

    @Override
    public void close() {
        this.documents.close();
    }

    @Override
    public int documentCount() {
        return this.documents.size();
    }

    @Override
    public DocumentSequence documents() {
        return this.documents;
    }

    @Override
    public XdmNode read() {
        if (this.pos > 0 && !this.readSeqOk) {
            this.dynamicError(6);
        }
        XdmNode doc = this.documents.get(this.pos++);
        if (this.reader != null) {
            this.logger.trace(MessageFormatter.nodeMessage(this.reader.getNode(), this.reader.getName() + " read '" + (doc == null ? "null" : doc.getBaseURI()) + "' from " + this));
        }
        return doc;
    }

    @Override
    public void write(XdmNode doc) {
        if (this.writer != null) {
            this.logger.trace(MessageFormatter.nodeMessage(this.writer.getNode(), this.writer.getName() + " wrote '" + (doc == null ? "null" : doc.getBaseURI()) + "' to " + this));
        }
        this.documents.add(doc);
        if (this.documents.size() > 1 && !this.writeSeqOk) {
            this.dynamicError(7);
        }
    }

    public String toString() {
        return "[pipe #" + this.id + "] (" + this.documents + ")";
    }

    private void dynamicError(int errno) {
        String msg = null;
        if (this.stepName != null) {
            msg = "Reading " + this.portName + " on " + this.stepName;
        }
        throw XProcException.dynamicError(errno, msg);
    }
}

