/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.fileutils;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

@XMLCalabash(name="pxf:delete", type="{http://exproc.org/proposed/steps/file}delete {http://xmlcalabash.com/ns/extensions/fileutils}delete")
public class Delete
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _recursive = new QName("recursive");
    private static final QName _fail_on_error = new QName("fail-on-error");
    private WritablePipe result = null;

    public Delete(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        boolean recursive = this.getOption(_recursive, false);
        boolean fail_on_error = this.getOption(_fail_on_error, true);
        RuntimeValue href = this.getOption(_href);
        String base = href.getBaseURI().toASCIIString();
        URI uri = href.getBaseURI().resolve(href.getString());
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(XProcConstants.c_result);
        tree.addText(uri.toASCIIString());
        this.performDelete(href, base, recursive, fail_on_error);
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }

    private void performDelete(RuntimeValue href, String base, boolean recursive, boolean fail_on_error) {
        block13: {
            DataStore store;
            block12: {
                store = this.runtime.getDataStore();
                if (recursive) {
                    try {
                        for (String entry : this.getAllEntries(href.getString(), base)) {
                            store.deleteEntry(entry, entry);
                        }
                    }
                    catch (FileNotFoundException e) {
                        if (fail_on_error) {
                            throw new XProcException(this.step.getNode(), "Cannot delete: file does not exist", (Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        if (fail_on_error) {
                            throw new XProcException(this.step.getNode(), (Throwable)e);
                        }
                    }
                    catch (XProcException e) {
                        if (!fail_on_error) break block12;
                        throw e;
                    }
                }
            }
            try {
                store.deleteEntry(href.getString(), base);
            }
            catch (FileNotFoundException e) {
                if (fail_on_error) {
                    throw new XProcException(this.step.getNode(), "Cannot delete: file does not exist", (Throwable)e);
                }
            }
            catch (IOException e) {
                if (!fail_on_error) break block13;
                throw new XProcException(this.step.getNode(), (Throwable)e);
            }
        }
    }

    private List<String> getAllEntries(String href, String base) throws MalformedURLException, FileNotFoundException, IOException {
        final ArrayList<String> entries = new ArrayList<String>();
        DataStore store = this.runtime.getDataStore();
        store.listEachEntry(href, base, "*/*", new DataStore.DataInfo(){

            @Override
            public void list(URI id, String media, long lastModified) throws IOException {
                String entry = id.toASCIIString();
                try {
                    entries.addAll(Delete.this.getAllEntries(entry, entry));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                entries.add(entry);
            }
        });
        return entries;
    }
}

